/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.roydesign.event.ApplicationEvent;
import net.roydesign.mac.MRJAdapter;

public class MacEventHandler {
    private static MacEventHandler INSTANCE;
    private volatile File lastFileOpened = null;
    private volatile boolean enabled;
    private volatile ExternalControl externalControl = null;
    private volatile Initializer initializer = null;

    public static synchronized MacEventHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new MacEventHandler();
        }
        return INSTANCE;
    }

    private MacEventHandler() {
        MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleAbout();
            }
        });
        MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleQuit();
            }
        });
        MRJAdapter.addOpenDocumentListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                File file = ((ApplicationEvent)evt).getFile();
                MacEventHandler.this.handleOpenFile(file);
            }
        });
        MRJAdapter.addReopenApplicationListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleReopen();
            }
        });
    }

    public void enable(ExternalControl externalControl, Initializer initializer) {
        this.externalControl = externalControl;
        this.initializer = initializer;
        this.enabled = true;
        if (this.lastFileOpened != null) {
            this.runFileOpen(this.lastFileOpened);
        }
    }

    public void enablePreferences() {
        MRJAdapter.setPreferencesEnabled((boolean)true);
        MRJAdapter.addPreferencesListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handlePreferences();
            }
        });
    }

    private void handleAbout() {
        GUIMediator.showAboutWindow();
    }

    private void handleQuit() {
        GUIMediator.applyWindowSettings();
        GUIMediator.close(false);
    }

    private void handleOpenFile(File file) {
        if (!this.enabled) {
            this.lastFileOpened = file;
        } else {
            this.runFileOpen(file);
        }
    }

    private void runFileOpen(File file) {
        String filename = file.getPath();
        if (filename.endsWith("limestart")) {
            this.initializer.setStartup();
        } else if (filename.endsWith("torrent")) {
            if (!GUIMediator.isConstructed() || !GuiCoreMediator.getLifecycleManager().isStarted()) {
                this.externalControl.enqueueControlRequest(file.getAbsolutePath());
            } else {
                GUIMediator.instance().openTorrent(file);
            }
        } else {
            PackagedMediaFileLauncher.launchFile(filename, false);
        }
    }

    private void handleReopen() {
        GUIMediator.handleReopen();
    }

    private void handlePreferences() {
        GUIMediator.instance().setOptionsVisible(true);
    }
}

