/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.UpdateManager;
import com.frostwire.gnutella.gui.chat.ChatMediator;
import com.frostwire.gnutella.gui.tabs.ChatTab;
import com.limegroup.gnutella.gui.Console;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.PowerManager;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.TransferHandlerDropTargetListener;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.logging.LoggingMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tabs.ConnectionsTab;
import com.limegroup.gnutella.gui.tabs.ConsoleTab;
import com.limegroup.gnutella.gui.tabs.LibraryPlayListTab;
import com.limegroup.gnutella.gui.tabs.LoggingTab;
import com.limegroup.gnutella.gui.tabs.MonitorUploadTab;
import com.limegroup.gnutella.gui.tabs.SearchDownloadTab;
import com.limegroup.gnutella.gui.tabs.Tab;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.SWTBrowserSettings;
import com.limegroup.gnutella.util.LogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;

public final class MainFrame
implements RefreshListener,
ThemeObserver {
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private final SearchMediator SEARCH_MEDIATOR = new SearchMediator();
    private final DownloadMediator DOWNLOAD_MEDIATOR = DownloadMediator.instance();
    private final MonitorView MONITOR_VIEW = new MonitorView();
    private final UploadMediator UPLOAD_MEDIATOR = UploadMediator.instance();
    private final ConnectionMediator CONNECTION_MEDIATOR = ConnectionMediator.instance();
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final ChatMediator CHAT_MEDIATOR = ChatMediator.instance();
    private final LoggingMediator LOGGING_MEDIATOR = LoggingMediator.instance();
    private final OptionsMediator OPTIONS_MEDIATOR = OptionsMediator.instance();
    private final StatusLine STATUS_LINE = new StatusLine(GuiCoreMediator.getNetworkManager());
    private final MenuMediator MENU_MEDIATOR = MenuMediator.instance();
    private final JFrame FRAME;
    private boolean isDownloadViewVisible = false;
    private final LogoPanel LOGO_PANEL = new LogoPanel();
    private Map<GUIMediator.Tabs, Tab> TABS = new HashMap<GUIMediator.Tabs, Tab>(7);
    private int height;
    private boolean isSearching = false;
    private WindowState lastState = null;

    MainFrame(JFrame frame) {
        this.FRAME = frame;
        new DropTarget(this.FRAME, new TransferHandlerDropTargetListener(DNDUtils.DEFAULT_TRANSFER_HANDLER));
        this.buildTabs();
        this.TABBED_PANE.setPreferredSize(new Dimension(10000, 10000));
        this.FRAME.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
                MainFrame.this.setSearchIconLocation();
            }

            public void componentMoved(ComponentEvent e) {
                MainFrame.this.lastState = new WindowState();
                MainFrame.this.saveWindowState();
            }

            public void componentResized(ComponentEvent e) {
                MainFrame.this.saveWindowState();
                MainFrame.this.setSearchIconLocation();
            }
        });
        this.FRAME.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent e) {
                MainFrame.this.saveWindowState();
            }
        });
        this.FRAME.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent e) {
                if (!OSUtils.supportsTray() || !ResourceManager.instance().isTrayIconAvailable()) {
                    GUIMediator.restoreView();
                }
            }

            public void windowClosing(WindowEvent e) {
                MainFrame.this.saveWindowState();
                SettingsGroupManager.instance().save();
                GUIMediator.close(true);
            }
        });
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Tab tab = (Tab)evt.getSource();
                int idx = MainFrame.this.getTabIndex(tab);
                if (idx != -1) {
                    if ("title".equals(evt.getPropertyName())) {
                        MainFrame.this.TABBED_PANE.setTitleAt(idx, (String)evt.getNewValue());
                    } else if ("tooltip".equals(evt.getPropertyName())) {
                        MainFrame.this.TABBED_PANE.setToolTipTextAt(idx, (String)evt.getNewValue());
                    }
                }
            }
        };
        for (GUIMediator.Tabs tab : GUIMediator.Tabs.values()) {
            Tab t = this.TABS.get((Object)tab);
            if (t == null) continue;
            this.addTab(t);
            t.addPropertyChangeListener(propertyChangeListener);
        }
        this.TABBED_PANE.setRequestFocusEnabled(false);
        this.TABBED_PANE.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                Tab tab;
                TabbedPaneUI ui = MainFrame.this.TABBED_PANE.getUI();
                int idx = ui.tabForCoordinate(MainFrame.this.TABBED_PANE, e.getX(), e.getY());
                if (idx != -1 && (tab = MainFrame.this.getTabForIndex(idx)) != null) {
                    tab.mouseClicked();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        if (!ApplicationSettings.MONITOR_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.MONITOR, false);
        }
        if (!ApplicationSettings.CONNECTION_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.CONNECTION, false);
        }
        if (!ApplicationSettings.LIBRARY_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.LIBRARY, false);
        }
        if (LogUtils.isLog4JAvailable() && !ApplicationSettings.CONSOLE_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.CONSOLE, false);
        }
        if (!ApplicationSettings.LOGGING_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.LOGGING, false);
        }
        if (SWTBrowserSettings.USE_SWT_BROWSER.getValue() && GUIMediator.isBrowserCapable() && !ApplicationSettings.SWT_BROWSER_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.FROSTCLICK, false);
        }
        if (!ApplicationSettings.CHAT_VIEW_ENABLED.getValue()) {
            this.setTabVisible(GUIMediator.Tabs.CHAT, false);
        }
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        JPanel contentPane = new JPanel();
        this.FRAME.setContentPane(contentPane);
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        contentPane.add((Component)this.TABBED_PANE, gbc);
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        gbc.fill = 2;
        contentPane.add((Component)this.STATUS_LINE.getComponent(), gbc);
        JLayeredPane layeredPane = JLayeredPane.getLayeredPaneAbove(this.TABBED_PANE);
        layeredPane.add(this.LOGO_PANEL, JLayeredPane.PALETTE_LAYER, 0);
        ThemeMediator.addThemeObserver(this);
        GUIMediator.addRefreshListener(this);
        this.updateLogoHeight();
        if (ApplicationSettings.MAGNET_CLIPBOARD_LISTENER.getValue()) {
            this.FRAME.addWindowListener(MagnetClipboardListener.getInstance());
        }
        PowerManager pm = new PowerManager();
        this.FRAME.addWindowListener(pm);
        GUIMediator.addRefreshListener(pm);
        UpdateManager.scheduleUpdateCheckTask(10);
    }

    void saveWindowState() {
        int state = this.FRAME.getExtendedState();
        if (state == 0) {
            Dimension dim = GUIMediator.getAppSize();
            if (dim.height > 100 && dim.width > 100) {
                Point loc = GUIMediator.getAppLocation();
                ApplicationSettings.APP_WIDTH.setValue(dim.width);
                ApplicationSettings.APP_HEIGHT.setValue(dim.height);
                ApplicationSettings.WINDOW_X.setValue(loc.x);
                ApplicationSettings.WINDOW_Y.setValue(loc.y);
                ApplicationSettings.MAXIMIZE_WINDOW.setValue(false);
            }
        } else if ((state & 6) == 6) {
            ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            if (this.lastState != null && this.lastState.time == System.currentTimeMillis()) {
                ApplicationSettings.WINDOW_X.setValue(this.lastState.x);
                ApplicationSettings.WINDOW_Y.setValue(this.lastState.y);
                this.lastState = null;
            }
        }
    }

    public void updateTheme() {
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        this.LOGO_PANEL.updateTheme();
        this.setSearchIconLocation();
        this.updateLogoHeight();
        for (GUIMediator.Tabs tab : GUIMediator.Tabs.values()) {
            this.updateTabIcon(tab);
        }
    }

    private void updateLogoHeight() {
        Rectangle rect = this.TABBED_PANE.getUI().getTabBounds(this.TABBED_PANE, 0);
        Dimension ld = this.LOGO_PANEL.getPreferredSize();
        int height = ld.height + 4;
        this.height = Math.max(rect.height, height);
        if (rect.height < height) {
            this.TABBED_PANE.setBorder(BorderFactory.createEmptyBorder(height - rect.height, 0, 0, 0));
        } else {
            this.TABBED_PANE.setBorder(null);
        }
    }

    private void buildTabs() {
        this.TABS.put(GUIMediator.Tabs.SEARCH, new SearchDownloadTab(this.SEARCH_MEDIATOR, this.DOWNLOAD_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.MONITOR, new MonitorUploadTab(this.MONITOR_VIEW, this.UPLOAD_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.CONNECTION, new ConnectionsTab(this.CONNECTION_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.LIBRARY, new LibraryPlayListTab(this.LIBRARY_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.CHAT, new ChatTab(this.CHAT_MEDIATOR));
        this.TABS.put(GUIMediator.Tabs.LOGGING, new LoggingTab(this.LOGGING_MEDIATOR));
        if (LogUtils.isLog4JAvailable()) {
            Console console = new Console();
            this.TABS.put(GUIMediator.Tabs.CONSOLE, new ConsoleTab(console));
        }
    }

    private void addTab(Tab tab) {
        this.TABBED_PANE.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip());
    }

    private void insertTab(Tab tab, int index) {
        this.TABBED_PANE.insertTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip(), index);
        SwingUtilities.updateComponentTreeUI(this.TABBED_PANE);
        ThemeMediator.updateThemeObservers();
    }

    public final void setSelectedTab(GUIMediator.Tabs tab) {
        int i = this.getTabIndex(tab);
        if (i == -1) {
            return;
        }
        this.TABBED_PANE.setSelectedIndex(i);
    }

    void updateTabIcon(GUIMediator.Tabs tab) {
        Tab t;
        int i = this.getTabIndex(tab);
        if (i != -1 && (t = this.TABS.get((Object)tab)) != null) {
            this.TABBED_PANE.setIconAt(i, t.getIcon());
        }
    }

    private final void setFrameDimensions() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int locX = 0;
        int locY = 0;
        int appWidth = Math.min(screenSize.width - insets.left - insets.right, ApplicationSettings.APP_WIDTH.getValue());
        int appHeight = Math.min(screenSize.height - insets.top - insets.bottom, ApplicationSettings.APP_HEIGHT.getValue());
        if (ApplicationSettings.RUN_ONCE.getValue()) {
            locX = Math.max(insets.left, ApplicationSettings.WINDOW_X.getValue());
            locY = Math.max(insets.top, ApplicationSettings.WINDOW_Y.getValue());
        } else {
            locX = (screenSize.width - appWidth) / 2;
            locY = (screenSize.height - appHeight) / 2;
        }
        if (locX + appWidth > screenSize.width) {
            locX = Math.max(insets.left, screenSize.width - insets.left - insets.right - appWidth);
        }
        if (locY + appHeight > screenSize.height) {
            locY = Math.max(insets.top, screenSize.height - insets.top - insets.bottom - appHeight);
        }
        this.FRAME.setLocation(locX, locY);
        this.FRAME.setSize(new Dimension(appWidth, appHeight));
        this.FRAME.getContentPane().setSize(new Dimension(appWidth, appHeight));
        ((JComponent)this.FRAME.getContentPane()).setPreferredSize(new Dimension(appWidth, appHeight));
        if (ApplicationSettings.MAXIMIZE_WINDOW.getValue() && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            this.FRAME.setExtendedState(6);
        }
    }

    void setTabVisible(GUIMediator.Tabs tabItem, boolean visible) {
        Tab tab = this.TABS.get((Object)tabItem);
        JComponent comp = tab.getComponent();
        int tabCount = this.TABBED_PANE.getTabCount();
        if (!visible) {
            for (int i = 0; i < tabCount; ++i) {
                if (!comp.equals(this.TABBED_PANE.getComponentAt(i))) continue;
                this.TABBED_PANE.remove(i);
                break;
            }
        } else {
            int ordinal = tabItem.ordinal();
            for (int i = 0; i < tabCount; ++i) {
                Component c = this.TABBED_PANE.getComponentAt(i);
                int o = this.getOrdinalForTabComponent(c);
                if (o > ordinal) {
                    this.insertTab(tab, i);
                    break;
                }
                if (i != tabCount - 1) continue;
                this.insertTab(tab, i + 1);
            }
            JComponent jcomp = comp;
            jcomp.invalidate();
            jcomp.revalidate();
            jcomp.repaint();
        }
        tabItem.setEnabled(visible);
        tab.storeState(visible);
    }

    private int getOrdinalForTabComponent(Component c) {
        for (Map.Entry<GUIMediator.Tabs, Tab> entry : this.TABS.entrySet()) {
            if (!entry.getValue().getComponent().equals(c)) continue;
            return entry.getKey().ordinal();
        }
        return -1;
    }

    private int getTabIndex(GUIMediator.Tabs tab) {
        Tab t = this.TABS.get((Object)tab);
        if (t != null) {
            return this.getTabIndex(t);
        }
        return -1;
    }

    private int getTabIndex(Tab tab) {
        int tabCount = this.TABBED_PANE.getTabCount();
        JComponent comp = tab.getComponent();
        for (int i = 0; i < tabCount; ++i) {
            Component tabComp = this.TABBED_PANE.getComponentAt(i);
            if (!tabComp.equals(comp)) continue;
            return i;
        }
        return -1;
    }

    private Tab getTabForIndex(int idx) {
        Component c = this.TABBED_PANE.getComponentAt(idx);
        if (c == null) {
            return null;
        }
        for (Tab tab : this.TABS.values()) {
            if (tab.getComponent() == null || !tab.getComponent().equals(c)) continue;
            return tab;
        }
        return null;
    }

    public void refresh() {
        int count;
        SearchDownloadTab tab;
        if (this.isSearching && (tab = (SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).getDividerLocation() == 0) {
            tab.setDividerLocation(0.5);
            this.isDownloadViewVisible = true;
        }
        if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() == 0 && this.isDownloadViewVisible) {
            ((SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).setDividerLocation(1000);
            this.isDownloadViewVisible = false;
        } else if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() > 0 && !this.isDownloadViewVisible && (count = this.DOWNLOAD_MEDIATOR.getActiveDownloads()) > 0) {
            double prop = count > 6 ? 0.6 : 0.7;
            ((SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).setDividerLocation(prop);
            ((SearchDownloadTab)this.TABS.get((Object)GUIMediator.Tabs.SEARCH)).getComponent().revalidate();
            this.TABBED_PANE.revalidate();
            this.isDownloadViewVisible = true;
        }
    }

    final SearchMediator getSearchMediator() {
        return this.SEARCH_MEDIATOR;
    }

    final DownloadMediator getDownloadMediator() {
        return this.DOWNLOAD_MEDIATOR;
    }

    final MonitorView getMonitorView() {
        return this.MONITOR_VIEW;
    }

    final UploadMediator getUploadMediator() {
        return this.UPLOAD_MEDIATOR;
    }

    final ConnectionMediator getConnectionMediator() {
        return this.CONNECTION_MEDIATOR;
    }

    final LibraryMediator getLibraryMediator() {
        return this.LIBRARY_MEDIATOR;
    }

    final ChatMediator getChatMediator() {
        return this.CHAT_MEDIATOR;
    }

    final LoggingMediator getLoggingMediator() {
        return this.LOGGING_MEDIATOR;
    }

    static final PlaylistMediator getPlaylistMediator() {
        return PlayerSettings.PLAYER_ENABLED.getValue() ? PlaylistMediator.getInstance() : null;
    }

    final StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    final MenuMediator getMenuMediator() {
        return this.MENU_MEDIATOR;
    }

    final OptionsMediator getOptionsMediator() {
        return this.OPTIONS_MEDIATOR;
    }

    final void setSearching(boolean searching) {
        this.LOGO_PANEL.setSearching(searching);
        this.isSearching = searching;
        this.refresh();
    }

    private void setSearchIconLocation() {
        int y = this.MENU_MEDIATOR.getMenuBarHeight() + (this.height - this.LOGO_PANEL.getPreferredSize().height) / 2;
        this.LOGO_PANEL.setLocation(this.FRAME.getSize().width - this.LOGO_PANEL.getSize().width - 12, y);
    }

    private static class WindowState {
        private final int x = ApplicationSettings.WINDOW_X.getValue();
        private final int y = ApplicationSettings.WINDOW_Y.getValue();
        private final long time = System.currentTimeMillis();

        WindowState() {
        }
    }
}

