/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MediaSliderUI;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class MediaSlider
extends JSlider
implements ThemeObserver,
ChangeListener {
    private final String LEFT_TRACK;
    private final String RIGHT_TRACK;
    private final String CENTER_TRACK;
    private final String THUMB;
    private final String THUMB_PRESSED;
    private BufferedImage leftTrackImage;
    private BufferedImage rightTrackImage;
    private BufferedImage centerTrackImage;
    private BufferedImage thumbImage;
    private BufferedImage thumbPressedImage;

    public MediaSlider(String leftTrackName, String centerTrackName, String rightTrackName, String thumbName, String thumbPressedName) {
        this.LEFT_TRACK = leftTrackName;
        this.RIGHT_TRACK = rightTrackName;
        this.CENTER_TRACK = centerTrackName;
        this.THUMB = thumbName;
        this.THUMB_PRESSED = thumbPressedName;
        this.setFocusable(false);
        ThemeMediator.addThemeObserver(this);
        this.setImages();
        this.setUI(new MediaSliderUI(this));
        this.addChangeListener(this);
    }

    public void setUI(SliderUI sliderUI) {
        if (sliderUI instanceof MediaSliderUI) {
            super.setUI(sliderUI);
        }
    }

    protected void setImages() {
        this.setLeftTrackImage(MediaSlider.convertIconToImage(GUIMediator.getThemeImage(this.LEFT_TRACK)));
        this.setRightTrackImage(MediaSlider.convertIconToImage(GUIMediator.getThemeImage(this.RIGHT_TRACK)));
        this.setCenterTrackImage(MediaSlider.convertIconToImage(GUIMediator.getThemeImage(this.CENTER_TRACK)));
        this.setThumbImage(MediaSlider.convertIconToImage(GUIMediator.getThemeImage(this.THUMB)));
        this.setThumbPressedImage(MediaSlider.convertIconToImage(GUIMediator.getThemeImage(this.THUMB_PRESSED)));
    }

    public void updateTheme() {
        this.setImages();
        ((MediaSliderUI)this.getUI()).setDirty(true);
    }

    public static BufferedImage convertIconToImage(ImageIcon icon) {
        if (icon == null || icon.getImageLoadStatus() != 8) {
            return null;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D bufImageGraphics = image.createGraphics();
        bufImageGraphics.drawImage(icon.getImage(), 0, 0, null);
        bufImageGraphics.dispose();
        return image;
    }

    public BufferedImage getLeftTrackImage() {
        return this.leftTrackImage;
    }

    public BufferedImage getCenterTrackImage() {
        return this.centerTrackImage;
    }

    public BufferedImage getRightTrackImage() {
        return this.rightTrackImage;
    }

    public BufferedImage getThumbImage() {
        return this.thumbImage;
    }

    public BufferedImage getThumbPressedImage() {
        return this.thumbPressedImage;
    }

    public void setLeftTrackImage(Image image) {
        this.leftTrackImage = (BufferedImage)image;
    }

    public void setCenterTrackImage(Image image) {
        this.centerTrackImage = (BufferedImage)image;
    }

    public void setRightTrackImage(Image image) {
        this.rightTrackImage = (BufferedImage)image;
    }

    public void setThumbImage(Image image) {
        this.thumbImage = (BufferedImage)image;
    }

    public void setThumbPressedImage(Image image) {
        this.thumbPressedImage = (BufferedImage)image;
    }

    public void stateChanged(ChangeEvent e) {
        this.setToolTipText(Integer.toString(this.getValue()));
    }
}

