/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.MediaSlider;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class MediaSliderUI
extends BasicSliderUI {
    protected BufferedImage trackImageCache;
    protected boolean isDirty = true;
    protected MediaSlider slider;
    private boolean isPressed = false;
    private ThumbMouse thumbMouseListener;
    private ResizeListener componentListener;

    public MediaSliderUI(MediaSlider b) {
        super(b);
        this.slider = b;
        this.slider.setOpaque(false);
        this.thumbMouseListener = new ThumbMouse();
        this.componentListener = new ResizeListener();
    }

    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.focusInsets = new Insets(0, 0, 0, 0);
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
        if (value) {
            this.slider.repaint();
        }
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        slider.addMouseListener(this.thumbMouseListener);
        slider.addComponentListener(this.componentListener);
    }

    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.thumbMouseListener);
        slider.removeComponentListener(this.componentListener);
    }

    public Dimension getThumbSize() {
        BufferedImage thumb = this.slider.getThumbImage();
        if (thumb == null) {
            return super.getThumbSize();
        }
        return new Dimension(((Image)thumb).getWidth(this.slider), ((Image)thumb).getHeight(this.slider));
    }

    public void paintTrack(Graphics g) {
        if (this.slider.getLeftTrackImage() == null || this.slider.getCenterTrackImage() == null || this.slider.getRightTrackImage() == null) {
            super.paintTrack(g);
            return;
        }
        try {
            if (this.trackImageCache == null) {
                this.createTrackCache();
            } else if (this.isDirty) {
                if (this.slider.getOrientation() == 0) {
                    if (this.trackImageCache.getWidth() != this.contentRect.width) {
                        this.createTrackCache();
                    }
                } else if (this.trackImageCache.getHeight() != this.contentRect.height) {
                    this.createTrackCache();
                }
            }
            this.isDirty = false;
        }
        catch (IOException e) {
            super.paintTrack(g);
            return;
        }
        if (this.slider.getOrientation() == 0) {
            Rectangle trackBounds = this.contentRect;
            int cy = (trackBounds.height - this.trackImageCache.getHeight()) / 2;
            g.translate(trackBounds.x, trackBounds.y + cy);
            g.drawImage(this.trackImageCache, 0, 0, null);
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            Rectangle trackBounds = this.contentRect;
            int cw = (trackBounds.width - this.trackImageCache.getWidth()) / 2;
            g.translate(trackBounds.x + cw, trackBounds.y);
            g.drawImage(this.trackImageCache, 0, 0, null);
            g.translate(-(trackBounds.x + cw), -trackBounds.y);
        }
    }

    protected void calculateTrackRect() {
        if (this.slider.getLeftTrackImage() == null || this.slider.getCenterTrackImage() == null || this.slider.getRightTrackImage() == null) {
            super.calculateTrackRect();
            return;
        }
        BufferedImage left = this.slider.getLeftTrackImage();
        BufferedImage right = this.slider.getRightTrackImage();
        int centerSpacing = 0;
        if (this.slider.getOrientation() == 0) {
            centerSpacing = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                centerSpacing += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + left.getWidth() + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.trackRect.x - right.getWidth() - this.trackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            centerSpacing = this.thumbRect.width;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                if (this.slider.getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - centerSpacing - 1) / 2;
            this.trackRect.y = this.contentRect.y + left.getHeight() + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackRect.x - this.trackBuffer;
        }
    }

    protected void createTrackCache() throws IOException {
        BufferedImage left = this.slider.getLeftTrackImage();
        BufferedImage center = this.slider.getCenterTrackImage();
        BufferedImage right = this.slider.getRightTrackImage();
        if (left == null || center == null || right == null) {
            throw new IOException("null track image");
        }
        if (this.slider.getOrientation() == 0) {
            BufferedImage b = new BufferedImage(this.contentRect.width, center.getHeight(), 2);
            Graphics2D g = b.createGraphics();
            g.drawImage((Image)left, this.trackRect.x - left.getWidth(), 0, null);
            g.drawImage(center, this.trackRect.x, 0, this.trackRect.width, center.getHeight(), null);
            g.drawImage((Image)right, (int)this.trackRect.getWidth() + this.trackRect.x, 0, null);
            this.trackImageCache = b;
            g.dispose();
        } else {
            BufferedImage b = new BufferedImage(center.getWidth(), this.contentRect.height, 2);
            Graphics2D g = b.createGraphics();
            g.drawImage((Image)left, 0, this.trackRect.y - left.getHeight(), null);
            g.drawImage(center, 0, this.trackRect.y, center.getWidth(), this.trackRect.height, null);
            g.drawImage((Image)right, 0, (int)(this.trackRect.getHeight() + (double)this.trackRect.y), null);
            this.trackImageCache = b;
            g.dispose();
        }
    }

    public void paintThumb(Graphics g) {
        if (this.slider.getThumbImage() == null) {
            super.paintThumb(g);
            return;
        }
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y + 1);
        g.drawImage(this.isPressed || this.slider.getThumbPressedImage() == null ? this.slider.getThumbPressedImage() : this.slider.getThumbImage(), 0, 0, null);
        g.translate(-knobBounds.x, -(knobBounds.y + 1));
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public BufferedImage getTrackImage() {
        return this.trackImageCache;
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        public void componentResized(ComponentEvent e) {
            MediaSliderUI.this.setDirty(true);
        }

        public void componentShown(ComponentEvent e) {
            MediaSliderUI.this.setDirty(true);
        }
    }

    private class ThumbMouse
    extends MouseAdapter {
        private ThumbMouse() {
        }

        public void mouseReleased(MouseEvent e) {
            if (!MediaSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (MediaSliderUI.this.isPressed) {
                MediaSliderUI.this.isPressed = false;
                MediaSliderUI.this.slider.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!MediaSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (MediaSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                MediaSliderUI.this.isPressed = true;
                MediaSliderUI.this.slider.repaint();
            }
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }
    }
}

