/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.LimeLookAndFeel;
import com.limegroup.gnutella.gui.themes.LimePlasticTheme;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

public final class ResourceManager {
    private static ResourceManager _instance;
    private static final String GUI_PATH = "org/limewire/gui/";
    private static final String RESOURCES_PATH = "org/limewire/gui/resources/";
    private static final String IMAGES_PATH = "org/limewire/gui/images/";
    private static boolean _localeOptionsSet;
    private static Locale _locale;
    private static boolean _fontReduced;
    private static MetalTheme _defaultTheme;
    private final boolean BRUSHED_METAL;
    private final boolean LOADED_TRAY_LIBRARY;
    private final boolean LOADED_JDIC_LIBRARY;
    private static final Map<String, ImageIcon> THEME_IMAGES;
    private static boolean loadFailureEncountered;

    static void resetLocaleOptions() {
        _localeOptionsSet = false;
        ResourceManager.setLocaleOptions();
    }

    static void setLocaleOptions() {
        if (!_localeOptionsSet) {
            if (ApplicationSettings.LANGUAGE.getValue().equals("")) {
                ApplicationSettings.LANGUAGE.setValue("en");
            }
            _locale = new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue());
            StringUtils.setLocale(_locale);
            I18n.setLocale(_locale);
            _localeOptionsSet = true;
        }
    }

    static Locale getLocale() {
        return _locale;
    }

    public static boolean hasLoadFailure() {
        return loadFailureEncountered;
    }

    public static void resetLoadFailure() {
        loadFailureEncountered = false;
    }

    static ResourceBundle getXMLResourceBundle(String name) {
        return ResourceBundle.getBundle("xml.display." + name, _locale);
    }

    static final ImageIcon getThemeImage(String name) {
        if (name == null) {
            throw new NullPointerException("null image name");
        }
        ImageIcon icon = null;
        icon = THEME_IMAGES.get(name);
        if (icon != null) {
            return icon;
        }
        File themeDir = ThemeSettings.THEME_DIR.getValue();
        icon = ResourceManager.getImageFromURL(new File(themeDir, name).getPath(), true);
        if (icon != null && icon.getImage() != null) {
            THEME_IMAGES.put(name, icon);
            return icon;
        }
        icon = ResourceManager.getImageFromURL(IMAGES_PATH + name, false);
        if (icon != null && icon.getImage() != null) {
            THEME_IMAGES.put(name, icon);
            return icon;
        }
        throw new MissingResourceException("image: " + name + " doesn't exist.", null, null);
    }

    static final ImageIcon getImageFromResourcePath(String loc) {
        return ResourceManager.getImageFromURL(loc, false);
    }

    private static final ImageIcon getImageFromURL(String location, boolean file) {
        URL img = ResourceManager.toURL(location, file);
        if (img != null) {
            return new ImageIcon(img);
        }
        img = ResourceManager.toURL(location + ".png", file);
        if (img != null) {
            return new ImageIcon(img);
        }
        img = ResourceManager.toURL(location + ".gif", file);
        if (img != null) {
            return new ImageIcon(img);
        }
        return null;
    }

    private static final URL toURL(String location, boolean file) {
        if (file) {
            File f = new File(location);
            if (f.exists()) {
                try {
                    return f.toURL();
                }
                catch (MalformedURLException murl) {
                    return null;
                }
            }
            return null;
        }
        return ResourceManager.getURL(location);
    }

    static URL getURLResource(String FILE_NAME) {
        return ResourceManager.getURL(RESOURCES_PATH + FILE_NAME);
    }

    private static URL getURL(String PATH) {
        ClassLoader cl = ResourceManager.class.getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        URL url = cl.getResource(PATH);
        if (url == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        return url;
    }

    public static final synchronized ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private ResourceManager() {
        String bMetal;
        if (!ThemeFileHandler.isCurrent() || !ThemeSettings.isValid()) {
            ThemeSettings.THEME_FILE.revertToDefault();
            ThemeSettings.THEME_DIR.revertToDefault();
            ThemeFileHandler.reload(false);
        }
        this.BRUSHED_METAL = (bMetal = System.getProperty("apple.awt.brushMetalLook")) != null && bMetal.equalsIgnoreCase("true");
        this.themeChanged();
        ResourceManager.setFontSizes(ThemeSettings.FONT_SIZE_INCREMENT.getValue());
        try {
            ResourceManager.validateLocaleAndFonts(Locale.getDefault());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (OSUtils.isWindows() || OSUtils.isLinux()) {
            boolean loaded = false;
            try {
                System.loadLibrary("tray");
                loaded = true;
            }
            catch (UnsatisfiedLinkError ule) {
                // empty catch block
            }
            this.LOADED_TRAY_LIBRARY = loaded;
            loaded = false;
            try {
                System.loadLibrary("jdic");
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            this.LOADED_JDIC_LIBRARY = loaded;
        } else {
            this.LOADED_TRAY_LIBRARY = false;
            this.LOADED_JDIC_LIBRARY = false;
        }
    }

    public static void validateLocaleAndFonts(Locale locale) {
        if (OSUtils.isMacOSX()) {
            return;
        }
        String s = locale.getDisplayName();
        if (!ResourceManager.checkUIFonts("dialog", s)) {
            ApplicationSettings.LANGUAGE.setValue("en");
            ApplicationSettings.COUNTRY.setValue("");
            ApplicationSettings.LOCALE_VARIANT.setValue("");
            GUIMediator.resetLocale();
        }
        String i18n = "\u4e2d\u56fd";
        ResourceManager.checkFont("TextField.font", "dialog", i18n, true);
        ResourceManager.checkFont("Table.font", "dialog", i18n, true);
        ResourceManager.checkFont("ProgressBar.font", "dialog", i18n, true);
        ResourceManager.checkFont("TabbedPane.font", "dialog", i18n, true);
    }

    private static boolean checkUIFonts(String newFont, String testString) {
        String[] comps = new String[]{"TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "FormattedTextField.font", "Button.font", "CheckBox.font", "RadioButton.font", "ToggleButton.font", "ProgressBar.font", "ComboBox.font", "InternalFrame.titleFont", "DesktopIcon.font", "TitledBorder.font", "Label.font", "List.font", "TabbedPane.font", "Table.font", "TableHeader.font", "MenuBar.font", "Menu.font", "Menu.acceleratorFont", "MenuItem.font", "MenuItem.acceleratorFont", "PopupMenu.font", "CheckBoxMenuItem.font", "CheckBoxMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "RadioButtonMenuItem.acceleratorFont", "Spinner.font", "Tree.font", "ToolBar.font", "OptionPane.messageFont", "OptionPane.buttonFont", "ToolTip.font"};
        boolean displayable = false;
        for (int i = 0; i < comps.length; ++i) {
            displayable |= ResourceManager.checkFont(comps[i], newFont, testString, false);
        }
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Font f;
            if (!(entry.getValue() instanceof Font) || (f = (Font)entry.getValue()) == null || newFont.equalsIgnoreCase(f.getName()) || GUIUtils.canDisplay(f, testString) || !GUIUtils.canDisplay(f = new Font(newFont, f.getStyle(), f.getSize()), testString)) continue;
            entry.setValue(f);
            displayable = true;
        }
        return displayable;
    }

    private static boolean checkFont(String fontName, String newName, String testString, boolean force) {
        boolean displayable = true;
        Font f = UIManager.getFont(fontName);
        if (f != null && !newName.equalsIgnoreCase(f.getName())) {
            if (!GUIUtils.canDisplay(f, testString) || force) {
                if (GUIUtils.canDisplay(f = new Font(newName, f.getStyle(), f.getSize()), testString)) {
                    UIManager.put(fontName, f);
                } else {
                    displayable = false;
                }
            }
        } else {
            displayable = f != null ? GUIUtils.canDisplay(f, testString) : false;
        }
        return displayable;
    }

    public boolean isTrayLibraryLoaded() {
        return this.LOADED_TRAY_LIBRARY;
    }

    public boolean isTrayIconAvailable() {
        return this.isTrayLibraryLoaded() && NotifyUserProxy.instance().supportsSystemTray();
    }

    public boolean isJdicLibraryLoaded() {
        return this.LOADED_JDIC_LIBRARY;
    }

    public boolean isBrushedMetalSet() {
        return this.BRUSHED_METAL;
    }

    public void themeChanged() {
        THEME_IMAGES.clear();
        try {
            if (ThemeSettings.isOtherTheme()) {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                if (_defaultTheme != null) {
                    MetalLookAndFeel.setCurrentTheme(_defaultTheme);
                }
                String other = ThemeSettings.getOtherLF();
                UIManager.setLookAndFeel(other);
            } else if (ThemeSettings.isNativeTheme()) {
                if (OSUtils.isWindows() && this.isPlasticWindowsAvailable()) {
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
                    }
                    catch (NullPointerException npe) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                if (OSUtils.isMacOSX()) {
                    if (!_fontReduced) {
                        _fontReduced = true;
                        ResourceManager.reduceFont("Label.font");
                        ResourceManager.reduceFont("Table.font");
                    }
                    UIManager.put("List.focusCellHighlightBorder", BorderFactory.createEmptyBorder(1, 1, 1, 1));
                    UIManager.put("ScrollPane.border", BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray));
                }
                if (OSUtils.isWindows()) {
                    this.replaceIconIfFailing("FileChooser.upFolderIcon", "upFolderIconVistaFix");
                    this.replaceIconIfFailing("FileChooser.detailsViewIcon", "detailsViewIconVistaFix");
                    this.replaceIconIfFailing("FileChooser.listViewIcon", "listViewIconVistaFix");
                    this.replaceIconIfFailing("FileChooser.newFolderIcon", "newFolderIconVistaFix");
                }
            } else if (this.isPlasticAvailable()) {
                if (_defaultTheme == null) {
                    _defaultTheme = this.getDefaultTheme();
                }
                LimePlasticTheme.installThisTheme();
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
                LimeLookAndFeel.installUIManagerDefaults();
            } else {
                UIManager.setLookAndFeel(new LimeLookAndFeel());
            }
            UIManager.put("Tree.leafIcon", UIManager.getIcon("Tree.closedIcon"));
            UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder());
            if (!OSUtils.isMacOSX()) {
                UIManager.put("Table.focusRowHighlightBorder", UIManager.get("Table.focusCellHighlightBorder"));
            }
            UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createEmptyBorder(1, 1, 1, 1));
            Font normal = UIManager.getFont("Table.font");
            FontUIResource bold = new FontUIResource(normal.getName(), 1, normal.getSize());
            UIManager.put("Table.font.bold", bold);
            UIManager.put("Tree.rowHeight", 0);
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (InstantiationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
        this.wrapDesktopProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapDesktopProperties() {
        UIDefaults defaults;
        Class<?> desktopProperty;
        if (!OSUtils.isWindows()) {
            return;
        }
        try {
            desktopProperty = Class.forName("com.sun.java.swing.plaf.windows.DesktopProperty");
        }
        catch (ClassNotFoundException cnfe) {
            return;
        }
        UIDefaults uIDefaults = defaults = UIManager.getLookAndFeelDefaults();
        synchronized (uIDefaults) {
            for (Map.Entry entry : defaults.entrySet()) {
                Object value = entry.getValue();
                if (!(entry.getValue() instanceof UIDefaults.ActiveValue)) continue;
                UIDefaults.ActiveValue activeValue = (UIDefaults.ActiveValue)value;
                if (value == null || !desktopProperty.isAssignableFrom(value.getClass())) continue;
                entry.setValue(new ActiveDesktopProperty(activeValue));
            }
        }
    }

    private void replaceIconIfFailing(String resource, String replacementName) {
        try {
            UIManager.getIcon(resource);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            UIManager.put(resource, ResourceManager.getThemeImage(replacementName));
        }
    }

    private MetalTheme getDefaultTheme() {
        MetalTheme theme = null;
        try {
            theme = (MetalTheme)MetalLookAndFeel.class.getMethod("getCurrentTheme", null).invoke(null, (Object[])null);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (theme == null) {
            theme = new DefaultMetalTheme();
        }
        return theme;
    }

    private boolean isPlasticAvailable() {
        try {
            Class<?> plastic = Class.forName("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
            return plastic != null;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private boolean isPlasticWindowsAvailable() {
        try {
            Class<?> plastic = Class.forName("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
            return plastic != null;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    static ComponentUI getNativeUI(JComponent c) {
        ComponentUI ret = null;
        String name = UIManager.getSystemLookAndFeelClassName();
        if (name != null) {
            try {
                Class<?> clazz = Class.forName(name);
                LookAndFeel lf = (LookAndFeel)clazz.newInstance();
                lf.initialize();
                UIDefaults def = lf.getDefaults();
                ret = def.getUI(c);
            }
            catch (ExceptionInInitializerError e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException e) {
            }
            catch (SecurityException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = UIManager.getUI(c);
        }
        return ret;
    }

    private static void reduceFont(String name) {
        Font oldFont = UIManager.getFont(name);
        FontUIResource newFont = new FontUIResource(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - 2);
        UIManager.put(name, newFont);
    }

    public static void setFontSizes(float fontSizeIncrement) {
        if (fontSizeIncrement == 0.0f) {
            return;
        }
        HashMap<Font, Font> newFontByOldFont = new HashMap<Font, Font>();
        String[] fontKeys = new String[]{"Button.font", "CheckBox.font", "ComboBox.font", "DesktopIcon.font", "Label.font", "List.font", "ProgressBar.font", "RadioButton.font", "Slider.font", "Spinner.font", "TabbedPane.font", "TitledBorder.font", "ToggleButton.font", "CheckBoxMenuItem.font", "Menu.font", "MenuBar.font", "MenuItem.font", "PopupMenu.font", "RadioButtonMenuItem.font", "ToolBar.font", "ToolTip.font", "EditorPane.font", "FormattedTextField.font", "PasswordField.font", "Table.font", "TableHeader.font", "TextArea.font", "TextField.font", "TextPane.font", "Tree.font", "InternalFrame.titleFont"};
        ArrayList<Object> props = new ArrayList<Object>(fontKeys.length * 2);
        for (String fontKey : fontKeys) {
            Font font = UIManager.getFont(fontKey);
            Font newFont = (Font)newFontByOldFont.get(font);
            if (newFont == null) {
                if (font == null) continue;
                newFont = new FontUIResource(font.deriveFont((float)font.getSize() + fontSizeIncrement));
                newFontByOldFont.put(font, newFont);
            }
            props.add(fontKey);
            props.add(newFont);
        }
        UIManager.getDefaults().putDefaults(props.toArray());
    }

    static {
        _fontReduced = false;
        _defaultTheme = null;
        THEME_IMAGES = new HashMap<String, ImageIcon>();
        loadFailureEncountered = false;
        ResourceManager.resetLocaleOptions();
    }

    private static class ActiveDesktopProperty
    implements UIDefaults.ActiveValue,
    Runnable {
        private final UIDefaults.ActiveValue delegate;
        private volatile UIDefaults table;
        private volatile Object result;

        ActiveDesktopProperty(UIDefaults.ActiveValue value) {
            this.delegate = value;
        }

        public Object createValue(UIDefaults table) {
            if (SwingUtilities.isEventDispatchThread()) {
                return this.delegate.createValue(table);
            }
            this.table = table;
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (InterruptedException e) {
                return this.delegate.createValue(table);
            }
            catch (InvocationTargetException e) {
                return this.delegate.createValue(table);
            }
            return this.result;
        }

        public void run() {
            this.result = this.delegate.createValue(this.table);
        }
    }
}

