/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class SaveDirectoryHandler {
    private SaveDirectoryHandler() {
    }

    private static void showSaveDirectoryWindow() {
        File dir = null;
        while (!SaveDirectoryHandler.isSaveDirectoryValid(dir) || !SaveDirectoryHandler.showVistaWarningIfNeeded(dir)) {
            final AtomicReference dirRef = new AtomicReference();
            GUIMediator.safeInvokeAndWait(new Runnable(){

                public void run() {
                    GUIMediator.showError(I18n.tr("Your save folder is not valid. It may have been deleted, you may not have permissions to write to it, or there may be another problem. Please choose a different folder."));
                    dirRef.set(SaveDirectoryHandler.showChooser());
                }
            });
            dir = (File)dirRef.get();
            if (dir == null) continue;
            FileUtils.setWriteable(dir);
        }
    }

    private static File showChooser() {
        final AtomicReference dirRef = new AtomicReference();
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                dirRef.set(FileChooserHandler.getInputDirectory(null));
            }
        });
        File dir = (File)dirRef.get();
        if (dir != null) {
            try {
                SharingSettings.setSaveDirectory(dir);
                return dir;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSaveDirectoryValid(File saveDir) {
        boolean bl;
        if (saveDir == null || !saveDir.exists() || !saveDir.isDirectory()) {
            return false;
        }
        FileUtils.setWriteable(saveDir);
        Random generator = new Random();
        File testFile = null;
        for (int i = 0; i < 10 && testFile == null; ++i) {
            StringBuilder name = new StringBuilder();
            for (int j = 0; j < 8; ++j) {
                name.append((char)(97 + generator.nextInt(25)));
            }
            name.append(".tmp");
            testFile = new File(saveDir, name.toString());
            if (!testFile.exists()) continue;
            testFile = null;
        }
        if (testFile == null) {
            return false;
        }
        RandomAccessFile testRAFile = null;
        try {
            testRAFile = new RandomAccessFile(testFile, "rw");
            testRAFile.write(7);
            testRAFile.close();
        }
        catch (FileNotFoundException e) {
            bl = false;
            return bl;
        }
        catch (IOException e) {
            bl = false;
            return bl;
        }
        finally {
            testFile.delete();
            try {
                if (testRAFile != null) {
                    testRAFile.close();
                }
            }
            catch (IOException ignored) {}
        }
        return saveDir.canWrite();
    }

    public static void handleSaveDirectory() {
        File saveDir = SharingSettings.getSaveDirectory();
        if (!SaveDirectoryHandler.isSaveDirectoryValid(saveDir) || !SaveDirectoryHandler.showVistaWarningIfNeeded(saveDir)) {
            SaveDirectoryHandler.showSaveDirectoryWindow();
        }
    }

    public static boolean isGoodVistaDirectory(File f) {
        if (!OSUtils.isWindowsVista()) {
            return true;
        }
        try {
            return FileUtils.isReallyInParentPath(CommonUtils.getUserHomeDir(), f);
        }
        catch (IOException iox) {
            return true;
        }
    }

    public static boolean showVistaWarningIfNeeded(File f) {
        if (SaveDirectoryHandler.isGoodVistaDirectory(f)) {
            return true;
        }
        return GUIMediator.showYesNoMessage(I18n.tr("Saving downloads to {0} may not function correctly.  To be sure downloads are saved properly you should save them to a sub-folder of {1}.  Would you like to choose another location?", f, CommonUtils.getUserHomeDir()), QuestionsHandler.VISTA_SAVE_LOCATION, DialogOption.YES) == DialogOption.NO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ERROR_CODE {
        INVALID,
        NOT_HOME;

    }
}

