/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.StatusComponent;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public final class SplashWindow {
    private static SplashWindow INSTANCE;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile StatusComponent glassPane;
    private volatile JLabel splashLabel;
    private volatile JWindow splashWindow;

    public static synchronized SplashWindow instance() {
        if (INSTANCE == null) {
            INSTANCE = new SplashWindow();
        }
        return INSTANCE;
    }

    public static synchronized boolean isSplashConstructed() {
        return INSTANCE != null;
    }

    private void initialize() {
        int imgHeight;
        this.glassPane = new StatusComponent(15);
        this.splashLabel = new JLabel();
        this.splashWindow = new JWindow();
        this.glassPane.add(Box.createVerticalGlue(), 0);
        this.glassPane.add(Box.createVerticalStrut(8));
        this.glassPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        String name = LimeWireUtils.isPro() ? "splashpro" : "splash";
        URL imageURL = ClassLoader.getSystemResource("org/limewire/gui/images/" + name + ".png");
        assert (imageURL != null);
        Image splashImage = Toolkit.getDefaultToolkit().createImage(imageURL);
        MediaTracker mt = new MediaTracker(this.splashWindow);
        mt.addImage(splashImage, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int imgWidth = splashImage.getWidth(null);
        if (imgWidth < 1) {
            imgWidth = 1;
        }
        if ((imgHeight = splashImage.getHeight(null)) < 1) {
            imgHeight = 1;
        }
        Dimension size = new Dimension(imgWidth + 2, imgHeight + 2);
        this.splashWindow.setSize(size);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.splashWindow.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
        this.splashLabel.setIcon(new ImageIcon(splashImage));
        this.splashWindow.getContentPane().add((Component)this.splashLabel, "Center");
        this.splashWindow.setGlassPane(this.glassPane);
        this.splashWindow.pack();
    }

    public void begin() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.runLater(new Runnable(){

            public void run() {
                SplashWindow.this.initialize();
                SplashWindow.this.splashWindow.toFront();
                SplashWindow.this.splashWindow.setVisible(true);
                SplashWindow.this.glassPane.setVisible(true);
                SplashWindow.this.setStatusText(I18n.tr("Loading FrostWire..."));
            }
        });
    }

    public void setStatusText(final String text) {
        this.runLater(new Runnable(){

            public void run() {
                SplashWindow.this.glassPane.setText(text);
                SplashWindow.this.glassPane.paintImmediately(0, 0, SplashWindow.this.glassPane.getWidth(), SplashWindow.this.glassPane.getHeight());
            }
        });
    }

    public void refreshImage() {
        this.runLater(new Runnable(){

            public void run() {
                ImageIcon splashIcon = ResourceManager.getThemeImage("splash");
                SplashWindow.this.splashLabel.setIcon(splashIcon);
                SplashWindow.this.glassPane.setVisible(false);
                SplashWindow.this.splashWindow.pack();
                SplashWindow.this.splashLabel.paintImmediately(0, 0, SplashWindow.this.splashLabel.getWidth(), SplashWindow.this.splashLabel.getHeight());
            }
        });
    }

    private void runLater(Runnable runner) {
        if (this.initialized.get()) {
            GUIMediator.safeInvokeAndWait(runner);
        }
    }

    public void dispose() {
        this.runLater(new Runnable(){

            public void run() {
                SplashWindow.this.splashWindow.dispose();
            }
        });
    }

    public boolean isShowing() {
        return this.splashWindow != null && this.splashWindow.isShowing();
    }

    public void setVisible(final boolean b) {
        this.runLater(new Runnable(){

            public void run() {
                SplashWindow.this.splashWindow.setVisible(b);
            }
        });
    }

    public void toBack() {
        this.runLater(new Runnable(){

            public void run() {
                SplashWindow.this.splashWindow.toBack();
            }
        });
    }
}

