/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.limewire.i18n.I18nMarker;

final class UpgradeWindow {
    private JDialog dialog;
    private final BoxPanel MAIN_PANEL = new BoxPanel(1);
    private final ImageIcon ICON = GUIMediator.getThemeImage("searching");
    private final Dimension DIALOG_DIMENSION = new Dimension(380, 180);

    UpgradeWindow(boolean pro) {
        boolean useLime;
        boolean useButtonTips;
        boolean randomButtons;
        String upgradeWhy;
        String upgradeURL;
        String upgradeKey;
        String messageKey;
        String titleKey;
        int labelWidth = 300;
        if (pro) {
            titleKey = I18nMarker.marktr("Upgrade FrostWire");
            messageKey = I18nMarker.marktr("For Turbo-Charged downloads, get FrostWire. Thank you for helping keep the Internet open by running FrostWire.");
            upgradeKey = I18nMarker.marktr("Upgrade to FrostWire?");
            upgradeURL = "http://www.frostwire.com/";
            upgradeWhy = "http://www.frostwire.com/forum";
            randomButtons = true;
            useButtonTips = true;
            useLime = true;
        } else {
            titleKey = I18nMarker.marktr("Upgrade Your Java");
            messageKey = I18nMarker.marktr("FrostWire has detected that you are using an out-of-date version of Java. FrostWire looks and acts much better with newer versions of Java. Features include support for scroll-wheels on mice, a Windows XP look, and many other improvements.");
            upgradeKey = I18nMarker.marktr("Would you like to get your free Java upgrade?");
            upgradeURL = this.getJavaUpgradeURL();
            upgradeWhy = "http://www.frostwire.com";
            randomButtons = false;
            useButtonTips = false;
            useLime = false;
        }
        this.dialog = new JDialog(GUIMediator.getAppFrame());
        this.dialog.setModal(true);
        this.dialog.setResizable(true);
        this.dialog.setTitle(I18n.tr(titleKey));
        Border border = BorderFactory.createEmptyBorder(12, 6, 6, 6);
        BoxPanel topPanel = new BoxPanel(0);
        if (useLime) {
            topPanel.add(new JLabel(this.ICON));
            labelWidth -= this.ICON.getIconWidth();
        }
        topPanel.add(GUIMediator.getHorizontalSeparator());
        topPanel.add(GUIMediator.getHorizontalSeparator());
        topPanel.add(GUIMediator.getHorizontalSeparator());
        String labelStart = I18n.tr(messageKey);
        String labelEnd = I18n.tr(upgradeKey);
        MultiLineLabel label = new MultiLineLabel(labelStart, labelWidth);
        label.setFont(new Font("Dialog", 0, 12));
        JLabel label2 = new JLabel(labelEnd);
        label2.setFont(new Font("Dialog", 0, 12));
        BoxPanel labelPanel = new BoxPanel(1);
        labelPanel.add(Box.createVerticalGlue());
        labelPanel.add(label);
        labelPanel.add(Box.createVerticalStrut(10));
        BoxPanel questionPanel = new BoxPanel(0);
        questionPanel.add(Box.createVerticalGlue());
        questionPanel.add(label2);
        questionPanel.add(Box.createVerticalGlue());
        topPanel.add(labelPanel);
        this.MAIN_PANEL.setBorder(border);
        this.MAIN_PANEL.setPreferredSize(this.DIALOG_DIMENSION);
        this.dialog.setSize(this.DIALOG_DIMENSION);
        ActionListener upgradeDialogListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.openURL(upgradeURL);
                UpgradeWindow.this.dialog.dispose();
                UpgradeWindow.this.dialog.setVisible(false);
            }
        };
        ActionListener whyDialogListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.openURL(upgradeWhy);
                UpgradeWindow.this.dialog.dispose();
                UpgradeWindow.this.dialog.setVisible(false);
            }
        };
        ActionListener closeDialogListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpgradeWindow.this.dialog.dispose();
                UpgradeWindow.this.dialog.setVisible(false);
            }
        };
        ActionListener[] listeners = new ActionListener[]{upgradeDialogListener, whyDialogListener, closeDialogListener};
        List<ActionListener> shuffled = Arrays.asList(listeners);
        if (randomButtons) {
            Collections.shuffle(shuffled);
        }
        listeners = shuffled.toArray(listeners);
        String[] buttonKeys = new String[listeners.length];
        String[] buttonTips = new String[listeners.length];
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] == upgradeDialogListener) {
                buttonKeys[i] = I18nMarker.marktr("Yes");
                if (!useButtonTips) continue;
                buttonTips[i] = I18nMarker.marktr("Get FrostWire Now");
                continue;
            }
            if (listeners[i] == whyDialogListener) {
                buttonKeys[i] = I18nMarker.marktr("Why");
                if (!useButtonTips) continue;
                buttonTips[i] = I18nMarker.marktr("What does frostwire give me?");
                continue;
            }
            if (listeners[i] != closeDialogListener) continue;
            buttonKeys[i] = I18nMarker.marktr("Later");
            if (!useButtonTips) continue;
            buttonTips[i] = I18nMarker.marktr("Get FrostWire Later");
        }
        ButtonRow buttons = new ButtonRow(buttonKeys, buttonTips, listeners);
        this.MAIN_PANEL.add(topPanel);
        this.MAIN_PANEL.add(questionPanel);
        this.MAIN_PANEL.add(Box.createVerticalStrut(10));
        this.MAIN_PANEL.add(buttons);
        this.dialog.getContentPane().add(this.MAIN_PANEL);
        this.dialog.pack();
    }

    private String getJavaUpgradeURL() {
        Locale loc = GUIMediator.getLocale();
        String language = loc.getLanguage();
        if (!(language.equals("en") || language.equals("de") || language.equals("es") || language.equals("fr") || language.equals("it") || language.equals("ja") || language.equals("ko") || language.equals("sv") || language.equals("zh"))) {
            language = "en";
        }
        return "http://www.frostwire.com/javabuttonu/" + language;
    }

    static void showProDialog() {
        UpgradeWindow window = new UpgradeWindow(true);
        window.dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        try {
            window.dialog.setVisible(true);
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }

    static void showJavaDialog() {
        UpgradeWindow window = new UpgradeWindow(false);
        window.dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        try {
            window.dialog.setVisible(true);
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }
}

