/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.library.RecursiveSharingPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RemoveSharedDirectoryAction
extends AbstractAction {
    private final RecursiveSharingPanel recursiveSharingPanel;

    public RemoveSharedDirectoryAction(RecursiveSharingPanel recursiveSharingPanel) {
        super(I18n.tr("Remove"));
        this.recursiveSharingPanel = recursiveSharingPanel;
        this.setEnabled(false);
        recursiveSharingPanel.getTree().addTreeSelectionListener(new EnablementSelectionListener());
    }

    public void actionPerformed(ActionEvent e) {
        File dir = (File)this.recursiveSharingPanel.getTree().getSelectionPath().getLastPathComponent();
        this.recursiveSharingPanel.removeRoot(dir);
    }

    private class EnablementSelectionListener
    implements TreeSelectionListener {
        private EnablementSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Object obj = e.getPath().getLastPathComponent();
            if (obj instanceof File) {
                RemoveSharedDirectoryAction.this.setEnabled(RemoveSharedDirectoryAction.this.recursiveSharingPanel.isRoot((File)obj));
            } else {
                RemoveSharedDirectoryAction.this.setEnabled(false);
            }
        }
    }
}

