/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.limewire.i18n.I18nMarker;

public class ChatFrame
extends JFrame
implements ThemeObserver {
    private final String BLOCK_BUTTON_LABEL = I18nMarker.marktr("Block Host");
    private final String SEND_BUTTON_LABEL = I18nMarker.marktr("Send Message");
    private final String BLOCK_BUTTON_TIP = I18nMarker.marktr("Block Current Host");
    private final String SEND_BUTTON_TIP = I18nMarker.marktr("Send a Message to a Host");
    private final String WITH_LABEL = I18nMarker.marktr("Chatting with");
    private final String UNAVAILABLE_LABEL = I18nMarker.marktr("Host is unavailable");
    private final String YOU_LABEL = I18nMarker.marktr("You");
    private final int WINDOW_WIDTH = 500;
    private final int WINDOW_HEIGHT = 300;
    private final int WINDOW_MIN_WIDTH = 250;
    private final int WINDOW_MIN_HEIGHT = 200;
    private final int TEXT_FIELD_LIMIT = 500;
    private boolean connected = true;
    JTextArea _area;
    JTextField _field;
    JTextField _connectField;
    InstantMessenger _chat;
    ButtonRow _buttons;

    public ChatFrame(InstantMessenger chat) {
        this.setTitle(I18n.tr(this.WITH_LABEL) + " " + chat.getHost());
        this.setSize(500, 300);
        this._chat = chat;
        JFrame parentFrame = GUIMediator.getAppFrame();
        int mwidth = parentFrame.getSize().width / 2;
        int mheight = parentFrame.getSize().height / 2;
        int fwidth = this.getSize().width / 2;
        int fheight = this.getSize().height / 2;
        int xlocation = mwidth - fwidth;
        int ylocation = mheight - fheight;
        int xstart = parentFrame.getLocation().x;
        int ystart = parentFrame.getLocation().y;
        int x = xstart + xlocation;
        int y = ystart + ylocation;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (x < 0 || y < 0 || x >= screenSize.width || y >= screenSize.height) {
            x = (screenSize.width - this.getSize().width) / 2;
            y = (screenSize.height - this.getSize().height) / 2;
        }
        this.setLocation(x, y);
        BlockListener blockListener = new BlockListener();
        SendListener sendListener = new SendListener();
        String[] buttonLabels = new String[]{this.BLOCK_BUTTON_LABEL, this.SEND_BUTTON_LABEL};
        String[] buttonTips = new String[]{this.BLOCK_BUTTON_TIP, this.SEND_BUTTON_TIP};
        ActionListener[] buttonListeners = new ActionListener[]{blockListener, sendListener};
        this._buttons = new ButtonRow(buttonLabels, buttonTips, buttonListeners, 0, 14);
        this._buttons.setButtonEnabled(1, false);
        TextPanel tp = new TextPanel();
        BoxPanel mainPanel = new BoxPanel(1);
        PaddedPanel myPanel = new PaddedPanel();
        myPanel.setPreferredSize(new Dimension(1000, 1000));
        myPanel.add(tp);
        mainPanel.add(myPanel);
        mainPanel.add(Box.createVerticalStrut(6));
        mainPanel.add(this._buttons);
        mainPanel.add(Box.createVerticalStrut(6));
        this.getContentPane().add(mainPanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JFrame src = (JFrame)e.getSource();
                int width = src.getWidth();
                int height = src.getHeight();
                int newWidth = Math.max(width, 250);
                int newHeight = Math.max(height, 200);
                if (newWidth != width || newHeight != height) {
                    src.setSize(newWidth, newHeight);
                }
            }
        });
        this.updateTheme();
    }

    public void chatAvailable(InstantMessenger chatter) {
        if (this._chat != chatter) {
            if (this._chat != null) {
                this._chat.stop();
            }
            this._chat = chatter;
        }
        this._area.setForeground(UIManager.getColor("TextArea.foreground"));
        this.connected = true;
        this._buttons.setButtonEnabled(1, true);
    }

    public void updateTheme() {
        ImageIcon plugIcon = GUIMediator.getThemeImage("frosticon");
        this.setIconImage(plugIcon.getImage());
    }

    public void addResponse(String str) {
        String host = this._chat.getHost();
        this._area.setText(this._area.getText() + host + ": " + str + "\n");
    }

    public void chatUnavailable() {
        this._area.setForeground(Color.red);
        this.appendMessage(I18n.tr(this.UNAVAILABLE_LABEL));
        this.connected = false;
        this._buttons.setButtonEnabled(1, false);
    }

    private void appendMessage(String text) {
        this._area.append(text + "\n");
    }

    public void displayErrorMessage(String str) {
        this._area.setForeground(Color.red);
        if (str == null) {
            str = I18n.tr("A connection error has occurred");
        }
        this.appendMessage(str);
    }

    public void send() {
        if (!this.connected) {
            return;
        }
        String str = this._field.getText();
        if (str.length() == 0) {
            return;
        }
        if (this._chat.send(str)) {
            this.appendMessage(I18n.tr(this.YOU_LABEL) + ": " + str);
            this._field.setText("");
            this._buttons.setButtonEnabled(1, false);
        } else {
            this.displayErrorMessage(I18n.tr("Could not send chat message"));
        }
    }

    public InstantMessenger getChat() {
        return this._chat;
    }

    public void setMessage(String message) {
        this._field.setText(message);
    }

    public String getText() {
        return this._area.getText();
    }

    public String getMessage() {
        return this._field.getText();
    }

    public boolean isConnected() {
        return this.connected;
    }

    private class JTextFieldKeyListener
    implements KeyListener {
        private JTextFieldKeyListener() {
        }

        public void keyTyped(KeyEvent k) {
            if (k.getKeyChar() == '\n') {
                ChatFrame.this.send();
            }
        }

        public void keyPressed(KeyEvent k) {
        }

        public void keyReleased(KeyEvent k) {
            String text = ChatFrame.this._field.getText();
            if (text.length() == 0) {
                ChatFrame.this._buttons.setButtonEnabled(1, false);
            } else if (ChatFrame.this.connected) {
                ChatFrame.this._buttons.setButtonEnabled(1, true);
            }
        }
    }

    private class BlockListener
    implements ActionListener {
        private BlockListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String host = ChatFrame.this._chat.getHost();
            GuiCoreMediator.getSpamServices().blockHost(host);
            ChatFrame.this._chat.stop();
        }
    }

    private class SendListener
    implements ActionListener {
        private SendListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatFrame.this.send();
        }
    }

    private class TextPanel
    extends JPanel {
        public TextPanel() {
            this.setLayout(new BoxLayout(this, 1));
            BoxPanel fieldPanel = new BoxPanel(0);
            ChatFrame.this._area = new JTextArea();
            ChatFrame.this._area.setLineWrap(true);
            ChatFrame.this._field = new JTextField();
            ChatFrame.this._field.setDocument(new JTextFieldLimit(500));
            JScrollPane areaScrollPane = new JScrollPane(ChatFrame.this._area);
            ChatFrame.this._area.setEditable(false);
            ChatFrame.this._field.addKeyListener(new JTextFieldKeyListener());
            fieldPanel.add(Box.createHorizontalStrut(6));
            fieldPanel.add(ChatFrame.this._field);
            fieldPanel.add(Box.createHorizontalStrut(6));
            fieldPanel.setPreferredSize(new Dimension(1000, 20));
            fieldPanel.setMaximumSize(new Dimension(1000, 20));
            this.add(areaScrollPane);
            this.add(Box.createVerticalStrut(6));
            this.add(fieldPanel);
        }
    }

    private class JTextFieldLimit
    extends PlainDocument {
        private int limit;

        public JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

