/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.connection.BandwidthHolder;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.connection.DroppedHolder;
import com.limegroup.gnutella.gui.connection.MessagesHolder;
import com.limegroup.gnutella.gui.connection.ProtocolHolder;
import com.limegroup.gnutella.gui.connection.QRPHolder;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionDataLine
extends AbstractDataLine<RoutedConnection> {
    static final int HOST_IDX = 0;
    static final int STATUS_IDX = 1;
    static final int MESSAGES_IDX = 2;
    static final int MESSAGES_IN_IDX = 3;
    static final int MESSAGES_OUT_IDX = 4;
    static final int BANDWIDTH_IDX = 5;
    static final int BANDWIDTH_IN_IDX = 6;
    static final int BANDWIDTH_OUT_IDX = 7;
    static final int DROPPED_IDX = 8;
    static final int DROPPED_IN_IDX = 9;
    static final int DROPPED_OUT_IDX = 10;
    static final int PROTOCOL_IDX = 11;
    static final int VENDOR_IDX = 12;
    static final int TIME_IDX = 13;
    static final int COMPRESSION_IDX = 14;
    static final int COMPRESSION_IN_IDX = 15;
    static final int COMPRESSION_OUT_IDX = 16;
    static final int SSL_IDX = 17;
    static final int SSL_IN_IDX = 18;
    static final int SSL_OUT_IDX = 19;
    static final int QRP_FULL_IDX = 20;
    static final int QRP_USED_IDX = 21;
    private static final LimeTableColumn[] ltColumns = new LimeTableColumn[]{new LimeTableColumn(0, "CV_COLUMN_HOST", I18n.tr("Host"), 218, true, String.class), new LimeTableColumn(1, "CV_COLUMN_STATUS", I18n.tr("Status"), 70, true, String.class), new LimeTableColumn(2, "CV_COLUMN_MESSAGE", I18n.tr("Messages (I/O)"), 97, true, MessagesHolder.class), new LimeTableColumn(3, "CV_COLUMN_MESSAGE_IN", I18n.tr("Messages In"), 97, false, Integer.class), new LimeTableColumn(4, "CV_COLUMN_MESSAGE_OUT", I18n.tr("Messages Out"), 97, false, Integer.class), new LimeTableColumn(5, "CV_COLUMN_BANDWIDTH", I18n.tr("Bandwidth (I/O)"), 115, true, BandwidthHolder.class), new LimeTableColumn(6, "CV_COLUMN_BANDWIDTH_IN", I18n.tr("Bandwidth In"), 115, false, BandwidthHolder.class), new LimeTableColumn(7, "CV_COLUMN_BANDWIDTH_OUT", I18n.tr("Bandwidth Out"), 115, false, BandwidthHolder.class), new LimeTableColumn(8, "CV_COLUMN_DROPPED", I18n.tr("Dropped (I/O)"), 92, true, DroppedHolder.class), new LimeTableColumn(9, "CV_COLUMN_DROPPED_IN", I18n.tr("Dropped In"), 92, false, DroppedHolder.class), new LimeTableColumn(10, "CV_COLUMN_DROPPED_OUT", I18n.tr("Dropped Out"), 92, false, DroppedHolder.class), new LimeTableColumn(11, "CV_COLUMN_PROTOCOL", I18n.tr("Protocol"), 60, true, ProtocolHolder.class), new LimeTableColumn(12, "CV_COLUMN_VENDOR", I18n.tr("Vendor/Version"), 116, true, String.class), new LimeTableColumn(13, "CV_COLUMN_TIME", I18n.tr("Time"), 44, true, TimeRemainingHolder.class), new LimeTableColumn(14, "CV_COLUMN_COMPRESSION", I18n.tr("Compressed (I/O)"), 114, false, DroppedHolder.class), new LimeTableColumn(15, "CV_COLUMN_COMPRESSION_IN", I18n.tr("Compressed In"), 114, false, DroppedHolder.class), new LimeTableColumn(16, "CV_COLUMN_COMPRESSION_OUT", I18n.tr("Compressed Out"), 114, false, DroppedHolder.class), new LimeTableColumn(17, "CV_COLUMN_SSL", I18n.tr("SSL Overhead (I/O)"), 100, false, DroppedHolder.class), new LimeTableColumn(18, "CV_COLUMN_SSL_IN", I18n.tr("SSL Overhead In"), 100, false, DroppedHolder.class), new LimeTableColumn(19, "CV_COLUMN_SSL_OUT", I18n.tr("SSL Overhead Out"), 100, false, DroppedHolder.class), new LimeTableColumn(20, "CV_COLUMN_QRP_FULL", I18n.tr("QRP (%)"), 70, false, QRPHolder.class), new LimeTableColumn(21, "CV_COLUMN_QRP_USED", I18n.tr("QRP Empty"), 70, false, String.class)};
    private static final String CONNECTING_STRING = I18n.tr("Connecting...");
    private static final String OUTGOING_STRING = I18n.tr("Outgoing");
    private static final String INCOMING_STRING = I18n.tr("Incoming");
    private static final String CONNECTED_ON = I18n.tr("Connected on");
    private volatile String _host;
    private String _status;
    private long _time;
    private boolean _isConnecting = true;
    private boolean _hasResolvedAddress = false;
    private static volatile boolean _hostChanged = false;
    private static boolean _updated = false;

    @Override
    public int getColumnCount() {
        return ltColumns.length;
    }

    @Override
    public void initialize(RoutedConnection conn) {
        super.initialize(conn);
        this._host = ((RoutedConnection)this.initializer).getAddress();
        this._status = CONNECTING_STRING;
        this._time = System.currentTimeMillis();
    }

    @Override
    public Object getValueAt(int idx) {
        switch (idx) {
            case 0: {
                if (!this._hasResolvedAddress && !this._isConnecting && System.currentTimeMillis() - this._time > 10000L) {
                    this.assignHostName();
                }
                return this._host;
            }
            case 1: {
                return this._status;
            }
            case 2: {
                if (this._isConnecting) {
                    return null;
                }
                return new MessagesHolder(((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesReceived(), ((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesSent());
            }
            case 3: {
                if (this._isConnecting) {
                    return null;
                }
                return ((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesReceived();
            }
            case 4: {
                if (this._isConnecting) {
                    return null;
                }
                return ((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesSent();
            }
            case 5: {
                if (this._isConnecting) {
                    return null;
                }
                return new BandwidthHolder(((RoutedConnection)this.initializer).getMeasuredDownstreamBandwidth(), ((RoutedConnection)this.initializer).getMeasuredUpstreamBandwidth());
            }
            case 6: {
                if (this._isConnecting) {
                    return null;
                }
                return new BandwidthHolder(((RoutedConnection)this.initializer).getMeasuredDownstreamBandwidth());
            }
            case 7: {
                if (this._isConnecting) {
                    return null;
                }
                return new BandwidthHolder(((RoutedConnection)this.initializer).getMeasuredUpstreamBandwidth());
            }
            case 8: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder((float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumReceivedMessagesDropped() / ((float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesReceived() + 1.0f), (float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumSentMessagesDropped() / ((float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesSent() + 1.0f));
            }
            case 9: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder((float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumReceivedMessagesDropped() / ((float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesReceived() + 1.0f));
            }
            case 10: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder((float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumSentMessagesDropped() / ((float)((RoutedConnection)this.initializer).getConnectionMessageStatistics().getNumMessagesSent() + 1.0f));
            }
            case 11: {
                return new ProtocolHolder(((RoutedConnection)this.initializer).getConnectionCapabilities());
            }
            case 12: {
                if (this._isConnecting) {
                    return null;
                }
                String vendor = ((RoutedConnection)this.initializer).getConnectionCapabilities().getUserAgent();
                return vendor == null ? "" : vendor;
            }
            case 13: {
                return new TimeRemainingHolder((int)((System.currentTimeMillis() - this._time) / 1000L));
            }
            case 14: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder(((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getReadSavedFromCompression(), ((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getSentSavedFromCompression());
            }
            case 15: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder(((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getReadSavedFromCompression());
            }
            case 16: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder(((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getSentSavedFromCompression());
            }
            case 17: {
                return new DroppedHolder(((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getReadLostFromSSL(), ((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getSentLostFromSSL());
            }
            case 18: {
                return new DroppedHolder(((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getReadLostFromSSL());
            }
            case 19: {
                return new DroppedHolder(((RoutedConnection)this.initializer).getConnectionBandwidthStatistics().getSentLostFromSSL());
            }
            case 20: {
                if (this._isConnecting) {
                    return null;
                }
                return new QRPHolder(((RoutedConnection)this.initializer).getRoutedConnectionStatistics().getQueryRouteTablePercentFull(), ((RoutedConnection)this.initializer).getRoutedConnectionStatistics().getQueryRouteTableSize());
            }
            case 21: {
                if (this._isConnecting) {
                    return null;
                }
                int empty = ((RoutedConnection)this.initializer).getRoutedConnectionStatistics().getQueryRouteTableEmptyUnits();
                int inuse = ((RoutedConnection)this.initializer).getRoutedConnectionStatistics().getQueryRouteTableUnitsInUse();
                if (empty == -1 || inuse == -1) {
                    return null;
                }
                return empty + " / " + inuse;
            }
        }
        return null;
    }

    private void assignHostName() {
        this._hasResolvedAddress = true;
        BackgroundExecutorService.schedule(new HostAssigner(this));
    }

    @Override
    public LimeTableColumn getColumn(int idx) {
        return ltColumns[idx];
    }

    @Override
    public boolean isClippable(int idx) {
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }

    @Override
    public boolean isDynamic(int idx) {
        switch (idx) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
            case 0: {
                if (_hostChanged) {
                    _hostChanged = false;
                    return true;
                }
                return false;
            }
            case 1: 
            case 11: 
            case 12: {
                if (_updated) {
                    _updated = false;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    boolean isPeer() {
        return ((RoutedConnection)this.initializer).getConnectionCapabilities().isSupernodeSupernodeConnection();
    }

    boolean isUltrapeer() {
        return ((RoutedConnection)this.initializer).getConnectionCapabilities().isClientSupernodeConnection();
    }

    boolean isLeaf() {
        return ((RoutedConnection)this.initializer).isSupernodeClientConnection();
    }

    boolean isConnecting() {
        return this._isConnecting;
    }

    @Override
    public void update() {
        this._isConnecting = false;
        boolean isOutgoing = ((RoutedConnection)this.initializer).isOutgoing();
        this._status = isOutgoing ? OUTGOING_STRING : INCOMING_STRING;
        this._host = ((RoutedConnection)this.initializer).getInetAddress().getHostAddress();
        if (isOutgoing) {
            ConnectionMediator.instance().addKnownHost(this._host, ((RoutedConnection)this.initializer).getPort());
        }
        _updated = true;
        this._time = ((RoutedConnection)this.initializer).getConnectionTime();
    }

    public boolean isConnected() {
        return !this._isConnecting;
    }

    @Override
    public String[] getToolTipArray(int col) {
        Properties p = ((RoutedConnection)this.initializer).getConnectionCapabilities().getHeadersRead().props();
        ArrayList<String> tips = new ArrayList<String>();
        if (p == null) {
            tips.add(CONNECTED_ON + " " + GUIUtils.msec2DateTime(this._time));
        } else {
            tips.add(CONNECTED_ON + " " + GUIUtils.msec2DateTime(this._time));
            tips.add("");
            Enumeration<?> ps = p.propertyNames();
            while (ps.hasMoreElements()) {
                String k = (String)ps.nextElement();
                tips.add(k + ": " + p.getProperty(k));
            }
        }
        return tips.toArray(new String[0]);
    }

    private static class HostAssigner
    implements Runnable {
        private final WeakReference<ConnectionDataLine> line;

        HostAssigner(ConnectionDataLine cdl) {
            this.line = new WeakReference<ConnectionDataLine>(cdl);
        }

        public void run() {
            ConnectionDataLine cdl = (ConnectionDataLine)this.line.get();
            if (cdl != null) {
                try {
                    cdl._host = InetAddress.getByName(cdl._host).getHostName();
                    _hostChanged = true;
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
    }
}

