/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.connection.ConnectionButtons;
import com.limegroup.gnutella.gui.connection.ConnectionDataLine;
import com.limegroup.gnutella.gui.connection.ConnectionModel;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionMediator
extends AbstractTableMediator<ConnectionModel, ConnectionDataLine, RoutedConnection> {
    ActionListener ADD_LISTENER;
    ActionListener BROWSE_HOST_LISTENER;
    private static final String IS_ULTRAPEER = I18n.tr("Ultrapeer");
    private static final String IS_LEAF = I18n.tr("Leaf");
    private static final String CONNECTING = I18n.tr("Connecting");
    private static final String LEAVES = I18n.tr("Leaves");
    private static final String ULTRAPEERS = I18n.tr("Ultrapeers");
    private static final String PEERS = I18n.tr("Peers");
    private static final String STANDARD = I18n.tr("Standard");
    private static final ConnectionMediator INSTANCE = new ConnectionMediator();
    private JLabel SERVENT_STATUS;
    private JLabel NEIGHBORS;

    public static ConnectionMediator instance() {
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.ADD_LISTENER = new AddListener();
        this.BROWSE_HOST_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionMediator.this.doBrowseHost();
            }
        };
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void addListeners() {
        super.addListeners();
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new ConnectionModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new ConnectionButtons(this).getComponent();
        this.SERVENT_STATUS = new JLabel("");
        this.NEIGHBORS = new JLabel("");
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLER);
    }

    @Override
    protected JComponent getScrolledTablePane() {
        JComponent pane = super.getScrolledTablePane();
        this.SCROLL_PANE.setPreferredSize(new Dimension(3000, 5000));
        return pane;
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Connections Window..."));
    }

    @Override
    protected void setupMainPanel() {
        if (this.MAIN_PANEL == null) {
            return;
        }
        super.setupMainPanel();
        JPanel status = new JPanel();
        status.setLayout(new BorderLayout());
        status.add((Component)this.SERVENT_STATUS, "West");
        status.add((Component)this.NEIGHBORS, "East");
        this.MAIN_PANEL.add((Component)status, 0);
    }

    private ConnectionMediator() {
        super("CONNECTION_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        this.doRefresh();
    }

    @Override
    public void removeSelection() {
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        for (int counter = sel.length - 1; counter >= 0; --counter) {
            int i = sel[counter];
            RoutedConnection c = (RoutedConnection)((ConnectionDataLine)((ConnectionModel)this.DATA_MODEL).get(i)).getInitializeObject();
            GuiCoreMediator.getConnectionServices().removeConnection(c);
        }
        this.clearSelection();
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jpm = new JPopupMenu();
        JMenuItem jmi = new JMenuItem(I18n.tr("Add..."));
        jmi.addActionListener(this.ADD_LISTENER);
        jpm.add(jmi);
        jpm.addSeparator();
        jmi = new JMenuItem(I18n.tr("Remove"));
        jmi.addActionListener(this.REMOVE_LISTENER);
        jpm.add(jmi);
        jpm.addSeparator();
        jmi = new JMenuItem(I18n.tr("Browse Host"));
        jmi.addActionListener(this.BROWSE_HOST_LISTENER);
        jpm.add(jmi);
        return jpm;
    }

    @Override
    public void handleSelection(int row) {
        this.setButtonEnabled(1, true);
        this.setButtonEnabled(2, true);
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
    }

    @Override
    public void handleActionKey() {
        this.doBrowseHost();
    }

    private void doBrowseHost() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length > 0) {
            RoutedConnection c = (RoutedConnection)((ConnectionDataLine)((ConnectionModel)this.DATA_MODEL).get(rows[0])).getInitializeObject();
            GUIMediator.instance().doBrowseHost(c);
        }
    }

    @Override
    public void doRefresh() {
        super.doRefresh();
        this.SERVENT_STATUS.setText(I18n.tr("Connection Status:") + "  " + (GuiCoreMediator.getConnectionServices().isSupernode() ? IS_ULTRAPEER : IS_LEAF) + "      ");
        int[] counts = ((ConnectionModel)this.DATA_MODEL).getConnectionInfo();
        this.NEIGHBORS.setText("(" + counts[1] + " " + ULTRAPEERS + ", " + counts[2] + " " + PEERS + ", " + counts[3] + " " + LEAVES + ", " + counts[0] + " " + CONNECTING + ", " + counts[4] + " " + STANDARD + ")");
    }

    public int getConnectingCount() {
        return ((ConnectionModel)this.DATA_MODEL).getConnectingCount();
    }

    private void tryConnection(final String hostname, final int portnum, final SocketsManager.ConnectType type) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                GuiCoreMediator.getConnectionServices().connectToHostAsynchronously(hostname, portnum, type);
            }
        });
    }

    public void clearConnections() {
        ((ConnectionModel)this.DATA_MODEL).clear();
    }

    void addKnownHost(String host, int port) {
    }

    private final class AddListener
    implements ActionListener {
        private JDialog dialog = null;
        private AutoCompleteTextField HOST_INPUT = new ClearableAutoCompleteTextField(20);
        private JTextField PORT_INPUT = new WholeNumberField(6346, 4);
        private JButton OK_BUTTON = new JButton(I18n.tr("OK"));
        private JButton CANCEL_BUTTON = new JButton(I18n.tr("Cancel"));
        private JCheckBox TLS_BOX = new JCheckBox();

        private AddListener() {
        }

        private void createDialog() {
            if (this.dialog != null) {
                return;
            }
            this.dialog = new JDialog(GUIMediator.getAppFrame(), I18n.tr("Add Gnutella Connection"), true);
            JPanel jp = (JPanel)this.dialog.getContentPane();
            GUIUtils.addHideAction(jp);
            jp.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            int spacing = 6;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(spacing, spacing, 0, 0);
            gbc.gridwidth = -1;
            jp.add((Component)new JLabel(I18n.tr("Host:")), gbc);
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(spacing, spacing, 0, spacing);
            jp.add((Component)this.HOST_INPUT, gbc);
            gbc.fill = 0;
            gbc.gridwidth = -1;
            gbc.insets = new Insets(spacing, spacing, 0, 0);
            jp.add((Component)new JLabel(I18n.tr("Port:")), gbc);
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(spacing, spacing, 0, spacing);
            jp.add((Component)this.PORT_INPUT, gbc);
            gbc.fill = 0;
            gbc.gridwidth = -1;
            gbc.insets = new Insets(spacing, spacing, 0, 0);
            jp.add((Component)new JLabel(I18n.tr("Use TLS:")), gbc);
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(spacing, spacing, 0, spacing);
            jp.add((Component)this.TLS_BOX, gbc);
            JPanel buttons = new JPanel();
            this.OK_BUTTON.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String hostnamestr = AddListener.this.HOST_INPUT.getText();
                    String portstr = AddListener.this.PORT_INPUT.getText();
                    int idx = hostnamestr.lastIndexOf(58);
                    if (idx != -1) {
                        AddListener.this.PORT_INPUT.setText(hostnamestr.substring(idx + 1));
                        portstr = AddListener.this.PORT_INPUT.getText();
                        AddListener.this.HOST_INPUT.setText(hostnamestr.substring(0, idx));
                        hostnamestr = AddListener.this.HOST_INPUT.getText();
                    }
                    int portnum = -1;
                    try {
                        portnum = Integer.parseInt(portstr);
                    }
                    catch (NumberFormatException ee) {
                        portnum = 6346;
                    }
                    if (!NetworkUtils.isValidPort(portnum)) {
                        portnum = 6346;
                    }
                    AddListener.this.PORT_INPUT.setText("" + portnum);
                    if (!hostnamestr.equals("")) {
                        ConnectionMediator.this.tryConnection(hostnamestr, portnum, AddListener.this.TLS_BOX.isSelected() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN);
                        AddListener.this.dialog.setVisible(false);
                        AddListener.this.dialog.dispose();
                    } else {
                        AddListener.this.HOST_INPUT.requestFocus();
                    }
                }
            });
            this.CANCEL_BUTTON.addActionListener(GUIUtils.getDisposeAction());
            buttons.add(this.OK_BUTTON);
            buttons.add(this.CANCEL_BUTTON);
            gbc.gridwidth = 0;
            gbc.gridheight = 0;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = new Insets(spacing, spacing, spacing, spacing);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            jp.add((Component)buttons, gbc);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.dialog.getRootPane().setDefaultButton(this.OK_BUTTON);
            this.dialog.pack();
            GUIUtils.centerOnScreen(this.dialog);
            this.dialog.setVisible(true);
        }
    }
}

