/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.connection.ConnectionCapabilities;
import com.limegroup.gnutella.gui.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolHolder
implements Comparable<ProtocolHolder> {
    private String _string;
    private static final String LEAF = I18n.tr("Leaf");
    private static final String ULTRAPEER = I18n.tr("Ultrapeer");
    private static final String PEER = I18n.tr("Peer");
    private static final String STANDARD = I18n.tr("0.6");
    private ConnectionCapabilities _c;

    public ProtocolHolder(ConnectionCapabilities c) {
        this._c = c;
        this._string = c.isSupernodeClientConnection() ? LEAF : (c.isClientSupernodeConnection() ? ULTRAPEER : (c.isSupernodeSupernodeConnection() ? PEER : STANDARD));
    }

    @Override
    public int compareTo(ProtocolHolder other) {
        return ProtocolHolder.weightHostInfo(this._c) - ProtocolHolder.weightHostInfo(other._c);
    }

    private static int weightHostInfo(ConnectionCapabilities c) {
        if (c.isSupernodeConnection()) {
            if (c.isClientSupernodeConnection()) {
                return 1;
            }
            return 4;
        }
        if (c.isSupernodeClientConnection()) {
            return 2;
        }
        return 3;
    }

    public String toString() {
        return this._string;
    }
}

