/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public class CompositeTransferable
implements Transferable {
    private final Transferable t1;
    private final Transferable t2;

    public CompositeTransferable(Transferable t1, Transferable t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    public DataFlavor[] getTransferDataFlavors() {
        LinkedList<DataFlavor> flavors = new LinkedList<DataFlavor>();
        flavors.addAll(Arrays.asList(this.t1.getTransferDataFlavors()));
        flavors.addAll(Arrays.asList(this.t2.getTransferDataFlavors()));
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.t1.isDataFlavorSupported(flavor) || this.t2.isDataFlavorSupported(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.t1.isDataFlavorSupported(flavor)) {
            return this.t1.getTransferData(flavor);
        }
        if (this.t2.isDataFlavorSupported(flavor)) {
            return this.t2.getTransferData(flavor);
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

