/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;

public class MagnetTransferHandler
extends LimeTransferHandler {
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return this.canImport(c, flavors);
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return DNDUtils.contains(transferFlavors, FileTransferable.URIFlavor);
    }

    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return this.importData(c, t);
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            MagnetOptions[] magnets = MagnetOptions.parseMagnets((String)t.getTransferData(FileTransferable.URIFlavor));
            if (magnets.length > 0) {
                MagnetClipboardListener.handleMagnets(magnets, false);
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

