/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.bittorrent.gui.TorrentDownloadFactory;
import com.limegroup.bittorrent.gui.TorrentFileFetcher;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.dock.DockIcon;
import com.limegroup.gnutella.gui.dock.DockIconFactoryImpl;
import com.limegroup.gnutella.gui.download.DownloadButtons;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadModel;
import com.limegroup.gnutella.gui.download.DownloadTransferHandler;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SimpleColumnListener;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DownloadMediator
extends AbstractTableMediator<DownloadModel, DownloadDataLine, Downloader>
implements FileDetailsProvider {
    private static final Log LOG = LogFactory.getLog(DownloadMediator.class);
    @InspectablePrimitive(value="resume button clicks")
    private static volatile int resumeClicks;
    private static int _totalDownloads;
    private static boolean _audioLaunched;
    private static DownloadMediator _instance;
    private Action removeAction;
    private Action chatAction;
    private Action clearAction;
    private Action browseAction;
    private Action launchAction;
    private Action resumeAction;
    private Action pauseAction;
    private Action priorityUpAction;
    private Action priorityDownAction;
    private Action editLocationAction;
    private Action magnetAction;
    private Action bitziAction;
    private Action exploreAction;
    private DownloadButtons _downloadButtons;
    private final DockIcon dockIcon;

    public static DownloadMediator instance() {
        return _instance;
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new DownloadTransferHandler());
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.removeAction = new RemoveAction();
        this.chatAction = new ChatAction();
        this.clearAction = new ClearAction();
        this.browseAction = new BrowseAction();
        this.launchAction = new LaunchAction();
        this.resumeAction = new ResumeAction();
        this.pauseAction = new PauseAction();
        this.priorityUpAction = new PriorityUpAction();
        this.priorityDownAction = new PriorityDownAction();
        this.editLocationAction = new EditLocationAction();
        this.magnetAction = new CopyMagnetLinkToClipboardAction(this);
        this.exploreAction = new ExploreAction();
        this.bitziAction = new BitziLookupAction(this);
    }

    public Action[] getActions() {
        Action[] actions = OSUtils.isWindows() || OSUtils.isMacOSX() ? new Action[]{this.priorityUpAction, this.priorityDownAction, this.removeAction, this.resumeAction, this.pauseAction, this.launchAction, this.exploreAction, this.clearAction} : new Action[]{this.priorityUpAction, this.priorityDownAction, this.removeAction, this.resumeAction, this.pauseAction, this.launchAction, this.clearAction};
        return actions;
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(I18n.tr("Downloads"));
        this.DATA_MODEL = new DownloadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this._downloadButtons = new DownloadButtons(this);
        this.BUTTON_ROW = this._downloadButtons.getComponent();
    }

    @Override
    protected void setupTableHeaders() {
        super.setupTableHeaders();
        Object pId = ((DownloadModel)this.DATA_MODEL).getColumnId(0);
        this._downloadButtons.setQueuePanelVisible(this.TABLE.isColumnVisible(pId));
        ColumnPreferenceHandler cph = this.TABLE.getColumnPreferenceHandler();
        cph.setSimpleColumnListener(new SimpleColumnListener(){

            public void columnAdded(LimeTableColumn ltc, LimeJTable table) {
                assert (table == DownloadMediator.this.TABLE);
                if (ltc.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(true);
                }
            }

            public void columnRemoved(LimeTableColumn ltc, LimeJTable table) {
                assert (table == DownloadMediator.this.TABLE);
                if (ltc.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(false);
                }
            }
        });
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Download Window..."));
    }

    private DownloadMediator() {
        super("DOWNLOAD_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        if (this.SETTINGS.REAL_TIME_SORT.getValue()) {
            ((DownloadModel)this.DATA_MODEL).sort(0);
        }
        this.dockIcon = new DockIconFactoryImpl().createDockIcon();
    }

    @Override
    public void doRefresh() {
        boolean inactivePresent = (Boolean)((DownloadModel)this.DATA_MODEL).refresh();
        this.clearAction.setEnabled(inactivePresent);
        int[] selRows = this.TABLE.getSelectedRows();
        if (selRows.length > 0) {
            DownloadDataLine dataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(selRows[0]);
            if (dataLine.getState() == Downloader.DownloadStatus.WAITING_FOR_USER) {
                this.resumeAction.putValue("Name", I18n.tr("Find More Sources for Download"));
                this.resumeAction.putValue("LimeShortName", I18n.tr("Find Sources"));
                this.resumeAction.putValue("ShortDescription", I18n.tr("Try to Find Additional Sources for Downloads"));
            } else {
                this.resumeAction.putValue("Name", I18n.tr("Resume Download"));
                this.resumeAction.putValue("LimeShortName", I18n.tr("Resume"));
                this.resumeAction.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
            }
            Downloader dl = dataLine.getDownloader();
            boolean inactive = dataLine.isDownloaderInactive();
            boolean resumable = dl.isResumable();
            boolean pausable = dl.isPausable();
            boolean completed = dl.isCompleted();
            this.resumeAction.setEnabled(resumable);
            this.pauseAction.setEnabled(pausable);
            this.priorityUpAction.setEnabled(inactive && pausable);
            this.priorityDownAction.setEnabled(inactive && pausable);
            this.exploreAction.setEnabled(completed || inactive);
        }
        this.dockIcon.draw(this.getCompleteDownloads());
    }

    public int getCompleteDownloads() {
        int complete = 0;
        for (int row = 0; row < ((DownloadModel)this.DATA_MODEL).getRowCount(); ++row) {
            DownloadDataLine dataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(row);
            if (dataLine.getState() != Downloader.DownloadStatus.COMPLETE) continue;
            ++complete;
        }
        return complete;
    }

    public int getTotalDownloads() {
        return _totalDownloads;
    }

    public int getCurrentDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getCurrentDownloads();
    }

    public int getActiveDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getRowCount();
    }

    public Set<String> getFileNames() {
        HashSet<String> names = new HashSet<String>();
        for (int c = 0; c < ((DownloadModel)this.DATA_MODEL).getRowCount(); ++c) {
            names.add(((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(c)).getFileName());
        }
        return names;
    }

    public double getActiveDownloadsBandwidth() {
        return ((DownloadModel)this.DATA_MODEL).getActiveDownloadsBandwidth();
    }

    @Override
    public void add(Downloader downloader) {
        if (!((DownloadModel)this.DATA_MODEL).contains(downloader)) {
            ++_totalDownloads;
            super.add(downloader);
        }
    }

    @Override
    public void remove(Downloader dloader) {
        Downloader.DownloadStatus state = dloader.getState();
        if (state == Downloader.DownloadStatus.COMPLETE && this.isThemeFile(dloader.getSaveFile().getName())) {
            File themeFile = dloader.getDownloadFragment();
            themeFile = this.copyToThemeDir(themeFile);
            if (OptionsMediator.instance().isOptionsVisible()) {
                GUIMediator.showMessage(I18n.tr("You have downloaded a skin titled \"{0}\", you can activate the new skin by clicking \"{1}\" in the \"{2}\"->\"{3}\" menu and then selecting it from the list of available skins.", ThemeSettings.formatName(dloader.getSaveFile().getName()), I18n.tr("&Refresh Skins"), I18n.tr("&View"), I18n.tr("&Apply Skins")));
            } else {
                DialogOption response = GUIMediator.showYesNoMessage(I18n.tr("You have downloaded a new skin titled {0}. Would you like to use this new skin?", ThemeSettings.formatName(dloader.getSaveFile().getName())), QuestionsHandler.THEME_DOWNLOADED, DialogOption.YES);
                if (response == DialogOption.YES) {
                    ThemeMediator.changeTheme(themeFile);
                }
            }
        }
        if (state == Downloader.DownloadStatus.COMPLETE && BittorrentSettings.TORRENT_AUTO_START.getValue() && this.isTorrentFile(dloader.getSaveFile().getName())) {
            GUIMediator.instance().openTorrent(dloader.getSaveFile());
        }
        if (SharingSettings.CLEAR_DOWNLOAD.getValue() && (state == Downloader.DownloadStatus.COMPLETE || state == Downloader.DownloadStatus.ABORTED)) {
            super.remove(dloader);
        } else {
            DownloadDataLine ddl = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(dloader);
            if (ddl != null) {
                ddl.setEndTime(System.currentTimeMillis());
            }
        }
    }

    public void openTorrent(File file) {
        try {
            TorrentDownloadFactory factory = new TorrentDownloadFactory(file);
            DownloaderUtils.createDownloader(factory);
            if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
                File tFile = GuiCoreMediator.getTorrentManager().getSharedTorrentMetaDataFile(factory.getBTMetaInfo());
                File backup = null;
                if (tFile.exists()) {
                    if (tFile.equals(file)) {
                        return;
                    }
                    GuiCoreMediator.getFileManager().stopSharingFile(tFile);
                    backup = new File(tFile.getParent(), tFile.getName().concat(".bak"));
                    FileUtils.forceRename(tFile, backup);
                }
                if (!FileUtils.copy(file, tFile) && backup != null && FileUtils.forceRename(backup, tFile)) {
                    GuiCoreMediator.getFileManager().addFileIfShared(tFile);
                }
            }
        }
        catch (IOException ioe) {
            GUIMediator.showError(I18n.tr("FrostWire was unable to load the torrent file \"{0}\", - it may be malformed or FrostWire does not have permission to access this file.", file.getName()), QuestionsHandler.TORRENT_OPEN_FAILURE);
        }
    }

    public void openTorrentURI(URI uri) {
        TorrentFileFetcher fetcher = new TorrentFileFetcher(uri, GuiCoreMediator.getDownloadManager());
        this.add(fetcher);
        fetcher.fetch();
    }

    private File copyToThemeDir(File themeFile) {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        File realLoc = new File(themeDir, themeFile.getName());
        if (realLoc.equals(themeFile)) {
            return themeFile;
        }
        realLoc.delete();
        FileUtils.copy(themeFile, realLoc);
        return realLoc;
    }

    private boolean isThemeFile(String name) {
        return name.toLowerCase().endsWith("fwtp");
    }

    private boolean isTorrentFile(String name) {
        return name.toLowerCase().endsWith(".torrent");
    }

    void launchSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        if (sel.length == 0) {
            return;
        }
        GUILauncher.LaunchableProvider[] providers = new GUILauncher.LaunchableProvider[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            providers[i] = new DownloaderProvider(((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i])).getDownloader());
        }
        GUILauncher.launch(providers);
    }

    void pauseSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            ((Downloader)((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i])).getInitializeObject()).pause();
        }
    }

    void launchExplorer() {
        int[] sel = this.TABLE.getSelectedRows();
        Downloader dl = (Downloader)((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[sel.length - 1])).getInitializeObject();
        File toExplore = dl.getFile();
        if (toExplore == null) {
            return;
        }
        GUIMediator.launchExplorer(toExplore);
    }

    void bumpPriority(final boolean up, int amt) {
        int i;
        int[] sel = this.TABLE.getSelectedRows();
        DownloadDataLine[] lines = new DownloadDataLine[sel.length];
        for (i = 0; i < sel.length; ++i) {
            lines[i] = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i]);
        }
        Arrays.sort(lines, new Comparator<DownloadDataLine>(){

            @Override
            public int compare(DownloadDataLine a, DownloadDataLine b) {
                int pb;
                int pa = ((Downloader)a.getInitializeObject()).getInactivePriority();
                return (pa < (pb = ((Downloader)b.getInitializeObject()).getInactivePriority()) ? -1 : (pa > pb ? 1 : 0)) * (up ? 1 : -1);
            }
        });
        for (i = 0; i < lines.length; ++i) {
            Downloader dl = (Downloader)lines[i].getInitializeObject();
            GuiCoreMediator.getDownloadManager().bumpPriority(dl, up, amt);
        }
    }

    FileTransfer[] getSelectedFileTransfers() {
        int[] sel = this.TABLE.getSelectedRows();
        ArrayList<FileTransfer> transfers = new ArrayList<FileTransfer>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            DownloadDataLine line = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i]);
            Downloader downloader = line.getDownloader();
            if (downloader.getState() == Downloader.DownloadStatus.COMPLETE && !downloader.getSaveFile().exists() || !downloader.isLaunchable()) continue;
            transfers.add(line.getFileTransfer());
        }
        return transfers.toArray(new FileTransfer[transfers.size()]);
    }

    void resumeSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            DownloadDataLine dd = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i]);
            Downloader downloader = dd.getDownloader();
            if (dd.isCleaned()) continue;
            downloader.resume();
        }
        ++resumeClicks;
    }

    void chatWithSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            DownloadDataLine dd = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i]);
            Downloader downloader = (Downloader)dd.getInitializeObject();
            Endpoint end = downloader.getChatEnabledHost();
            if (end == null) continue;
            GUIMediator.createChat(end.getAddress(), end.getPort());
        }
    }

    void editSelectedDownload() {
        int[] sel = this.TABLE.getSelectedRows();
        Downloader dl = (Downloader)((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[0])).getInitializeObject();
        File saveLocation = dl.getSaveFile();
        File saveFile = FileChooserHandler.getSaveAsFile(MessageService.getParentComponent(), I18nMarker.marktr("Choose Save Location"), saveLocation);
        if (saveFile == null) {
            return;
        }
        try {
            if (!saveFile.equals(dl.getSaveFile())) {
                dl.setSaveFile(saveFile.getParentFile(), saveFile.getName(), false);
            }
        }
        catch (SaveLocationException sle) {
            CoreExceptionHandler.handleSaveLocationError(sle);
        }
    }

    void browseSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            DownloadDataLine dd = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i]);
            Downloader downloader = (Downloader)dd.getInitializeObject();
            RemoteFileDesc end = downloader.getBrowseEnabledHost();
            if (end == null) continue;
            SearchMediator.doBrowseHost(end);
        }
    }

    @Override
    public void handleActionKey() {
        if (this.launchAction.isEnabled()) {
            this.launchSelectedDownloads();
        }
    }

    void clearCompletedDownloads() {
        ((DownloadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.clearAction.setEnabled(false);
        this.dockIcon.draw(0);
    }

    @Override
    public FileDetails[] getFileDetails() {
        int[] sel = this.TABLE.getSelectedRows();
        FileManager fmanager = GuiCoreMediator.getFileManager();
        ArrayList<FileDetails> list = new ArrayList<FileDetails>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            URN urn = ((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[i])).getDownloader().getSha1Urn();
            if (urn != null) {
                FileDesc fd = fmanager.getFileDescForUrn(urn);
                if (fd != null) {
                    list.add(GuiCoreMediator.getLocalFileDetailsFactory().create(fd));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("not filedesc for urn " + urn);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("no urn");
        }
        return list.toArray(new FileDetails[0]);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(this.removeAction));
        menu.add(new JMenuItem(this.resumeAction));
        menu.add(new JMenuItem(this.pauseAction));
        menu.add(new JMenuItem(this.launchAction));
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            menu.add(new JMenuItem(this.exploreAction));
        }
        menu.addSeparator();
        menu.add(new JMenuItem(this.clearAction));
        menu.addSeparator();
        menu.add(this.createSearchMenu());
        menu.add(new JMenuItem(this.chatAction));
        menu.add(new JMenuItem(this.browseAction));
        menu.add(new JMenuItem(this.editLocationAction));
        return menu;
    }

    private JMenu createSearchMenu() {
        SearchInformation info;
        String filename;
        int dotPos;
        JMenu menu = new JMenu(I18n.tr("Search..."));
        int[] sel = this.TABLE.getSelectedRows();
        if (sel.length == 0) {
            menu.setEnabled(false);
            return menu;
        }
        DownloadDataLine line = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(sel[0]);
        Downloader downloader = line.getDownloader();
        Map searchInfoMap = (Map)downloader.getAttribute("searchInformationMap");
        if (searchInfoMap != null) {
            SearchInformation searchInfo = SearchInformation.createFromMap(searchInfoMap);
            menu.add(new JMenuItem(new SearchAction(searchInfo)));
        }
        if ((dotPos = (filename = line.getFileName()).lastIndexOf(46)) > 0) {
            filename = filename.substring(0, dotPos);
        }
        if ((filename = QueryUtils.removeIllegalChars(filename)).length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            filename = filename.substring(0, SearchSettings.MAX_QUERY_LENGTH.getValue());
        }
        if (SearchMediator.validateInfo(info = SearchInformation.createKeywordSearch(filename, null, MediaType.getAnyTypeMediaType())) == 0) {
            menu.add(new JMenuItem(new SearchAction(info, I18nMarker.marktr("Search for Keywords: {0}"))));
        }
        return menu;
    }

    @Override
    public void handleSelection(int row) {
        DownloadDataLine dataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(row);
        this.chatAction.setEnabled(dataLine.getChatEnabled());
        this.browseAction.setEnabled(dataLine.getBrowseEnabled());
        boolean inactive = dataLine.isDownloaderInactive();
        boolean pausable = dataLine.getDownloader().isPausable();
        if (dataLine.getState() == Downloader.DownloadStatus.WAITING_FOR_USER) {
            this.resumeAction.putValue("Name", I18n.tr("Find More Sources for Download"));
            this.resumeAction.putValue("LimeShortName", I18n.tr("Find Sources"));
            this.resumeAction.putValue("ShortDescription", I18n.tr("Try to Find Additional Sources for Downloads"));
        } else {
            this.resumeAction.putValue("Name", I18n.tr("Resume Download"));
            this.resumeAction.putValue("LimeShortName", I18n.tr("Resume"));
            this.resumeAction.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
        }
        if (dataLine.isCompleted()) {
            this.removeAction.putValue("Name", I18n.tr("Clear Download"));
            this.removeAction.putValue("LimeShortName", I18n.tr("Clear"));
            this.removeAction.putValue("ShortDescription", I18n.tr("Clear Selected Downloads"));
            this.launchAction.putValue("Name", I18n.tr("Launch Download"));
            this.launchAction.putValue("LimeShortName", I18n.tr("Launch"));
            this.launchAction.putValue("ShortDescription", I18n.tr("Launch Selected Downloads"));
            this.exploreAction.setEnabled(this.TABLE.getSelectedRowCount() == 1);
        } else {
            this.removeAction.putValue("Name", I18n.tr("Cancel Download"));
            this.removeAction.putValue("LimeShortName", I18n.tr("Cancel"));
            this.removeAction.putValue("ShortDescription", I18n.tr("Cancel Selected Downloads"));
            this.launchAction.putValue("Name", I18n.tr("Preview Download"));
            this.launchAction.putValue("LimeShortName", I18n.tr("Preview"));
            this.launchAction.putValue("ShortDescription", I18n.tr("Preview Selected Downloads"));
            this.exploreAction.setEnabled(false);
        }
        this.removeAction.setEnabled(true);
        this.resumeAction.setEnabled(inactive);
        this.pauseAction.setEnabled(pausable);
        this.priorityDownAction.setEnabled(inactive && pausable);
        this.priorityUpAction.setEnabled(inactive && pausable);
        Downloader dl = (Downloader)dataLine.getInitializeObject();
        this.editLocationAction.setEnabled(this.TABLE.getSelectedRowCount() == 1 && dl.isRelocatable());
        this.magnetAction.setEnabled(dl.getSha1Urn() != null);
        this.bitziAction.setEnabled(dl.getSha1Urn() != null);
        this.launchAction.setEnabled(dl.isLaunchable());
    }

    @Override
    public void handleNoSelection() {
        this.removeAction.setEnabled(false);
        this.resumeAction.setEnabled(false);
        this.launchAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.chatAction.setEnabled(false);
        this.browseAction.setEnabled(false);
        this.priorityDownAction.setEnabled(false);
        this.priorityUpAction.setEnabled(false);
        this.editLocationAction.setEnabled(false);
        this.magnetAction.setEnabled(false);
        this.bitziAction.setEnabled(false);
        this.exploreAction.setEnabled(false);
    }

    static {
        _totalDownloads = 0;
        _audioLaunched = false;
        _instance = new DownloadMediator();
    }

    private static class DownloaderProvider
    implements GUILauncher.LaunchableProvider {
        private final Downloader downloader;

        public DownloaderProvider(Downloader downloader) {
            this.downloader = downloader;
        }

        public Downloader getDownloader() {
            return this.downloader;
        }

        public File getFile() {
            return null;
        }
    }

    private class EditLocationAction
    extends RefreshingAction {
        public EditLocationAction() {
            this.putValue("Name", I18n.tr("Change File Location..."));
            this.putValue("ShortDescription", I18n.tr("Edit the Final Filename of the Download"));
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.editSelectedDownload();
        }
    }

    private class PriorityDownAction
    extends RefreshingAction {
        public PriorityDownAction() {
            this.putValue("LimeShortName", "");
            this.putValue("ShortDescription", I18n.tr("Move the Selected Download Further from Becoming Active"));
            this.putValue("LimeIconName", "DOWNLOAD_PRIORITY_DOWN");
        }

        public void performAction(ActionEvent e) {
            if ((e.getModifiers() & 2) != 0) {
                DownloadMediator.this.bumpPriority(false, 10);
            } else if ((e.getModifiers() & 8) != 0) {
                DownloadMediator.this.bumpPriority(false, 0);
            } else {
                DownloadMediator.this.bumpPriority(false, 1);
            }
        }
    }

    private class PriorityUpAction
    extends RefreshingAction {
        public PriorityUpAction() {
            this.putValue("LimeShortName", "");
            this.putValue("ShortDescription", I18n.tr("Move the Selected Download Closer to Becoming Active"));
            this.putValue("LimeIconName", "DOWNLOAD_PRIORITY_UP");
        }

        public void performAction(ActionEvent e) {
            if ((e.getModifiers() & 2) != 0) {
                DownloadMediator.this.bumpPriority(true, 10);
            } else if ((e.getModifiers() & 8) != 0) {
                DownloadMediator.this.bumpPriority(true, 0);
            } else {
                DownloadMediator.this.bumpPriority(true, 1);
            }
        }
    }

    private class ExploreAction
    extends RefreshingAction {
        public ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.launchExplorer();
        }
    }

    private class PauseAction
    extends RefreshingAction {
        public PauseAction() {
            this.putValue("Name", I18n.tr("Pause Download"));
            this.putValue("LimeShortName", I18n.tr("Pause"));
            this.putValue("ShortDescription", I18n.tr("Pause Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_PAUSE");
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.pauseSelectedDownloads();
        }
    }

    private class ResumeAction
    extends RefreshingAction {
        public ResumeAction() {
            this.putValue("Name", I18n.tr("Resume Download"));
            this.putValue("LimeShortName", I18n.tr("Resume"));
            this.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_FILE_MORE_SOURCES");
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.resumeSelectedDownloads();
        }
    }

    private class LaunchAction
    extends RefreshingAction {
        public LaunchAction() {
            this.putValue("Name", I18n.tr("Preview Download"));
            this.putValue("LimeShortName", I18n.tr("Preview"));
            this.putValue("ShortDescription", I18n.tr("Preview Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_LAUNCH");
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.launchSelectedDownloads();
        }
    }

    private class BrowseAction
    extends RefreshingAction {
        public BrowseAction() {
            this.putValue("Name", I18n.tr("Browse Host"));
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.browseSelectedDownloads();
        }
    }

    private class ClearAction
    extends RefreshingAction {
        public ClearAction() {
            this.putValue("Name", I18n.tr("Clear All Inactive Downloads"));
            this.putValue("LimeShortName", I18n.tr("Clear Inactive"));
            this.putValue("ShortDescription", I18n.tr("Remove Inactive Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_CLEAR");
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.clearCompletedDownloads();
        }
    }

    private class ChatAction
    extends RefreshingAction {
        public ChatAction() {
            this.putValue("Name", I18n.tr("Chat with Host"));
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.chatWithSelectedDownloads();
        }
    }

    private class RemoveAction
    extends RefreshingAction {
        public RemoveAction() {
            this.putValue("Name", I18n.tr("Cancel Download"));
            this.putValue("LimeShortName", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_KILL");
        }

        public void performAction(ActionEvent e) {
            DownloadMediator.this.removeSelection();
        }
    }

    private abstract class RefreshingAction
    extends AbstractAction {
        private RefreshingAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            this.performAction(e);
            DownloadMediator.this.doRefresh();
        }

        protected abstract void performAction(ActionEvent var1);
    }
}

