/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultDownloaderFactory
implements GuiDownloaderFactory {
    private RemoteFileDesc[] rfds;
    private List<? extends RemoteFileDesc> alts;
    private GUID queryGUID;
    private File saveDir;
    private String fileName;

    public SearchResultDownloaderFactory(RemoteFileDesc[] rfds, List<? extends RemoteFileDesc> alts, GUID queryGUID, File saveDir, String fileName) {
        this.rfds = rfds;
        this.alts = alts;
        this.queryGUID = queryGUID;
        this.saveDir = saveDir;
        this.fileName = fileName != null ? fileName : rfds[0].getFileName();
    }

    @Override
    public URN getURN() {
        return this.rfds[0].getSHA1Urn();
    }

    @Override
    public Downloader createDownloader(boolean overwrite) throws SaveLocationException {
        return GuiCoreMediator.getDownloadServices().download(this.rfds, this.alts, this.queryGUID, overwrite, this.saveDir, this.fileName);
    }

    @Override
    public File getSaveFile() {
        return new File(this.saveDir != null ? this.saveDir : SharingSettings.getSaveDirectory(this.fileName), this.fileName);
    }

    @Override
    public void setSaveFile(File saveFile) {
        File parentDir = saveFile.getParentFile();
        this.fileName = saveFile.getName();
        this.saveDir = SharingSettings.getSaveDirectory(this.fileName).equals(parentDir) ? null : parentDir;
    }

    @Override
    public long getFileSize() {
        return this.rfds[0].getSize();
    }
}

