/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.gui.shell.LimeAssociations;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public class AssociationsWindow
extends SetupWindow {
    private Map<JCheckBox, LimeAssociationOption> associations = new HashMap<JCheckBox, LimeAssociationOption>();
    private JRadioButton always;
    private JRadioButton never;
    private JRadioButton ask;

    AssociationsWindow(SetupManager manager) {
        super(manager, I18nMarker.marktr("File & Protocol Associations"), I18nMarker.marktr("What type of resources should FrostWire open?"));
    }

    protected void createWindow() {
        super.createWindow();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(1, 4, 1, 0);
        for (LimeAssociationOption option : LimeAssociations.getSupportedAssociations()) {
            JCheckBox box = new JCheckBox(option.getDescription());
            box.setSelected(true);
            this.associations.put(box, option);
            panel.add((Component)box, gbc);
        }
        gbc.insets = new Insets(9, 3, 9, 3);
        gbc.fill = 2;
        panel.add((Component)new Line(), gbc);
        gbc.fill = 0;
        gbc.insets = new Insets(1, 0, 2, 0);
        panel.add((Component)new JLabel(I18n.tr("What should FrostWire do with the selected associations on startup?")), gbc);
        int value = QuestionsHandler.GRAB_ASSOCIATIONS.getValue();
        this.always = new JRadioButton(I18n.tr("Always take the selected associations."), DialogOption.parseInt(value) == DialogOption.YES);
        this.never = new JRadioButton(I18n.tr("Ignore all missing associations."), DialogOption.parseInt(value) == DialogOption.NO);
        this.ask = new JRadioButton(I18n.tr("Ask me what to do when an association is missing."), DialogOption.parseInt(value) != DialogOption.YES && DialogOption.parseInt(value) != DialogOption.NO);
        ButtonGroup grabGroup = new ButtonGroup();
        grabGroup.add(this.always);
        grabGroup.add(this.ask);
        grabGroup.add(this.never);
        this.always.setSelected(true);
        gbc.insets = new Insets(1, 4, 1, 0);
        panel.add((Component)this.always, gbc);
        panel.add((Component)this.ask, gbc);
        panel.add((Component)this.never, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridheight = 0;
        panel.add(Box.createGlue(), gbc);
        this.setSetupComponent(panel);
    }

    public void applySettings(boolean loadCoreComponents) {
        for (Map.Entry<JCheckBox, LimeAssociationOption> entry : this.associations.entrySet()) {
            LimeAssociationOption option = entry.getValue();
            if (entry.getKey().isSelected()) {
                option.setAllowed(true);
                option.setEnabled(true);
                continue;
            }
            if (option.isEnabled()) {
                option.setAllowed(false);
            }
            option.setEnabled(false);
        }
        DialogOption value = DialogOption.INVALID;
        if (this.always.isSelected()) {
            value = DialogOption.YES;
        } else if (this.never.isSelected()) {
            value = DialogOption.NO;
        }
        QuestionsHandler.GRAB_ASSOCIATIONS.setValue(value.toInt());
    }
}

