/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.init.IntentPanel;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JPanel;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;

final class IntentWindow
extends SetupWindow {
    private boolean setWillNot = false;
    private Properties properties;

    IntentWindow(SetupManager manager) {
        super(manager, I18nMarker.marktr("State Your Intent"), I18nMarker.marktr("One more thing..."));
    }

    private boolean isCurrentVersionChecked() {
        String exists;
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.properties.load(new FileInputStream(this.getPropertiesFile()));
            }
            catch (IOException iox) {
                System.out.println("Could not load properties from property file.");
                return false;
            }
        }
        return (exists = this.properties.getProperty("willnot")) != null && exists.equals("true");
    }

    boolean isConfirmedWillNot() {
        return this.isCurrentVersionChecked() || this.setWillNot;
    }

    protected void createWindow() {
        super.createWindow();
        JPanel innerPanel = new JPanel(new BorderLayout());
        final IntentPanel intentPanel = new IntentPanel();
        innerPanel.add((Component)intentPanel, "Center");
        this.setSetupComponent(innerPanel);
        this.setNext(null);
        intentPanel.addButtonListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (intentPanel.hasSelection()) {
                    IntentWindow.this.setNext(IntentWindow.this);
                    IntentWindow.this.setWillNot = intentPanel.isWillNot();
                    IntentWindow.this._manager.enableActions(IntentWindow.this.getAppropriateActions());
                }
            }
        });
    }

    public void applySettings(boolean loadCoreComponents) {
        if (this.setWillNot) {
            this.properties.put("willnot", "true");
            try {
                this.properties.store(new FileOutputStream(this.getPropertiesFile()), "Started & Ran Versions");
            }
            catch (IOException ignored) {
                System.out.println(ignored);
            }
        }
    }

    private File getPropertiesFile() {
        return new File(CommonUtils.getUserSettingsDir(), "intent.props");
    }
}

