/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.gnutella.gui.chat.ChatMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.MacOSXUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

final class MiscWindow
extends SetupWindow {
    private ButtonGroup _speedGroup;
    private JRadioButton _modem;
    private JRadioButton _cable;
    private JRadioButton _t1;
    private JRadioButton _t3;
    private JTextField _ircNickField;
    private JCheckBox _startup;
    private JCheckBox _filter;

    MiscWindow(SetupManager manager) {
        super(manager, I18nMarker.marktr("Miscellaneous Settings"), I18nMarker.marktr("Below, are several options that affect the performance and functionality of FrostWire."));
    }

    protected void createWindow() {
        super.createWindow();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(new TitledBorder(I18n.tr("Network Speed")));
        this._speedGroup = new ButtonGroup();
        this._t1 = new JRadioButton(I18n.tr("T1"));
        this._t3 = new JRadioButton(I18n.tr("T3"));
        this._modem = new JRadioButton(I18n.tr("Dial Up"));
        this._cable = new JRadioButton(I18n.tr("Broadband (or unsure)"));
        this._speedGroup.add(this._t3);
        this._speedGroup.add(this._t1);
        this._speedGroup.add(this._cable);
        this._speedGroup.add(this._modem);
        SetupWindow.MultiLineLabel speedDesc = new SetupWindow.MultiLineLabel(I18n.tr("Please choose the speed of your internet connection. Setting this speed correctly is important for optimum network performance."));
        speedDesc.setOpaque(false);
        speedDesc.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        speedDesc.setForeground(Color.black);
        speedDesc.setFont(speedDesc.getFont().deriveFont(0));
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        buttonPanel.add((Component)speedDesc, gbc);
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.gridwidth = 1;
        buttonPanel.add((Component)this._t3, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        buttonPanel.add((Component)this._t1, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = -1;
        buttonPanel.add((Component)this._cable, gbc);
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        buttonPanel.add((Component)this._modem, gbc);
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.weightx = 1.0;
        mainPanel.add((Component)buttonPanel, gbc);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            gbc = new GridBagConstraints();
            JPanel startupPanel = new JPanel(new GridBagLayout());
            startupPanel.setBorder(new TitledBorder(I18n.tr("System Startup")));
            this._startup = new JCheckBox(I18n.tr("Start Automatically"));
            this._startup.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
            System.out.println("********START UP AUTOMAGICALLY?: ******" + StartupSettings.RUN_ON_STARTUP.getValue());
            SetupWindow.MultiLineLabel desc = new SetupWindow.MultiLineLabel(I18n.tr("Would you like FrostWire to start when you log into your computer? This will cause FrostWire to start faster when you use it later."));
            desc.setOpaque(false);
            desc.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
            desc.setForeground(Color.black);
            desc.setFont(desc.getFont().deriveFont(0));
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            startupPanel.add((Component)desc, gbc);
            startupPanel.add((Component)this._startup, gbc);
            gbc.insets = new Insets(0, 0, 10, 0);
            mainPanel.add((Component)startupPanel, gbc);
        }
        JPanel chatCommunityPanel = new JPanel(new GridLayout(2, 0));
        chatCommunityPanel.setBorder(new TitledBorder(I18n.tr("Chat Community")));
        SetupWindow.MultiLineLabel descChat = new SetupWindow.MultiLineLabel(I18n.tr("FrostWire's Community Chat Tab requires you to have a nickname to communicate with others in the chatrooms."));
        descChat.setOpaque(false);
        descChat.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        descChat.setForeground(Color.black);
        descChat.setFont(descChat.getFont().deriveFont(0));
        this._ircNickField = new SizedTextField(new Dimension(100, 20));
        LabeledComponent textField = new LabeledComponent(I18n.tr("Type your chat nickname here (any name):"), this._ircNickField, 130, 10);
        textField.getBoxPanelComponent().setBorder(new EmptyBorder(0, 10, 5, 5));
        chatCommunityPanel.add(descChat);
        chatCommunityPanel.add(textField.getComponent());
        GridBagConstraints outerLayoutConstraints = new GridBagConstraints();
        outerLayoutConstraints.gridwidth = 0;
        outerLayoutConstraints.fill = 2;
        outerLayoutConstraints.gridy = -1;
        mainPanel.add((Component)chatCommunityPanel, outerLayoutConstraints);
        gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JPanel(), gbc);
        this.setSetupComponent(mainPanel);
        int speed = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (56 == speed) {
            this._modem.setSelected(true);
        } else if (350 == speed) {
            this._cable.setSelected(true);
        } else if (1000 == speed) {
            this._t1.setSelected(true);
        } else if (3000 == speed) {
            this._t3.setSelected(true);
        } else {
            this._cable.setSelected(true);
        }
    }

    public void applySettings(boolean loadCoreComponents) {
        int speed = this.getSpeed();
        this.setDownloadSlots(speed);
        if (speed < 0 || 20000 < speed) {
            throw new IllegalArgumentException();
        }
        ConnectionSettings.CONNECTION_SPEED.setValue(speed);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            boolean allow = this._startup.isSelected();
            if (OSUtils.isMacOSX()) {
                MacOSXUtils.setLoginStatus(allow);
            } else if (WindowsUtils.isLoginStatusAvailable()) {
                WindowsUtils.setLoginStatus(allow);
            }
            StartupSettings.RUN_ON_STARTUP.setValue(allow);
        }
        ChatSettings.CHAT_IRC_NICK.setValue(this._ircNickField.getText());
        ChatMediator.instance().reloadConfiguration();
    }

    private int getSpeed() {
        if (this._cable.isSelected()) {
            return 350;
        }
        if (this._t1.isSelected()) {
            return 1000;
        }
        if (this._t3.isSelected()) {
            return 3000;
        }
        return 56;
    }

    private void setDownloadSlots(int speed) {
        if (speed == 56) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        } else if (speed == 350) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(8);
        } else if (speed == 1000) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(12);
        } else if (speed == 3000) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(16);
        } else {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        }
    }
}

