/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FirewallUtils;
import com.limegroup.gnutella.gui.FramedDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.AssociationsWindow;
import com.limegroup.gnutella.gui.init.FileTypeWindow;
import com.limegroup.gnutella.gui.init.FirewallWindow;
import com.limegroup.gnutella.gui.init.IntentWindow;
import com.limegroup.gnutella.gui.init.LanguagePanel;
import com.limegroup.gnutella.gui.init.MiscWindow;
import com.limegroup.gnutella.gui.init.SaveWindow;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.SetupWindowHolder;
import com.limegroup.gnutella.gui.init.WelcomeWindow;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.InstallSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.FileSetting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class SetupManager {
    private FramedDialog dialogFrame;
    private SetupWindowHolder _setupWindowHolder;
    private SetupWindow _currentWindow;
    public static final int ACTION_PREVIOUS = 1;
    public static final int ACTION_NEXT = 2;
    public static final int ACTION_FINISH = 4;
    public static final int ACTION_CANCEL = 8;
    private PreviousAction previousAction = new PreviousAction();
    private NextAction nextAction = new NextAction();
    private FinishAction finishAction = new FinishAction();
    private CancelAction cancelAction = new CancelAction();
    private LanguageAwareAction[] actions = new LanguageAwareAction[]{this.previousAction, this.nextAction, this.finishAction, this.cancelAction};
    private List<SetupWindow> windows;

    public boolean shouldShowFirewallWindow() {
        if (InstallSettings.FIREWALL_WARNING.getValue()) {
            return false;
        }
        return OSUtils.isWindows() && !FirewallUtils.isStatuschangeCapable();
    }

    private boolean shouldShowAssociationsWindow() {
        if (InstallSettings.ASSOCIATION_OPTION.getValue() == 2) {
            return false;
        }
        return !GUIMediator.getAssociationManager().checkAndGrab(false);
    }

    private SaveStatus shouldShowSaveDirectoryWindow() {
        if (!InstallSettings.SAVE_DIRECTORY.getValue()) {
            return SaveStatus.NEEDS;
        }
        FileSetting saveSetting = SharingSettings.DIRECTORY_FOR_SAVING_FILES;
        if (saveSetting.isDefault()) {
            File oldDefaultDir = new File(CommonUtils.getUserHomeDir(), "Shared");
            if (!saveSetting.getValue().exists() && oldDefaultDir.exists()) {
                return SaveStatus.MIGRATE;
            }
        }
        return SaveStatus.NO;
    }

    public void createIfNeeded() {
        IntentWindow intentWindow;
        this._setupWindowHolder = new SetupWindowHolder();
        this.windows = new LinkedList<SetupWindow>();
        SaveStatus saveDirectoryStatus = this.shouldShowSaveDirectoryWindow();
        if (saveDirectoryStatus != SaveStatus.NO) {
            this.windows.add(new SaveWindow(this, saveDirectoryStatus == SaveStatus.MIGRATE));
        }
        if (!InstallSettings.SPEED.getValue() || !InstallSettings.START_STARTUP.getValue() && GUIUtils.shouldShowStartOnStartupWindow()) {
            this.windows.add(new MiscWindow(this));
        }
        if (this.shouldShowFirewallWindow()) {
            this.windows.add(new FirewallWindow(this));
        }
        if (this.shouldShowAssociationsWindow()) {
            this.windows.add(new AssociationsWindow(this));
        }
        if (!InstallSettings.EXTENSION_OPTION.getValue()) {
            this.windows.add(new FileTypeWindow(this));
        }
        if (!(intentWindow = new IntentWindow(this)).isConfirmedWillNot()) {
            this.windows.add(intentWindow);
        }
        if (this.windows.size() == 0) {
            return;
        }
        boolean partial = ApplicationSettings.INSTALLED.getValue();
        if (partial && (this.windows.size() != 1 || !(this.windows.get(0) instanceof IntentWindow))) {
            this.windows.add(0, new WelcomeWindow(this, partial));
        }
        SetupWindow prior = null;
        for (SetupWindow current : this.windows) {
            this._setupWindowHolder.add(current);
            if (prior == null) {
                current.setPrevious(current);
            } else {
                current.setPrevious(prior);
            }
            if (prior != null) {
                prior.setNext(current);
            }
            prior = current;
        }
        assert (prior != null);
        prior.setNext(prior);
        this.createDialog(this.windows.get(0));
    }

    private void createDialog(SetupWindow firstWindow) {
        this.dialogFrame = new FramedDialog();
        this.dialogFrame.setTitle("FrostWire Setup");
        this.dialogFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SetupManager.this.cancelSetup();
            }
        });
        JDialog dialog = this.dialogFrame.getDialog();
        dialog.setModal(true);
        dialog.setTitle(I18n.tr("FrostWire Setup Wizard"));
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SetupManager.this.cancelSetup();
            }
        });
        Container container = dialog.getContentPane();
        GUIUtils.addHideAction((JComponent)container);
        BoxLayout containerLayout = new BoxLayout(container, 1);
        container.setLayout(containerLayout);
        JPanel setupPanel = new JPanel();
        setupPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        BoxLayout layout = new BoxLayout(setupPanel, 1);
        setupPanel.setLayout(layout);
        Dimension d = new Dimension(700, 540);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - d.width) / 2, (screenSize.height - d.height) / 2);
        setupPanel.add(this._setupWindowHolder);
        setupPanel.add(Box.createVerticalStrut(17));
        JPanel bottomRow = new JPanel();
        bottomRow.setLayout(new BoxLayout(bottomRow, 0));
        ButtonRow buttons = new ButtonRow(this.actions, 0, 12);
        LanguagePanel languagePanel = new LanguagePanel(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupManager.this.updateLanguage();
            }
        });
        bottomRow.add(languagePanel);
        bottomRow.add(Box.createHorizontalGlue());
        bottomRow.add(buttons);
        bottomRow.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        setupPanel.add(new Line());
        setupPanel.add(bottomRow);
        this.show(firstWindow);
        container.add(setupPanel);
        ((JComponent)container).setPreferredSize(new Dimension(700, 540));
        dialog.pack();
        SplashWindow.instance().setVisible(false);
        this.dialogFrame.showDialog();
        SplashWindow.instance().setVisible(true);
    }

    public void enableActions(int actions) {
        this.previousAction.setEnabled((actions & 1) != 0);
        this.nextAction.setEnabled((actions & 2) != 0);
        this.finishAction.setEnabled((actions & 4) != 0);
        this.cancelAction.setEnabled((actions & 8) != 0);
    }

    public int getEnabledActions() {
        int actions = 0;
        if (this.previousAction.isEnabled()) {
            actions |= 1;
        }
        if (this.nextAction.isEnabled()) {
            actions |= 2;
        }
        if (this.finishAction.isEnabled()) {
            actions |= 4;
        }
        if (this.cancelAction.isEnabled()) {
            actions |= 8;
        }
        return actions;
    }

    public Component getOwnerComponent() {
        return this.dialogFrame;
    }

    public void next() {
        block2: {
            SetupWindow newWindow = this._currentWindow.getNext();
            try {
                this._currentWindow.applySettings(true);
                this.show(newWindow);
            }
            catch (ApplySettingsException ase) {
                if (ase.getMessage() == null || ase.getMessage().length() <= 0) break block2;
                GUIMediator.showError(ase.getMessage());
            }
        }
    }

    public void previous() {
        SetupWindow newWindow = this._currentWindow.getPrevious();
        try {
            this._currentWindow.applySettings(false);
            this.show(newWindow);
        }
        catch (ApplySettingsException applySettingsException) {
            // empty catch block
        }
    }

    public void cancelSetup() {
        this.dialogFrame.getDialog().dispose();
        System.exit(0);
    }

    public void finishSetup() {
        this.dialogFrame.getDialog().dispose();
        ApplicationSettings.INSTALLED.setValue(true);
        InstallSettings.SAVE_DIRECTORY.setValue(true);
        InstallSettings.SPEED.setValue(true);
        InstallSettings.SCAN_FILES.setValue(true);
        InstallSettings.LANGUAGE_CHOICE.setValue(true);
        InstallSettings.FILTER_OPTION.setValue(true);
        InstallSettings.EXTENSION_OPTION.setValue(true);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            InstallSettings.START_STARTUP.setValue(true);
        }
        if (OSUtils.isWindows()) {
            InstallSettings.FIREWALL_WARNING.setValue(true);
        }
        InstallSettings.ASSOCIATION_OPTION.setValue(2);
        Future<Void> future = BackgroundExecutorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                SettingsGroupManager.instance().save();
                return null;
            }
        });
        if (this._currentWindow instanceof IntentWindow) {
            IntentWindow intent = (IntentWindow)this._currentWindow;
            if (!intent.isConfirmedWillNot()) {
                GUIMediator.showWarning("FrostWire is not distributed to people who intend to use it for the purposes of copyright infringement.\n\nThank you for your interest; however, you cannot continue to use FrostWire at this time.");
                try {
                    future.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            }
            intent.applySettings(true);
        }
        this.dialogFrame.getDialog().dispose();
    }

    public void updateLanguage() {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].updateLanguage();
        }
        try {
            this._currentWindow.applySettings(false);
        }
        catch (ApplySettingsException applySettingsException) {
            // empty catch block
        }
        this._currentWindow.handleWindowOpeningEvent();
    }

    private void show(SetupWindow window) {
        window.handleWindowOpeningEvent();
        this._setupWindowHolder.show(window.getKey());
        this._currentWindow = window;
    }

    void add(SetupWindow window) {
        this._setupWindowHolder.add((Component)window, window.getKey());
    }

    private class FinishAction
    extends LanguageAwareAction {
        public FinishAction() {
            super(I18nMarker.marktr("Finish"));
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.finishSetup();
        }
    }

    private class PreviousAction
    extends LanguageAwareAction {
        public PreviousAction() {
            super(I18nMarker.marktr("<< Back"));
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.previous();
        }
    }

    private class NextAction
    extends LanguageAwareAction {
        public NextAction() {
            super(I18nMarker.marktr("Next >>"));
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.next();
        }
    }

    private class CancelAction
    extends LanguageAwareAction {
        public CancelAction() {
            super(I18nMarker.marktr("Cancel"));
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.cancelSetup();
        }
    }

    private abstract class LanguageAwareAction
    extends AbstractAction {
        private final String nameKey;

        public LanguageAwareAction(String nameKey) {
            super(I18n.tr(nameKey));
            this.nameKey = nameKey;
        }

        public void updateLanguage() {
            this.putValue("Name", I18n.tr(this.nameKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SaveStatus {
        NO,
        NEEDS,
        MIGRATE;

    }
}

