/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.limewire.util.VersionUtils;

final class LibraryTableCellEditor
implements TableCellEditor {
    private JTextField _textField;
    private LibraryTableMediator _libraryTable;
    private CellEditorListener _cellEditorListener;
    private int lastRow = -1;
    static final EventObject EVENT = new EventObject(new Object());

    LibraryTableCellEditor(LibraryTableMediator libraryTable) {
        this._libraryTable = libraryTable;
    }

    public Object getCellEditorValue() {
        String newName = this._textField.getText();
        return this._libraryTable.handleNameChange(newName);
    }

    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            LimeJTable table = (LimeJTable)this._libraryTable.getTable();
            if (VersionUtils.isJava16OrAbove()) {
                if (table.getSelectedRow() == this.lastRow) {
                    return me.getClickCount() < 2;
                }
                this.lastRow = table.getSelectedRow();
                return false;
            }
            return me.getClickCount() < 2;
        }
        return event == EVENT;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = listener;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = null;
    }

    void fireEditingStopped() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    void fireEditingCanceled() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        LimeTextField field = new LimeTextField();
        field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryTableCellEditor.this.fireEditingStopped();
            }
        });
        field.setText(value != null ? value.toString() : "");
        field.selectAll();
        field.setCaretPosition(0);
        field.requestFocus();
        this._textField = field;
        return field;
    }
}

