/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.LicenseWindow;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.actions.ActionUtils;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.library.LibraryTableTransferHandler;
import com.limegroup.gnutella.gui.library.RecursiveSharingDialog;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.gui.xml.editor.CCPublishWizard;
import com.limegroup.gnutella.gui.xml.editor.MetaEditor;
import com.limegroup.gnutella.gui.xml.editor.XmlTypeEditor;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Tuple;
import org.limewire.io.NetworkUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LibraryTableMediator
extends AbstractTableMediator<LibraryTableModel, LibraryTableDataLine, File>
implements VerificationListener,
FileDetailsProvider {
    private static final Log LOG = LogFactory.getLog(LibraryTableMediator.class);
    public static Action LAUNCH_ACTION;
    public static Action ENQUEUE_ACTION;
    public static Action DELETE_ACTION;
    public static Action ANNOTATE_ACTION;
    public static Action RESUME_ACTION;
    public static Action RENAME_ACTION;
    public static Action SHARE_ACTION;
    public static Action UNSHARE_ACTION;
    public static Action SHARE_FOLDER_ACTION;
    public static Action UNSHARE_FOLDER_ACTION;
    private Action PUBLISH_ACTION;
    private Action EDIT_LICENSE_ACTION;
    private Action VIEW_LICENSE_ACTION;
    private Action BITZI_LOOKUP_ACTION;
    private Action MAGNET_LOOKUP_ACTION;
    private Action COPY_MAGNET_TO_CLIPBOARD_ACTION;
    private boolean _isIncomplete;
    private boolean _annotateEnabled = false;
    private static LibraryTableMediator _instance;

    public static LibraryTableMediator instance() {
        return _instance;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_ACTION = new LaunchAction();
        ENQUEUE_ACTION = new EnqueueAction();
        DELETE_ACTION = new RemoveAction();
        ANNOTATE_ACTION = new AnnotateAction();
        RESUME_ACTION = new ResumeAction();
        RENAME_ACTION = new RenameAction();
        SHARE_ACTION = new ShareFileAction();
        UNSHARE_ACTION = new UnshareFileAction();
        this.PUBLISH_ACTION = new PublishAction();
        this.EDIT_LICENSE_ACTION = new EditLicenseAction();
        this.VIEW_LICENSE_ACTION = new ViewLicenseAction();
        this.BITZI_LOOKUP_ACTION = new BitziLookupAction(this);
        this.MAGNET_LOOKUP_ACTION = new MagnetLookupAction();
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION = new CopyMagnetLinkToClipboardAction(this);
        SHARE_FOLDER_ACTION = new ShareFolderAction();
        UNSHARE_FOLDER_ACTION = new UnshareFolderAction();
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = null;
        this.DATA_MODEL = new LibraryTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryTableModel)this.DATA_MODEL).setTable(this.TABLE);
        Action[] aa = new Action[]{LAUNCH_ACTION, ENQUEUE_ACTION, DELETE_ACTION, ANNOTATE_ACTION, this.PUBLISH_ACTION, RESUME_ACTION};
        this.BUTTON_ROW = new ButtonRow(aa, 0, 14);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(LAUNCH_ACTION));
        menu.add(new JMenuItem(ENQUEUE_ACTION));
        menu.addSeparator();
        menu.add(new JMenuItem(RESUME_ACTION));
        menu.addSeparator();
        menu.add(new JMenuItem(DELETE_ACTION));
        menu.add(new JMenuItem(RENAME_ACTION));
        menu.addSeparator();
        int[] rows = this.TABLE.getSelectedRows();
        boolean dirSelected = false;
        boolean fileSelected = false;
        boolean torrentSelected = false;
        for (int i = 0; i < rows.length; ++i) {
            File f = ((LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(rows[i])).getFile();
            if (f.isDirectory()) {
                dirSelected = true;
                if (IncompleteFileManager.isTorrentFolder(f)) {
                    torrentSelected = true;
                }
            } else {
                fileSelected = true;
            }
            if (dirSelected && fileSelected) break;
        }
        if (dirSelected) {
            if (GUIMediator.isPlaylistVisible()) {
                ENQUEUE_ACTION.setEnabled(false);
            }
            DELETE_ACTION.setEnabled(torrentSelected);
            RENAME_ACTION.setEnabled(false);
            if (fileSelected) {
                JMenu sharingMenu = new JMenu(I18n.tr("Sharing"));
                sharingMenu.add(new JMenuItem(SHARE_ACTION));
                sharingMenu.add(new JMenuItem(UNSHARE_ACTION));
                sharingMenu.add(new JMenuItem(ANNOTATE_ACTION));
                sharingMenu.addSeparator();
                sharingMenu.add(new JMenuItem(SHARE_FOLDER_ACTION));
                sharingMenu.add(new JMenuItem(UNSHARE_FOLDER_ACTION));
                menu.add(sharingMenu);
            } else {
                menu.add(new JMenuItem(SHARE_FOLDER_ACTION));
                menu.add(new JMenuItem(UNSHARE_FOLDER_ACTION));
            }
        } else {
            if (GUIMediator.isPlaylistVisible() && PlaylistMediator.isPlayableFile(((LibraryTableModel)this.DATA_MODEL).getFile(rows[0]))) {
                ENQUEUE_ACTION.setEnabled(true);
            }
            DELETE_ACTION.setEnabled(true);
            RENAME_ACTION.setEnabled(LibraryMediator.isRenameEnabled() && rows.length == 1);
            menu.add(new JMenuItem(SHARE_ACTION));
            menu.add(new JMenuItem(UNSHARE_ACTION));
            menu.add(new JMenuItem(ANNOTATE_ACTION));
        }
        menu.addSeparator();
        LibraryTableDataLine line = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(rows[0]);
        menu.add(this.createLicenseMenu(line));
        menu.add(this.createSearchSubMenu(line));
        menu.add(this.createAdvancedMenu(line));
        return menu;
    }

    private JMenu createLicenseMenu(LibraryTableDataLine dl) {
        JMenu menu = new JMenu(I18n.tr("License"));
        if (dl != null) {
            menu.add(new JMenuItem(this.PUBLISH_ACTION));
            menu.add(new JMenuItem(this.EDIT_LICENSE_ACTION));
            menu.add(new JMenuItem(this.VIEW_LICENSE_ACTION));
            menu.setEnabled(this.PUBLISH_ACTION.isEnabled() || this.EDIT_LICENSE_ACTION.isEnabled() || this.VIEW_LICENSE_ACTION.isEnabled());
        } else {
            menu.setEnabled(false);
        }
        return menu;
    }

    private JMenu createAdvancedMenu(LibraryTableDataLine dl) {
        JMenu menu = new JMenu(I18n.tr("Advanced"));
        if (dl != null) {
            menu.add(new JMenuItem(this.BITZI_LOOKUP_ACTION));
            menu.add(new JMenuItem(this.MAGNET_LOOKUP_ACTION));
            menu.add(new JMenuItem(this.COPY_MAGNET_TO_CLIPBOARD_ACTION));
            File file = this.getFile(this.TABLE.getSelectedRow());
            menu.setEnabled(GuiCoreMediator.getFileManager().isFileShared(file));
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    private JMenu createSearchSubMenu(LibraryTableDataLine dl) {
        JMenu menu = new JMenu(I18n.tr("Search"));
        if (dl != null) {
            LimeXMLDocument doc;
            File f = (File)dl.getInitializeObject();
            String keywords = QueryUtils.createQueryString(f.getName());
            if (keywords.length() > 2) {
                menu.add(new JMenuItem(new SearchAction(keywords)));
            }
            if ((doc = dl.getXMLDocument()) != null) {
                Action[] actions = ActionUtils.createSearchActions(doc);
                for (int i = 0; i < actions.length; ++i) {
                    menu.add(new JMenuItem(actions[i]));
                }
            }
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryTableMediator() {
        super("LIBRARY_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new LibraryTableTransferHandler());
    }

    @Override
    public JComponent getComponent() {
        return null;
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel model = this.TABLE.getColumnModel();
        TableColumn tc = model.getColumn(1);
        tc.setCellEditor(new LibraryTableCellEditor(this));
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener listener) {
        this.TABLE.addMouseListener(listener);
        this.TABLE.addMouseMotionListener(listener);
    }

    public void setAnnotateEnabled(boolean enabled) {
        this._annotateEnabled = enabled;
        LibraryTableDataLine.setXMLEnabled(enabled);
        ((LibraryTableModel)this.DATA_MODEL).refresh();
        this.handleSelection(-1);
    }

    void setIncompleteSelected(boolean enabled) {
        if (enabled == this._isIncomplete) {
            return;
        }
        this._isIncomplete = enabled;
        if (!enabled) {
            RESUME_ACTION.setEnabled(false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            RESUME_ACTION.setEnabled(true);
        }
    }

    void updateTableFiles(DirectoryHolder dirHolder) {
        if (dirHolder == null) {
            return;
        }
        this.clearTable();
        this.setIncompleteSelected(LibraryMediator.incompleteDirectoryIsSelected());
        File[] files = dirHolder.getFiles();
        FileManager manager = GuiCoreMediator.getFileManager();
        if (dirHolder.isStoreNode()) {
            for (int i = 0; i < files.length; ++i) {
                if (!manager.isStoreFile(files[i])) continue;
                this.addUnsorted(files[i]);
            }
        } else {
            for (int i = 0; i < files.length; ++i) {
                if (manager.isStoreFile(files[i])) continue;
                this.addUnsorted(files[i]);
            }
        }
        this.forceResort();
    }

    void handleFileManagerEvent(FileManagerEvent evt, DirectoryHolder holder) {
        if (evt == null || holder == null) {
            return;
        }
        File[] files = evt.getFiles();
        FileDesc[] fds = evt.getFileDescs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling event: " + evt);
        }
        switch (evt.getType()) {
            case REMOVE_STORE_FILE: 
            case REMOVE_FILE: {
                File f = fds[0].getFile();
                if (holder.accept(f)) {
                    ((LibraryTableModel)this.DATA_MODEL).reinitialize(f);
                    this.handleSelection(-1);
                    break;
                }
                if (!((LibraryTableModel)this.DATA_MODEL).contains(f)) break;
                ((LibraryTableModel)this.DATA_MODEL).remove(f);
                this.handleSelection(-1);
                break;
            }
            case ADD_STORE_FILE: 
            case ADD_FILE: {
                if (!holder.accept(fds[0].getFile())) break;
                this.add(fds[0].getFile());
                this.handleSelection(-1);
                break;
            }
            case CHANGE_FILE: {
                File changed = fds[0].getFile();
                ((LibraryTableModel)this.DATA_MODEL).reinitialize(changed);
                this.handleSelection(-1);
                break;
            }
            case RENAME_FILE: {
                File old = fds[0].getFile();
                File now = fds[1].getFile();
                if (holder.accept(now)) {
                    if (((LibraryTableModel)this.DATA_MODEL).contains(old)) {
                        ((LibraryTableModel)this.DATA_MODEL).reinitialize(old, now);
                        this.handleSelection(-1);
                        break;
                    }
                    ((LibraryTableModel)this.DATA_MODEL).add(now);
                    break;
                }
                ((LibraryTableModel)this.DATA_MODEL).remove(old);
                break;
            }
            case ADD_STORE_FOLDER: 
            case ADD_FOLDER: {
                if (!holder.accept(files[0])) break;
                this.add(files[0]);
                this.handleSelection(-1);
                break;
            }
            case REMOVE_STORE_FOLDER: 
            case REMOVE_FOLDER: {
                File f = files[0];
                if (holder.accept(f)) {
                    ((LibraryTableModel)this.DATA_MODEL).reinitialize(f);
                    this.handleSelection(-1);
                    break;
                }
                if (!((LibraryTableModel)this.DATA_MODEL).contains(f)) break;
                ((LibraryTableModel)this.DATA_MODEL).remove(f);
                this.handleSelection(-1);
            }
        }
    }

    File getFile(int row) {
        return ((LibraryTableModel)this.DATA_MODEL).getFile(row);
    }

    private FileDesc getFileDesc(int row) {
        return ((LibraryTableModel)this.DATA_MODEL).getFileDesc(row);
    }

    @Override
    public FileDetails[] getFileDetails() {
        int[] sel = this.TABLE.getSelectedRows();
        ArrayList<FileDetails> files = new ArrayList<FileDetails>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            FileDesc desc = this.getFileDesc(sel[i]);
            if (desc == null) continue;
            files.add(GuiCoreMediator.getLocalFileDetailsFactory().create(desc));
        }
        if (files.isEmpty()) {
            return new FileDetails[0];
        }
        return files.toArray(new FileDetails[0]);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    LibraryTableDataLine[] getSelectedLibraryLines() {
        int[] selected = this.TABLE.getSelectedRows();
        LibraryTableDataLine[] lines = new LibraryTableDataLine[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            lines[i] = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(selected[i]);
        }
        return lines;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    private boolean isSupportedFormat(FileDesc[] fds) {
        boolean audio = false;
        boolean video = false;
        boolean program = false;
        boolean document = false;
        boolean image = false;
        for (int i = 0; i < fds.length; ++i) {
            String name = fds[i].getFileName();
            if (!(!MediaType.getAudioMediaType().matches(name) || video || program || document || image)) {
                audio = true;
                continue;
            }
            if (!(!MediaType.getVideoMediaType().matches(name) || audio || program || document || image)) {
                video = true;
                continue;
            }
            if (!(!MediaType.getProgramMediaType().matches(name) || audio || video || document || image)) {
                program = true;
                continue;
            }
            if (!(!MediaType.getDocumentMediaType().matches(name) || audio || video || program || image)) {
                document = true;
                continue;
            }
            if (!(!MediaType.getImageMediaType().matches(name) || audio || video || program || document)) {
                image = true;
                continue;
            }
            return false;
        }
        return true;
    }

    void editMeta(boolean publish) {
        int[] rows = this.TABLE.getSelectedRows();
        ArrayList<FileDesc> fileDescs = new ArrayList<FileDesc>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            if (fd == null) continue;
            fileDescs.add(fd);
        }
        if (fileDescs.isEmpty()) {
            return;
        }
        FileDesc[] fds = fileDescs.toArray(new FileDesc[0]);
        String name = fds[0].getFile().getName();
        JFrame mainFrame = GUIMediator.getAppFrame();
        if (this.isSupportedFormat(fds)) {
            try {
                if (publish) {
                    FileDesc fd = fds[0];
                    LimeXMLDocument doc = fd.getXMLDocument("http://www.limewire.com/schemas/audio.xsd");
                    LimeXMLSchemaRepository rep = GuiCoreMediator.getLimeXMLSchemaRepository();
                    LimeXMLSchema schema = rep.getSchema("http://www.limewire.com/schemas/audio.xsd");
                    if (schema == null) {
                        throw new IllegalStateException("no audio schema!");
                    }
                    CCPublishWizard wizard = new CCPublishWizard(fd, doc, schema);
                    wizard.showDialog(mainFrame);
                } else {
                    MetaEditor metaEditor = new MetaEditor((Frame)mainFrame, fds, name);
                    metaEditor.setLocationRelativeTo(mainFrame);
                    metaEditor.setVisible(true);
                }
                return;
            }
            catch (IllegalStateException failed) {
                if (publish) {
                    GUIMediator.showError(I18n.tr("FrostWire cannot publish this file because it was unable to find a schema for audio files."));
                    return;
                }
            }
        } else {
            XmlTypeEditor metaEditor = new XmlTypeEditor((Frame)mainFrame, fds, name);
            metaEditor.setLocationRelativeTo(mainFrame);
            metaEditor.setVisible(true);
        }
    }

    void startRename() {
        int row = this.TABLE.getSelectedRow();
        if (row == -1) {
            return;
        }
        int viewIdx = this.TABLE.convertColumnIndexToView(1);
        this.TABLE.editCellAt(row, viewIdx, LibraryTableCellEditor.EVENT);
    }

    void showLicenseWindow() {
        LibraryTableDataLine ldl = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (ldl == null) {
            return;
        }
        FileDesc fd = ldl.getFileDesc();
        License license = fd.getLicense();
        URN urn = fd.getSHA1Urn();
        LimeXMLDocument doc = ldl.getXMLDocument();
        LicenseWindow window = LicenseWindow.create(license, urn, doc, this);
        GUIUtils.centerOnScreen(window);
        window.setVisible(true);
    }

    @Override
    public void licenseVerified(License license) {
        ((LibraryTableModel)this.DATA_MODEL).refresh();
    }

    void doMagnetLookup() {
        this.doMagnetCommand("/magcmd/detail?");
    }

    void doMagnetCommand(String cmd) {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        boolean haveValidMagnet = false;
        int count = 0;
        int port = GuiCoreMediator.getLocalAcceptor().getPort();
        int eport = GuiCoreMediator.getAcceptor().getPort(true);
        byte[] eaddr = GuiCoreMediator.getAcceptor().getAddress(true);
        String lookupUrl = "http://localhost:" + port + cmd + "addr=" + NetworkUtils.ip2string(eaddr) + ":" + eport;
        for (int i = 0; i < k; ++i) {
            URN urn;
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            if (fd == null || (urn = fd.getSHA1Urn()) == null) continue;
            String urnStr = urn.toString();
            int hashstart = 1 + urnStr.indexOf(":", 4);
            String sha1 = urnStr.substring(hashstart);
            lookupUrl = lookupUrl + "&n" + count + "=" + EncodingUtils.encode(fd.getFileName()) + "&u" + count + "=" + sha1;
            ++count;
            haveValidMagnet = true;
        }
        if (haveValidMagnet) {
            GUIMediator.openURL(lookupUrl);
        }
    }

    private static Object[] createRemoveOptions() {
        if (OSUtils.supportsTrash()) {
            String trashLabel = OSUtils.isWindows() ? I18n.tr("Move to Recycle Bin") : I18n.tr("Move to Trash");
            return new Object[]{trashLabel, I18n.tr("Delete"), I18n.tr("Cancel")};
        }
        return new Object[]{I18n.tr("Delete"), I18n.tr("Cancel")};
    }

    @Override
    public void removeSelection() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        ArrayList<Tuple<File, FileDesc>> files = new ArrayList<Tuple<File, FileDesc>>(rows.length);
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            File file = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            files.add(new Tuple<File, FileDesc>(file, fd));
        }
        CheckBoxListPanel<Tuple<File, FileDesc>> listPanel = new CheckBoxListPanel<Tuple<File, FileDesc>>(files, new TupleTextProvider(), true);
        listPanel.getList().setVisibleRowCount(4);
        Object[] message = new Object[]{new MultiLineLabel(I18n.tr("Are you sure you want to delete the selected file(s), thus removing it from your computer?"), 400), Box.createVerticalStrut(6), listPanel, Box.createVerticalStrut(6)};
        Object[] removeOptions = LibraryTableMediator.createRemoveOptions();
        int option = JOptionPane.showOptionDialog(MessageService.getParentComponent(), message, I18n.tr("Message"), 0, 3, null, removeOptions, removeOptions[0]);
        if (option == removeOptions.length - 1 || option == -1) {
            return;
        }
        List<Tuple<File, FileDesc>> selected = listPanel.getSelectedElements();
        ArrayList<String> undeletedFileNames = new ArrayList<String>();
        FileManager fileManager = GuiCoreMediator.getFileManager();
        IncompleteFileManager incompleteManager = GuiCoreMediator.getDownloadManager().getIncompleteFileManager();
        for (Tuple<File, FileDesc> tuple : selected) {
            File file = tuple.getFirst();
            FileDesc fd = tuple.getSecond();
            if (this._isIncomplete && this.hasActiveDownloader(file)) {
                undeletedFileNames.add(this.getCompleteFileName(file));
                continue;
            }
            if (fd instanceof IncompleteFileDesc || fd == null) {
                incompleteManager.removeEntry(file);
            } else {
                fileManager.removeFileIfShared(file);
            }
            if (fd != null) {
                GuiCoreMediator.getUploadManager().killUploadsForFileDesc(fd);
            }
            GuiCoreMediator.getTorrentManager().killTorrentForFile(file);
            boolean removed = FileUtils.delete(file, removeOptions.length > 2 && option == 0);
            if (removed) {
                ((LibraryTableModel)this.DATA_MODEL).remove(((LibraryTableModel)this.DATA_MODEL).getRow(file));
                continue;
            }
            undeletedFileNames.add(this.getCompleteFileName(file));
        }
        this.clearSelection();
        if (undeletedFileNames.isEmpty()) {
            return;
        }
        message = new Object[]{new MultiLineLabel(I18n.tr("The following files could not be deleted. They may be in use by another application or are currently being downloaded to."), 400), Box.createVerticalStrut(6), new JScrollPane(LibraryTableMediator.createFileList(undeletedFileNames))};
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), message, I18n.tr("Error"), 0);
    }

    private static JList createFileList(List<String> fileNames) {
        JList<Object> fileList = new JList<Object>(fileNames.toArray());
        fileList.setVisibleRowCount(5);
        fileList.setCellRenderer(new FileNameListCellRenderer());
        fileList.setSelectionForeground(fileList.getForeground());
        fileList.setSelectionBackground(fileList.getBackground());
        fileList.setFocusable(false);
        return fileList;
    }

    private String getCompleteFileName(File file) {
        if (this._isIncomplete) {
            try {
                return IncompleteFileManager.getCompletedName(file);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return file.getName();
    }

    private boolean hasActiveDownloader(File incompleteFile) {
        return GuiCoreMediator.getDownloadManager().getDownloaderForIncompleteFile(incompleteFile) != null;
    }

    String handleNameChange(String newName) {
        int row = this.TABLE.getEditingRow();
        LibraryTableModel ltm = (LibraryTableModel)this.DATA_MODEL;
        File oldFile = ltm.getFile(row);
        String parent = oldFile.getParent();
        String nameWithExtension = newName + "." + ltm.getType(row);
        File newFile = new File(parent, nameWithExtension);
        if (!ltm.getName(row).equals(newName)) {
            if (oldFile.renameTo(newFile)) {
                GuiCoreMediator.getFileManager().renameFileIfSharedOrStore(oldFile, newFile);
                ((LibraryTableModel)this.DATA_MODEL).reinitialize(oldFile);
                return newName;
            }
            GUIMediator.showError(I18n.tr("Unable to rename the file '{0}'. It may be in use by another application.", ltm.getName(row)));
            return ltm.getName(row);
        }
        return newName;
    }

    @Override
    public void handleActionKey() {
        int[] rows = this.TABLE.getSelectedRows();
        LibraryTableModel ltm = (LibraryTableModel)this.DATA_MODEL;
        for (int i = 0; i < rows.length; ++i) {
            File file = ltm.getFile(rows[i]);
            if (!file.isDirectory() || !LibraryMediator.setSelectedDirectory(file)) continue;
            return;
        }
        this.launch();
    }

    void resumeIncomplete() {
        int i;
        int[] rows = this.TABLE.getSelectedRows();
        boolean startedDownload = false;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (i = 0; i < rows.length; ++i) {
            File incomplete = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            try {
                GuiCoreMediator.getDownloadServices().download(incomplete);
                startedDownload = true;
                continue;
            }
            catch (SaveLocationException e) {
                errors.add(e);
                continue;
            }
            catch (CantResumeException e) {
                errors.add(e);
            }
        }
        for (i = 0; i < errors.size(); ++i) {
            Exception e = (Exception)errors.get(i);
            if (e instanceof SaveLocationException) {
                SaveLocationException sle = (SaveLocationException)e;
                if (sle.getErrorCode() == 10) {
                    GUIMediator.showError(I18n.tr("You are already downloading this file to \"{0}\".", sle.getFile()), QuestionsHandler.ALREADY_DOWNLOADING);
                    continue;
                }
                String msg = CoreExceptionHandler.getSaveLocationErrorString(sle);
                GUIMediator.showError(msg);
                continue;
            }
            if (!(e instanceof CantResumeException)) continue;
            GUIMediator.showError(I18n.tr("The file \"{0}\" is not a valid incomplete file and cannot be resumed.", ((CantResumeException)e).getFilename()), QuestionsHandler.CANT_RESUME);
        }
        if (startedDownload) {
            this.switchToDownloadTab();
        }
    }

    private void switchToDownloadTab() {
        GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
    }

    void launch() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        GUILauncher.LaunchableProvider[] providers = new GUILauncher.LaunchableProvider[rows.length];
        if (this._isIncomplete) {
            for (int i = 0; i < rows.length; ++i) {
                providers[i] = new IncompleteProvider(((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]));
            }
        } else {
            for (int i = 0; i < rows.length; ++i) {
                providers[i] = new CompleteProvider(((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]));
            }
        }
        GUILauncher.launch(providers);
    }

    @Override
    public void handleSelection(int row) {
        int[] sel = this.TABLE.getSelectedRows();
        if (sel.length == 0) {
            this.handleNoSelection();
            return;
        }
        LibraryTableDataLine selectedLine = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(sel[0]);
        File selectedFile = this.getFile(sel[0]);
        boolean firstShared = GuiCoreMediator.getFileManager().isFileShared(selectedFile);
        boolean isStore = GuiCoreMediator.getFileManager().isStoreFile(selectedFile);
        LAUNCH_ACTION.setEnabled(true);
        DELETE_ACTION.setEnabled(true);
        if (GUIMediator.isPlaylistVisible()) {
            boolean found = false;
            for (int i = 0; i < sel.length; ++i) {
                if (!PlaylistMediator.isPlayableFile(((LibraryTableModel)this.DATA_MODEL).getFile(sel[i]))) continue;
                found = true;
                break;
            }
            ENQUEUE_ACTION.setEnabled(found);
        } else {
            ENQUEUE_ACTION.setEnabled(false);
        }
        if (!this._isIncomplete && this._annotateEnabled) {
            ANNOTATE_ACTION.setEnabled(firstShared || isStore);
            boolean canPublish = sel.length == 1 && firstShared && LimeXMLUtils.isFilePublishable(selectedFile.getName());
            this.PUBLISH_ACTION.setEnabled(canPublish && !selectedLine.isLicensed());
            this.EDIT_LICENSE_ACTION.setEnabled(canPublish && selectedLine.isLicensed());
        } else {
            ANNOTATE_ACTION.setEnabled(false);
            this.PUBLISH_ACTION.setEnabled(false);
            this.EDIT_LICENSE_ACTION.setEnabled(false);
        }
        ANNOTATE_ACTION.setEnabled(sel.length == 1);
        this.VIEW_LICENSE_ACTION.setEnabled(sel.length == 1 && selectedLine.isLicensed());
        RESUME_ACTION.setEnabled(this._isIncomplete);
        RENAME_ACTION.setEnabled(LibraryMediator.isRenameEnabled() && sel.length == 1);
        boolean shareAllowed = false;
        boolean unshareAllowed = false;
        boolean shareFolderAllowed = false;
        boolean unshareFolderAllowed = false;
        boolean foundDir = false;
        for (int i = 0; i < sel.length; ++i) {
            File file = this.getFile(sel[i]);
            if (file.isDirectory()) {
                ANNOTATE_ACTION.setEnabled(false);
                boolean isTorrent = false;
                if (this._isIncomplete && (isTorrent = IncompleteFileManager.isTorrentFolder(file))) {
                    LAUNCH_ACTION.setEnabled(false);
                }
                if (!foundDir && !isTorrent) {
                    DELETE_ACTION.setEnabled(false);
                    foundDir = true;
                }
                if (!GuiCoreMediator.getFileManager().isFolderShared(file)) {
                    shareFolderAllowed = true;
                    continue;
                }
                unshareFolderAllowed = true;
                continue;
            }
            if (!GuiCoreMediator.getFileManager().isFileShared(file)) {
                if (!SharingUtils.isFilePhysicallyShareable(file) || this._isIncomplete) continue;
                shareAllowed = true;
            } else {
                unshareAllowed = true;
            }
            if (shareAllowed && unshareAllowed && shareFolderAllowed && unshareFolderAllowed) break;
        }
        SHARE_ACTION.setEnabled(shareAllowed && !isStore);
        UNSHARE_ACTION.setEnabled(unshareAllowed && !isStore);
        SHARE_FOLDER_ACTION.setEnabled(shareFolderAllowed && !isStore);
        UNSHARE_FOLDER_ACTION.setEnabled(unshareFolderAllowed);
        this.MAGNET_LOOKUP_ACTION.setEnabled(firstShared && !isStore);
        this.BITZI_LOOKUP_ACTION.setEnabled(firstShared && !isStore);
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION.setEnabled(!this._isIncomplete && this.getFileDesc(sel[0]) != null && !isStore);
    }

    @Override
    public void handleNoSelection() {
        LAUNCH_ACTION.setEnabled(false);
        ENQUEUE_ACTION.setEnabled(false);
        DELETE_ACTION.setEnabled(false);
        ANNOTATE_ACTION.setEnabled(false);
        RESUME_ACTION.setEnabled(false);
        RENAME_ACTION.setEnabled(false);
        SHARE_ACTION.setEnabled(false);
        UNSHARE_ACTION.setEnabled(false);
        SHARE_FOLDER_ACTION.setEnabled(false);
        UNSHARE_FOLDER_ACTION.setEnabled(false);
        this.PUBLISH_ACTION.setEnabled(false);
        this.EDIT_LICENSE_ACTION.setEnabled(false);
        this.VIEW_LICENSE_ACTION.setEnabled(false);
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION.setEnabled(false);
        this.MAGNET_LOOKUP_ACTION.setEnabled(false);
        this.BITZI_LOOKUP_ACTION.setEnabled(false);
    }

    public void setPlayerEnabled(boolean value) {
        this.handleSelection(this.TABLE.getSelectedRow());
    }

    public boolean setFileSelected(File file) {
        int i = ((LibraryTableModel)this.DATA_MODEL).getRow(file);
        if (i != -1) {
            this.TABLE.setSelectedRow(i);
            this.TABLE.ensureSelectionVisible();
            return true;
        }
        return false;
    }

    static {
        _instance = new LibraryTableMediator();
    }

    private static class CompleteProvider
    extends IncompleteProvider {
        public CompleteProvider(File file) {
            super(file);
        }

        public Downloader getDownloader() {
            return null;
        }
    }

    private static class IncompleteProvider
    implements GUILauncher.LaunchableProvider {
        private final File incompleteFile;

        public IncompleteProvider(File incompleteFile) {
            this.incompleteFile = incompleteFile;
        }

        public Downloader getDownloader() {
            return GuiCoreMediator.getDownloadManager().getDownloaderForIncompleteFile(this.incompleteFile);
        }

        public File getFile() {
            return this.incompleteFile;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TupleTextProvider
    implements CheckBoxList.TextProvider<Tuple<File, FileDesc>> {
        private TupleTextProvider() {
        }

        @Override
        public Icon getIcon(Tuple<File, FileDesc> obj) {
            String extension = FileUtils.getFileExtension(obj.getFirst());
            if (extension != null) {
                return IconManager.instance().getIconForExtension(extension);
            }
            return null;
        }

        @Override
        public String getText(Tuple<File, FileDesc> obj) {
            return LibraryTableMediator.this.getCompleteFileName(obj.getFirst());
        }

        @Override
        public String getToolTipText(Tuple<File, FileDesc> obj) {
            return obj.getFirst().getAbsolutePath();
        }
    }

    private static class FileNameListCellRenderer
    extends DefaultListCellRenderer {
        private FileNameListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String extension = FileUtils.getFileExtension(value.toString());
            if (extension != null) {
                this.setIcon(IconManager.instance().getIconForExtension(extension));
            }
            return this;
        }
    }

    private class ViewLicenseAction
    extends AbstractAction {
        public ViewLicenseAction() {
            this.putValue("Name", I18n.tr("View License"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.showLicenseWindow();
        }
    }

    private final class MagnetLookupAction
    extends AbstractAction {
        public MagnetLookupAction() {
            this.putValue("Name", I18n.tr("Show Magnet Details"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.doMagnetLookup();
        }
    }

    private class UnshareFolderAction
    extends AbstractAction {
        public UnshareFolderAction() {
            this.putValue("Name", I18n.tr("Stop Sharing Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            final File[] files = new File[sel.length];
            for (int i = sel.length - 1; i >= 0; --i) {
                files[i] = LibraryTableMediator.this.getFile(sel[i]);
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file == null || !file.isDirectory()) continue;
                        GuiCoreMediator.getFileManager().removeFolderIfShared(file);
                    }
                }
            });
        }
    }

    private class ShareFolderAction
    extends AbstractAction {
        public ShareFolderAction() {
            this.putValue("Name", I18n.tr("Share Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            ArrayList<File> files = new ArrayList<File>(sel.length);
            for (int i = 0; i < sel.length; ++i) {
                File file = LibraryTableMediator.this.getFile(sel[i]);
                if (file == null || !file.isDirectory()) continue;
                files.add(file);
            }
            final RecursiveSharingDialog dialog = new RecursiveSharingDialog((Frame)GUIMediator.getAppFrame(), files.toArray(new File[0]));
            if (dialog.showChooseDialog(MessageService.getParentComponent()) == RecursiveSharingDialog.State.OK) {
                BackgroundExecutorService.schedule(new Runnable(){

                    public void run() {
                        GuiCoreMediator.getFileManager().addSharedFolders(dialog.getRootsToShare(), dialog.getFoldersToExclude());
                    }
                });
            }
        }
    }

    private class UnshareFileAction
    extends AbstractAction {
        public UnshareFileAction() {
            this.putValue("Name", I18n.tr("Stop Sharing File"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            final File[] files = new File[sel.length];
            for (int i = sel.length - 1; i >= 0; --i) {
                files[i] = LibraryTableMediator.this.getFile(sel[i]);
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file == null || file.isDirectory()) continue;
                        GuiCoreMediator.getFileManager().stopSharingFile(file);
                    }
                }
            });
        }
    }

    private class ShareFileAction
    extends AbstractAction {
        public ShareFileAction() {
            this.putValue("Name", I18n.tr("Share File"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            final File[] files = new File[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                files[i] = LibraryTableMediator.this.getFile(sel[i]);
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file == null || file.isDirectory()) continue;
                        GuiCoreMediator.getFileManager().addFileAlways(file);
                    }
                }
            });
        }
    }

    private final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("Name", I18n.tr("Rename"));
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.startRename();
        }
    }

    private final class ResumeAction
    extends AbstractAction {
        public ResumeAction() {
            this.putValue("Name", I18n.tr("Resume"));
            this.putValue("ShortDescription", I18n.tr("Continue Downloading Selected Incomplete File"));
            this.putValue("LimeIconName", "LIBRARY_RESUME");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.resumeIncomplete();
        }
    }

    private final class EditLicenseAction
    extends AbstractAction {
        public EditLicenseAction() {
            this.putValue("Name", I18n.tr("Edit License..."));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.editMeta(true);
        }
    }

    private final class PublishAction
    extends AbstractAction {
        public PublishAction() {
            this.putValue("Name", I18n.tr("Publish..."));
            this.putValue("ShortDescription", I18n.tr("Publish under Creative Commons License"));
            this.putValue("LimeIconName", "LIBRARY_PUBLISH");
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.editMeta(true);
        }
    }

    private final class AnnotateAction
    extends AbstractAction {
        public AnnotateAction() {
            this.putValue("Name", I18n.tr("Describe..."));
            this.putValue("ShortDescription", I18n.tr("Add Description to Selected File"));
            this.putValue("LimeIconName", "LIBRARY_ANNOTATE");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.editMeta(false);
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.REMOVE_LISTENER.actionPerformed(ae);
        }
    }

    private final class EnqueueAction
    extends AbstractAction {
        public EnqueueAction() {
            this.putValue("Name", I18n.tr("Enqueue"));
            this.putValue("ShortDescription", I18n.tr("Add Selected Files to the Playlist"));
            this.putValue("LimeIconName", "LIBRARY_TO_PLAYLIST");
        }

        public void actionPerformed(ActionEvent ae) {
            int[] rows = LibraryTableMediator.this.TABLE.getSelectedRows();
            ArrayList<File> files = new ArrayList<File>();
            for (int i = 0; i < rows.length; ++i) {
                int index = rows[i];
                File file = ((LibraryTableModel)LibraryTableMediator.this.DATA_MODEL).getFile(index);
                if (!GUIMediator.isPlaylistVisible() || !PlaylistMediator.isPlayableFile(file)) continue;
                files.add(file);
            }
            LibraryMediator.instance().addFilesToPlayList(files);
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        public LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.launch();
        }
    }
}

