/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.HashBasedDataLineModel;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.io.File;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LibraryTableModel
extends HashBasedDataLineModel<LibraryTableDataLine, File> {
    private JTable _table;

    LibraryTableModel() {
        super(LibraryTableDataLine.class);
    }

    @Override
    public LibraryTableDataLine createDataLine() {
        return new LibraryTableDataLine(this);
    }

    void setTable(JTable table) {
        this._table = table;
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    @Override
    public int add(File o) {
        return this.add(o, this.getRowCount());
    }

    @Override
    public int add(LibraryTableDataLine dl, int row) {
        File init = (File)dl.getInitializeObject();
        if (!this.contains(init)) {
            return this.forceAdd(dl, row);
        }
        FileDesc fd = dl.getFileDesc();
        if (fd != null) {
            row = this.getRow(init);
            ((LibraryTableDataLine)this.get(row)).setFileDesc(fd);
            this.fireTableRowsUpdated(row, row);
        }
        dl.cleanup();
        return -1;
    }

    void reinitialize(File f) {
        if (this.contains(f)) {
            int row = this.getRow(f);
            ((LibraryTableDataLine)this.get(row)).initialize(f);
            this.fireTableRowsUpdated(row, row);
        }
    }

    void reinitialize(File old, File now) {
        if (this.contains(old)) {
            int row = this.getRow(old);
            ((LibraryTableDataLine)this.get(row)).initialize(now);
            this.initializeObjectChanged(old, now);
            this.fireTableRowsUpdated(row, row);
        }
    }

    String getType(int row) {
        return (String)((ColoredCellImpl)((LibraryTableDataLine)this.get(row)).getValueAt(3)).getValue();
    }

    File getFile(int row) {
        return (File)((LibraryTableDataLine)this.get(row)).getInitializeObject();
    }

    String getName(int row) {
        return (String)((ColoredCellImpl)((LibraryTableDataLine)this.get(row)).getValueAt(1)).getValue();
    }

    long getSize(int row) {
        return ((SizeHolder)((ColoredCellImpl)((LibraryTableDataLine)this.get(row)).getValueAt(2)).getValue()).getSize();
    }

    FileDesc getFileDesc(int row) {
        return ((LibraryTableDataLine)this.get(row)).getFileDesc();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int max;
        if (!LibraryMediator.isRenameEnabled()) {
            return false;
        }
        if (this.getFile(row).isDirectory()) {
            return false;
        }
        ListSelectionModel selModel = this._table.getSelectionModel();
        int min = selModel.getMinSelectionIndex();
        return min == (max = selModel.getMaxSelectionIndex()) && col == 1 && this._table.getSelectedRow() == row;
    }
}

