/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.dnd.CompositeTransferable;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTableTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JComponent;

public class LibraryTableTransferHandler
extends LimeTransferHandler {
    public LibraryTableTransferHandler() {
        super(3);
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (DNDUtils.containsLibraryFlavors(transferFlavors)) {
            return false;
        }
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.canImport(comp, transferFlavors);
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors, DropInfo info) {
        return this.canImport(comp, transferFlavors);
    }

    public boolean importData(JComponent comp, Transferable t) {
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.importData(comp, t);
    }

    public boolean importData(JComponent comp, Transferable t, DropInfo info) {
        return this.importData(comp, t);
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        File[] files;
        if (action != 2) {
            return;
        }
        if (!DNDUtils.containsFileFlavors(data.getTransferDataFlavors())) {
            return;
        }
        try {
            files = DNDUtils.getFiles(data);
        }
        catch (UnsupportedFlavorException ufe) {
            return;
        }
        catch (IOException ioe) {
            return;
        }
        boolean reloaded = false;
        FileManager fileManager = GuiCoreMediator.getFileManager();
        for (File f : files) {
            FileDesc fileDesc;
            if (f.exists() || (fileDesc = fileManager.removeFileIfShared(f)) != null) continue;
            reloaded = true;
            fileManager.loadSettings();
            break;
        }
        if (!reloaded) {
            LibraryMediator.instance().forceRefresh();
        }
        GUIMediator.instance().refreshGUI();
    }

    protected Transferable createTransferable(JComponent c) {
        LibraryTableDataLine[] lines = LibraryTableMediator.instance().getSelectedLibraryLines();
        if (lines.length == 0) {
            return null;
        }
        LibraryTableTransferable lineTransferable = new LibraryTableTransferable(lines);
        FileTransferable fileTransferable = new FileTransferable(FileTransferable.EMPTY_FILE_LIST, Arrays.asList(lines));
        return new CompositeTransferable(lineTransferable, fileTransferable);
    }
}

