/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.ShareFileSpeciallyAction;
import com.limegroup.gnutella.gui.actions.ShareNewFolderAction;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibrarySearchResultsHolder;
import com.limegroup.gnutella.gui.library.LibraryTreeTransferHandler;
import com.limegroup.gnutella.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SharedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SpeciallySharedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.TorrentMetaFileDirectoryHolder;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.MouseObserver;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.limewire.setting.FileSetting;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

final class LibraryTree
extends JTree
implements MouseObserver {
    private final LibraryTreeNode ROOT_NODE = new LibraryTreeNode(new RootNodeDirectoryHolder(""));
    private RootSharedFilesDirectoryHolder rsfdh = new RootSharedFilesDirectoryHolder();
    private final DefaultTreeModel TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
    private LibraryTreeNode savedFilesNode;
    private final SavedFilesDirectoryHolder sfdh = new SavedFilesDirectoryHolder(SharingSettings.DIRECTORY_FOR_SAVING_FILES, I18n.tr("Saved Files"));
    private LibraryTreeNode sharedFilesNode;
    private LibraryTreeNode incompleteFilesNode;
    private final IncompleteDirectoryHolder idh = new IncompleteDirectoryHolder();
    private LibraryTreeNode speciallySharedFilesNode;
    private final SpeciallySharedFilesDirectoryHolder ssfdh = new SpeciallySharedFilesDirectoryHolder();
    private LibraryTreeNode searchResultsNode;
    private final LibrarySearchResultsHolder lsrdh = new LibrarySearchResultsHolder();
    private LibraryTreeNode torrentsMetaFilesNode;
    private final TorrentMetaFileDirectoryHolder tmfh = new TorrentMetaFileDirectoryHolder();
    private static final LibraryTree INSTANCE = new LibraryTree();
    private final JPopupMenu DIRECTORY_POPUP = new JPopupMenu();
    private Action shareAction = new ShareAction();
    private Action unshareAction = new UnshareAction();
    private Action addDirToPlaylistAction = new AddDirectoryToPlaylistAction();
    private Action refreshAction = new RefreshAction();
    private Action exploreAction = new ExploreAction();
    private Action showTorrentMetaAction = new ShowHideTorrentMetaAction();
    private ButtonRow BUTTON_ROW;

    public static LibraryTree instance() {
        return INSTANCE;
    }

    private LibraryTree() {
        this.setModel(this.TREE_MODEL);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(false);
        this.setInvokesStopCellEditing(true);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setCellRenderer(new LibraryTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.makePopupMenu();
        this.makeButtonRow();
        this.addMouseListener(new DefaultMouseListener(this));
        this.sharedFilesNode = new LibraryTreeNode(this.rsfdh);
        this.addNode(this.ROOT_NODE, this.sharedFilesNode);
        this.speciallySharedFilesNode = new LibraryTreeNode(this.ssfdh);
        this.savedFilesNode = new LibraryTreeNode(this.sfdh);
        this.addNode(this.ROOT_NODE, this.savedFilesNode);
        this.addPerMediaTypeDirectories();
        this.incompleteFilesNode = new LibraryTreeNode(this.idh);
        this.addNode(this.ROOT_NODE, this.incompleteFilesNode);
        this.searchResultsNode = new LibraryTreeNode(this.lsrdh);
        this.addNode(this.ROOT_NODE, this.searchResultsNode);
        this.torrentsMetaFilesNode = new LibraryTreeNode(this.tmfh);
        if (SharingSettings.SHOW_TORRENT_META_FILES.getValue()) {
            this.addNode(this.sharedFilesNode, this.torrentsMetaFilesNode);
        }
        this.updateTheme();
        this.setDragEnabled(true);
        this.setTransferHandler(new MulticastTransferHandler(new LibraryTreeTransferHandler(), DNDUtils.DEFAULT_TRANSFER_HANDLERS));
        this.addTreeSelectionListener(new LibraryTreeSelectionListener());
    }

    private void addNode(LibraryTreeNode parent, LibraryTreeNode child, boolean expand) {
        int insert;
        if (parent.getIndex(child) != -1) {
            if (expand) {
                this.expandPath(new TreePath(parent.getPath()));
            }
            return;
        }
        int children = parent.getChildCount();
        if (!(child.getDirectoryHolder() instanceof SharedFilesDirectoryHolder)) {
            insert = children;
            if (insert != 0 && child == this.speciallySharedFilesNode && parent.getChildAt(children - 1) == this.torrentsMetaFilesNode) {
                --insert;
            }
        } else {
            for (insert = 0; insert < children; ++insert) {
                LibraryTreeNode current = (LibraryTreeNode)parent.getChildAt(insert);
                File f = current.getFile();
                if (current == this.torrentsMetaFilesNode || f == null || StringUtils.compareFullPrimary(f.getName(), child.getFile().getName()) >= 0) break;
            }
        }
        this.TREE_MODEL.insertNodeInto(child, parent, insert);
        if (expand || parent == this.sharedFilesNode && !this.isExpanded(new TreePath(this.sharedFilesNode.getPath()))) {
            this.expandPath(new TreePath(parent.getPath()));
        }
    }

    private void addNode(LibraryTreeNode parent, LibraryTreeNode child) {
        this.addNode(parent, child, false);
    }

    private void removeNode(LibraryTreeNode parent, LibraryTreeNode child) {
        if (parent == null || child == null) {
            return;
        }
        if (parent.getIndex(child) == -1) {
            return;
        }
        this.TREE_MODEL.removeNodeFromParent(child);
    }

    private void addPerMediaTypeDirectories() {
        for (NamedMediaType nm : NamedMediaType.getAllNamedMediaTypes()) {
            if (nm.getMediaType().getMimeType().equals("*")) continue;
            FileSetting fs = SharingSettings.getFileSettingForMediaType(nm.getMediaType());
            MediaTypeSavedFilesDirectoryHolder dh = new MediaTypeSavedFilesDirectoryHolder(fs, nm.getName(), nm.getMediaType());
            LibraryTreeNode node = new LibraryTreeNode(dh);
            this.addNode(this.savedFilesNode, node, true);
        }
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.setBackground(tableColor);
        this.setCellRenderer(new LibraryTreeCellRenderer());
    }

    public void setInitialSelection() {
        TreePath tp = new TreePath(this.sharedFilesNode.getPath());
        this.setSelectionPath(tp);
    }

    private void addDirectoryToNode(File dir, LibraryTreeNode node, boolean isStoreNode) {
        SharedFilesDirectoryHolder dh = new SharedFilesDirectoryHolder(dir, isStoreNode);
        LibraryTreeNode current = new LibraryTreeNode(dh);
        int children = node.getChildCount();
        for (int i = children - 1; i >= 0; --i) {
            LibraryTreeNode child = (LibraryTreeNode)node.getChildAt(i);
            File f = child.getFile();
            if (f == null || !dir.equals(f.getParentFile())) continue;
            this.TREE_MODEL.removeNodeFromParent(child);
            this.addNode(current, child);
        }
        File parent = dir.getParentFile();
        LibraryTreeNode parentNode = null;
        if (parent != null) {
            parentNode = this.getNodeForFolder(parent, node);
        }
        if (parentNode == null) {
            parentNode = node;
        }
        this.addNode(parentNode, current);
    }

    public void handleFileManagerEvent(FileManagerEvent evt) {
        switch (evt.getType()) {
            case ADD_FILE: {
                if (!this.ssfdh.accept(evt.getFileDescs()[0].getFile())) break;
                this.addNode(this.sharedFilesNode, this.speciallySharedFilesNode, true);
                break;
            }
            case REMOVE_FILE: {
                if (!this.ssfdh.isEmpty()) break;
                if (this.ssfdh == this.getSelectedDirectoryHolder()) {
                    this.setSelectionPath(new TreePath(this.savedFilesNode.getPath()));
                }
                this.removeNode(this.sharedFilesNode, this.speciallySharedFilesNode);
                break;
            }
            case ADD_FOLDER: {
                File[] files = evt.getFiles();
                this.addDirectoryToNode(files[0], this.sharedFilesNode, false);
                break;
            }
            case REMOVE_FOLDER: {
                File removed = evt.getFiles()[0];
                this.removeFolder(removed, this.sharedFilesNode);
            }
        }
    }

    void removeFolder(File folder, LibraryTreeNode treeNode) {
        LibraryTreeNode node = this.getNodeForFolder(folder, treeNode);
        if (node == null) {
            return;
        }
        if (this.getSelectedNode() == node) {
            this.setSelectionPath(new TreePath(treeNode.getPath()));
        }
        int childCount = node.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            LibraryTreeNode child = (LibraryTreeNode)node.getChildAt(i);
            this.TREE_MODEL.removeNodeFromParent(child);
            this.addNode(treeNode, child);
        }
        this.TREE_MODEL.removeNodeFromParent(node);
    }

    LibraryTreeNode getNodeForFolder(File folder, LibraryTreeNode parent) {
        int children = parent.getChildCount();
        for (int i = children - 1; i >= 0; --i) {
            LibraryTreeNode child = (LibraryTreeNode)parent.getChildAt(i);
            File childFile = child.getFile();
            if (childFile == null) continue;
            if (childFile.equals(folder)) {
                return child;
            }
            if (!child.isAncestorOf(folder)) continue;
            return this.getNodeForFolder(folder, child);
        }
        return null;
    }

    void addPlayListEntries() {
        if (this.incompleteDirectoryIsSelected() || !GUIMediator.isPlaylistVisible()) {
            return;
        }
        DirectoryHolder dh = this.getSelectedDirectoryHolder();
        if (dh == null) {
            return;
        }
        if (PlaylistMediator.getInstance() == null) {
            return;
        }
        PlaylistMediator pm = GUIMediator.getPlayList();
        if (pm == null) {
            return;
        }
        pm.addFilesToPlaylist(dh.getFiles());
    }

    private boolean canBeUnshared(LibraryTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node == this.speciallySharedFilesNode) {
            return false;
        }
        if (node == this.incompleteFilesNode) {
            return false;
        }
        if (node == this.sharedFilesNode) {
            return false;
        }
        if (node == this.torrentsMetaFilesNode) {
            return false;
        }
        if (node.getParent() == null) {
            return false;
        }
        if (node.getParent() == this.sharedFilesNode) {
            return true;
        }
        return this.canBeUnshared((LibraryTreeNode)node.getParent());
    }

    private boolean canBeShared(LibraryTreeNode node) {
        if (node == null || node == this.incompleteFilesNode || node == this.torrentsMetaFilesNode) {
            return false;
        }
        File dir = node.getDirectoryHolder().getDirectory();
        return dir != null && !GuiCoreMediator.getFileManager().isFolderShared(dir) && !GuiCoreMediator.getFileManager().isStoreDirectory(dir);
    }

    public DirectoryHolder getSelectedDirectoryHolder() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            return ((LibraryTreeNode)path.getLastPathComponent()).getDirectoryHolder();
        }
        return null;
    }

    public DirectoryHolder getHolderForPoint(Point p) {
        LibraryTreeNode node;
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path != null && (node = (LibraryTreeNode)path.getLastPathComponent()) != null) {
            return node.getDirectoryHolder();
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point mousePoint) {
        TreePath path = this.getPathForLocation(mousePoint.x, mousePoint.y);
        LibraryTreeNode node = (LibraryTreeNode)path.getLastPathComponent();
        return node == this.incompleteFilesNode;
    }

    File getSelectedDirectory() {
        LibraryTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getDirectoryHolder().getDirectory();
    }

    LibraryTreeNode getSelectedNode() {
        return (LibraryTreeNode)this.getLastSelectedPathComponent();
    }

    File[] getSharedDirectories() {
        int length = this.sharedFilesNode.getChildCount();
        ArrayList<File> newFiles = new ArrayList<File>(length);
        for (int i = 0; i < length - 1; ++i) {
            LibraryTreeNode node = (LibraryTreeNode)this.sharedFilesNode.getChildAt(i);
            if (node == this.speciallySharedFilesNode || node == this.torrentsMetaFilesNode) continue;
            newFiles.add(node.getDirectoryHolder().getDirectory());
        }
        return newFiles.toArray(new File[0]);
    }

    void clear() {
        boolean selected = false;
        int count = this.sharedFilesNode.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            TreeNode node = this.sharedFilesNode.getChildAt(i);
            if (node == this.getSelectedNode()) {
                selected = true;
            }
            if (node == this.torrentsMetaFilesNode) continue;
            this.sharedFilesNode.remove(i);
        }
        if (selected) {
            this.setSelectionPath(new TreePath(this.sharedFilesNode));
        }
        selected = false;
        this.TREE_MODEL.reload();
    }

    void unshareLibraryFolder() {
        LibraryTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage();
        } else if (!this.canBeUnshared(node)) {
            GUIMediator.showMessage(I18n.tr("FrostWire cannot stop sharing this folder."));
        } else {
            String msg = I18n.tr("Are you sure you want to stop sharing this folder?");
            DialogOption response = GUIMediator.showYesNoMessage(msg, QuestionsHandler.UNSHARE_DIRECTORY, DialogOption.YES);
            if (response != DialogOption.YES) {
                return;
            }
            final File file = node.getFile();
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    GuiCoreMediator.getFileManager().removeFolderIfShared(file);
                }
            });
        }
    }

    boolean incompleteDirectoryIsSelected() {
        LibraryTreeNode selected = this.getSelectedNode();
        return this.incompleteFilesNode == selected;
    }

    boolean searchResultDirectoryIsSelected() {
        LibraryTreeNode selected = this.getSelectedNode();
        return selected == this.searchResultsNode;
    }

    boolean savedDirectoryIsSelected() {
        return this.isSavedDirectory(this.getSelectedNode());
    }

    boolean sharedFoldersNodeIsSelected() {
        return this.getSelectedNode() == this.sharedFilesNode;
    }

    private boolean isSavedDirectory(LibraryTreeNode node) {
        return node == this.savedFilesNode || node != null && node.getParent() == this.savedFilesNode;
    }

    private void showIncompleteFolderMessage() {
        GUIMediator.showError(I18n.tr("FrostWire will not allow you delete to the folder reserved for incomplete files."));
    }

    private boolean isEnqueueable() {
        File[] files;
        LibraryTreeNode node = this.getSelectedNode();
        boolean enqueueable = false;
        if (node != null && node != this.incompleteFilesNode && node != this.sharedFilesNode && (files = node.getDirectoryHolder().getFiles()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (!GUIMediator.isPlaylistVisible() || !PlaylistMediator.isPlayableFile(files[i])) continue;
                enqueueable = true;
            }
        }
        return enqueueable;
    }

    public void setPlayerEnabled(boolean value) {
        this.addDirToPlaylistAction.setEnabled(this.isEnqueueable());
    }

    private void makePopupMenu() {
        this.DIRECTORY_POPUP.add(new JMenuItem(this.shareAction));
        this.DIRECTORY_POPUP.add(new JMenuItem(this.unshareAction));
        this.DIRECTORY_POPUP.add(new JMenuItem(this.addDirToPlaylistAction));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(new ShareFileSpeciallyAction()));
        this.DIRECTORY_POPUP.add(new JMenuItem(new ShareNewFolderAction()));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(this.showTorrentMetaAction));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(this.refreshAction));
        if (this.hasExploreAction()) {
            this.DIRECTORY_POPUP.add(new JMenuItem(this.exploreAction));
        }
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", I18n.tr("Configure Sharing Options"), I18n.tr("You can configure the folders you share in FrostWire's Options."))));
    }

    private boolean hasExploreAction() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    private void makeButtonRow() {
        this.BUTTON_ROW = this.hasExploreAction() ? new ButtonRow(new Action[]{this.refreshAction, this.exploreAction}, 0, 14) : new ButtonRow(new Action[]{this.refreshAction}, 0, 14);
    }

    public Component getButtonRow() {
        return this.BUTTON_ROW;
    }

    public void handleMouseDoubleClick(MouseEvent e) {
    }

    public void handleRightMouseClick(MouseEvent e) {
    }

    public void handlePopupMenu(MouseEvent e) {
        int row = this.getRowForLocation(e.getX(), e.getY());
        if (row == -1) {
            return;
        }
        this.setSelectionRow(row);
        this.DIRECTORY_POPUP.show(this, e.getX(), e.getY());
    }

    public boolean setSelectedDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        LibraryTreeNode ltn = this.getNodeForFolder(dir, this.sharedFilesNode);
        if (ltn == null) {
            return false;
        }
        this.setSelectionPath(new TreePath(ltn.getPath()));
        return true;
    }

    void setSearchResultsNodeSelected() {
        this.clearSelection();
        TreePath path = new TreePath(new Object[]{this.ROOT_NODE, this.searchResultsNode});
        this.scrollPathToVisible(path);
        this.setSelectionPath(path);
    }

    LibrarySearchResultsHolder getSearchResultsHolder() {
        return this.lsrdh;
    }

    private class ExploreAction
    extends AbstractAction {
        public ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Library Folder"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        public void actionPerformed(ActionEvent e) {
            File exploreDir = LibraryTree.this.getSelectedDirectory();
            if (exploreDir == null) {
                return;
            }
            GUIMediator.launchExplorer(exploreDir);
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            this.putValue("Name", I18n.tr("Refresh"));
            this.putValue("ShortDescription", I18n.tr("Reload Shared Folders"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        public void actionPerformed(ActionEvent e) {
            GuiCoreMediator.getFileManager().loadSettings();
        }
    }

    private class ShowHideTorrentMetaAction
    extends AbstractAction {
        private String hideMetaFilesLabel = I18n.tr("Hide .torrent Files");
        private String showMetaFilesLabel = I18n.tr("Show .torrent Files");

        public ShowHideTorrentMetaAction() {
            if (SharingSettings.SHOW_TORRENT_META_FILES.getValue()) {
                this.putValue("Name", this.hideMetaFilesLabel);
            } else {
                this.putValue("Name", this.showMetaFilesLabel);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (!LibraryTree.this.sharedFilesNode.isNodeChild(LibraryTree.this.torrentsMetaFilesNode)) {
                LibraryTree.this.addNode(LibraryTree.this.sharedFilesNode, LibraryTree.this.torrentsMetaFilesNode);
                this.putValue("Name", this.hideMetaFilesLabel);
                SharingSettings.SHOW_TORRENT_META_FILES.setValue(true);
            } else {
                LibraryTree.this.removeNode(LibraryTree.this.sharedFilesNode, LibraryTree.this.torrentsMetaFilesNode);
                this.putValue("Name", this.showMetaFilesLabel);
                SharingSettings.SHOW_TORRENT_META_FILES.setValue(false);
            }
        }
    }

    private class ShareAction
    extends AbstractAction {
        public ShareAction() {
            this.putValue("Name", I18n.tr("Share Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryMediator.instance().addSharedLibraryFolder(LibraryTree.this.getSelectedDirectory());
        }
    }

    private class LibraryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public LibraryTreeCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focused) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focused);
            LibraryTreeNode node = (LibraryTreeNode)value;
            DirectoryHolder dh = node.getDirectoryHolder();
            this.setText(dh.getName());
            this.setToolTipText(dh.getDescription());
            Icon icon = dh.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    private class AddDirectoryToPlaylistAction
    extends AbstractAction {
        public AddDirectoryToPlaylistAction() {
            this.putValue("Name", I18n.tr("Add Folder Contents to Playlist"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTree.this.addPlayListEntries();
        }
    }

    private class LWSDirectoryHolder
    extends RootNodeDirectoryHolder {
        public LWSDirectoryHolder() {
            super(I18n.tr("Store"));
        }

        public Icon getIcon() {
            return GUIMediator.getThemeImage("lws_small");
        }
    }

    private class UnshareAction
    extends AbstractAction {
        public UnshareAction() {
            this.putValue("Name", I18n.tr("Stop Sharing Folder"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTree.this.unshareLibraryFolder();
        }
    }

    private class RootSharedFilesDirectoryHolder
    extends RootNodeDirectoryHolder {
        public RootSharedFilesDirectoryHolder() {
            super(I18n.tr("Shared Files"));
        }

        public boolean accept(File file) {
            return GuiCoreMediator.getFileManager().isFileInCompletelySharedDirectory(file);
        }

        public Icon getIcon() {
            return GUIMediator.getThemeImage("shared_folder");
        }
    }

    private class RootNodeDirectoryHolder
    implements DirectoryHolder {
        private String name;

        public RootNodeDirectoryHolder(String s) {
            this.name = s;
        }

        public File getDirectory() {
            return null;
        }

        public String getDescription() {
            return "";
        }

        public File[] getFiles() {
            return new File[0];
        }

        public FileDesc[] getFileDescs() {
            return new FileDesc[0];
        }

        public String getName() {
            return this.name;
        }

        public boolean accept(File pathname) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean isStoreNode() {
            return false;
        }
    }

    public final class LibraryTreeNode
    extends DefaultMutableTreeNode
    implements FileTransfer {
        private DirectoryHolder _holder;

        private LibraryTreeNode(DirectoryHolder holder) {
            super(holder);
            this._holder = holder;
        }

        public DirectoryHolder getDirectoryHolder() {
            return this._holder;
        }

        public File getFile() {
            return this._holder.getDirectory();
        }

        public boolean isAncestorOf(File folder) {
            File f = this.getFile();
            return f != null && folder.getPath().startsWith(f.getPath());
        }

        public boolean isParentOf(File folder) {
            return folder.getParentFile().equals(this.getFile());
        }

        public String toString() {
            return this.getClass().getName() + ", file: " + this.getFile();
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            LibraryTreeNode node = LibraryTree.this.getSelectedNode();
            LibraryTree.this.unshareAction.setEnabled(LibraryTree.this.canBeUnshared(node));
            LibraryTree.this.shareAction.setEnabled(LibraryTree.this.canBeShared(node));
            LibraryTree.this.addDirToPlaylistAction.setEnabled(LibraryTree.this.isEnqueueable());
            if (node == null) {
                return;
            }
            if (node == LibraryTree.this.sharedFilesNode) {
                LibraryMediator.showSharedFiles();
            } else {
                LibraryMediator.updateTableFiles(node.getDirectoryHolder());
            }
        }
    }
}

