/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.trees.FileTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveSharingPanel
extends JPanel {
    private final FileTreeModel directoryTreeModel;
    private final JTree directoryTree;
    private final Set<File> deselected;
    private final Set<File> roots;
    private final JPanel legendPanel;
    private final JPanel mainPanel;
    private final FileTreeCellRenderer fileTreeCellRenderer = new FileTreeCellRenderer();
    private final Icon partiallySharedIcon = RecursiveSharingPanel.createPartiallySharedIcon();

    private static Set<File> emptyFileSet() {
        return Collections.emptySet();
    }

    private static Icon createPartiallySharedIcon() {
        if (ThemeSettings.isNativeOSXTheme()) {
            return GUIMediator.getThemeImage("sharing_checkbox_aqua");
        }
        Icon icon = UIManager.getIcon("CheckBox.icon");
        if (icon == null || icon.getIconWidth() == 0 || icon.getIconHeight() == 0) {
            icon = MetalIconFactory.getCheckBoxIcon();
        }
        return RecursiveSharingPanel.createDisabledIcon(RecursiveSharingPanel.configureCheckBox(new JCheckBox()), icon);
    }

    public RecursiveSharingPanel(File ... roots) {
        this(RecursiveSharingPanel.emptyFileSet(), roots);
    }

    public RecursiveSharingPanel(Set<File> blackListSet, File ... roots) {
        super(new BorderLayout());
        this.roots = new TreeSet<File>(FileTreeModel.DEFAULT_COMPARATOR);
        this.deselected = new HashSet<File>(blackListSet);
        this.directoryTreeModel = new FileTreeModel("", new File[0]);
        this.directoryTreeModel.setFileFilter(new SharedFolderFilter());
        this.directoryTree = new RootNotEditableTree(this.directoryTreeModel);
        this.directoryTree.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.directoryTree.setCellRenderer(this.fileTreeCellRenderer);
        this.directoryTree.setCellEditor(new FileTreeCellEditor());
        this.directoryTree.setEditable(true);
        this.directoryTree.setVisibleRowCount(8);
        JScrollPane jspDirectories = new JScrollPane(this.directoryTree);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)jspDirectories, "Center");
        this.legendPanel = new JPanel();
        this.mainPanel.add((Component)this.legendPanel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.setRoots(roots);
        this.updateLanguage();
    }

    public void updateLanguage() {
        this.createLegendPanel(this.legendPanel);
        this.directoryTreeModel.changeRootText(I18n.tr("Shared Folders"));
    }

    public void setFileFilter(FileFilter filter) {
        this.directoryTreeModel.setFileFilter(filter);
    }

    public void addEastPanel(JComponent comp) {
        this.mainPanel.add((Component)comp, "East");
    }

    public void setRoots(File ... newRoots) {
        this.roots.clear();
        this.directoryTree.cancelEditing();
        this.directoryTreeModel.removeSubRoots();
        this.roots.addAll(RecursiveSharingPanel.retainAncestors(newRoots));
        for (File root : this.roots) {
            this.directoryTreeModel.addSubRoot(root);
        }
        this.setRootExpanded();
    }

    public boolean isRoot(File dir) {
        return this.roots.contains(dir);
    }

    public void setFoldersToExclude(Set<File> blackListSet) {
        this.deselected.clear();
        this.deselected.addAll(blackListSet);
    }

    public void addFoldersToExclude(Set<File> blackListSet) {
        this.deselected.addAll(blackListSet);
    }

    public void setRootsExpanded() {
        for (File root : this.roots) {
            this.setExpanded(root);
        }
    }

    public void setRootExpanded() {
        this.directoryTree.expandPath(new TreePath(this.directoryTreeModel.getRoot()));
    }

    public boolean addRoot(File dir) {
        boolean changed = this.deselected.remove(dir);
        for (File root : this.roots) {
            if (FileUtils.isAncestor(root, dir)) {
                if (root.equals(dir)) {
                    if (changed) {
                        this.directoryTreeModel.valueForPathChanged(this.getTreePath(dir), null);
                    }
                    return changed;
                }
                this.removeFromPath(dir);
                TreePath path = this.getTreePath(dir);
                this.directoryTree.scrollPathToVisible(path);
                return changed;
            }
            if (!FileUtils.isAncestor(dir, root)) continue;
            this.removeRoot(root);
            this.addDirToTree(dir);
            this.setExpanded(root);
            this.setExpanded(root.getParentFile());
            return true;
        }
        this.addDirToTree(dir);
        this.setRootExpanded();
        return true;
    }

    private void addDirToTree(File dir) {
        this.roots.add(dir);
        this.directoryTreeModel.addSubRoot(dir);
    }

    public void removeRoot(File root) {
        if (this.roots.remove(root)) {
            this.directoryTree.cancelEditing();
            this.directoryTreeModel.removeSubRoot(root);
            this.removeFromPath(root);
        }
    }

    static Set<File> retainAncestors(File ... roots) {
        if (roots == null) {
            return new HashSet<File>();
        }
        for (int i = 0; i < roots.length; ++i) {
            for (int j = i + 1; j < roots.length && roots[i] != null; ++j) {
                if (roots[j] == null) continue;
                if (FileUtils.isAncestor(roots[i], roots[j])) {
                    roots[j] = null;
                    continue;
                }
                if (!FileUtils.isAncestor(roots[j], roots[i])) continue;
                roots[i] = null;
            }
        }
        HashSet<File> retained = new HashSet<File>(roots.length);
        for (File file : roots) {
            if (file == null) continue;
            retained.add(file);
        }
        return retained;
    }

    private JPanel createLegendPanel(JPanel basePanel) {
        JPanel panel;
        if (basePanel != null) {
            basePanel.removeAll();
            basePanel.setLayout(new GridBagLayout());
            panel = basePanel;
        } else {
            panel = new JPanel(new GridBagLayout());
        }
        panel.setBorder(BorderFactory.createTitledBorder(I18n.tr("Legend")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 0, 6);
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(true);
        panel.add((Component)this.createIconLabel(checkBox), gbc);
        MultiLineLabel label = new MultiLineLabel(I18n.tr("Folder is fully shared including all subfolders."), true);
        GridBagConstraints labelGbc = new GridBagConstraints();
        labelGbc.anchor = 17;
        labelGbc.fill = 2;
        labelGbc.gridwidth = 0;
        labelGbc.gridx = 1;
        labelGbc.weightx = 1.0;
        panel.add((Component)label, labelGbc);
        checkBox.setSelected(false);
        gbc.gridy = 1;
        panel.add((Component)this.createIconLabel(checkBox), gbc);
        label = new MultiLineLabel(I18n.tr("Folder is not shared and no subfolders are shared."), true);
        labelGbc.gridy = 1;
        panel.add((Component)label, labelGbc);
        checkBox.setIcon(this.partiallySharedIcon);
        gbc.gridy = 2;
        panel.add((Component)this.createIconLabel(checkBox), gbc);
        label = new MultiLineLabel(I18n.tr("Folder's files and some subfolders are shared."), true);
        labelGbc.gridy = 2;
        panel.add((Component)label, labelGbc);
        return panel;
    }

    private JLabel createIconLabel(JCheckBox checkBox) {
        checkBox.setOpaque(false);
        checkBox.setSize(checkBox.getMinimumSize());
        BufferedImage image = new BufferedImage(checkBox.getWidth(), checkBox.getHeight(), 3);
        Graphics g = ((Image)image).getGraphics();
        checkBox.paint(g);
        g.dispose();
        return new JLabel(new ImageIcon(image));
    }

    public Set<File> getRootsToShare() {
        HashSet<File> ret = new HashSet<File>(this.roots);
        ret.removeAll(this.deselected);
        return ret;
    }

    public Set<File> getFoldersToExclude() {
        HashSet<File> result = new HashSet<File>(this.deselected);
        result.removeAll(this.roots);
        return result;
    }

    private TreePath getTreePath(File dir) {
        LinkedList<File> files = new LinkedList<File>();
        files.add(dir);
        for (File parent = dir.getParentFile(); parent != null && !this.directoryTreeModel.isSubRoot(dir); parent = parent.getParentFile()) {
            files.addFirst(parent);
            dir = parent;
        }
        Object[] path = new Object[files.size() + 1];
        path[0] = this.directoryTreeModel.getRoot();
        System.arraycopy(files.toArray(), 0, path, 1, path.length - 1);
        return new TreePath(path);
    }

    public JTree getTree() {
        return this.directoryTree;
    }

    public void setExpanded(File dir) {
        this.directoryTree.expandPath(this.getTreePath(dir));
    }

    private static JCheckBox configureCheckBox(JCheckBox checkBox) {
        checkBox.setHorizontalAlignment(2);
        checkBox.setFont(UIManager.getFont("Tree.font"));
        checkBox.setBorderPainted(false);
        checkBox.setFocusPainted(false);
        checkBox.setFocusable(false);
        checkBox.setOpaque(true);
        return checkBox;
    }

    private boolean isSharedOrParentIsShared(File dir) {
        while (dir != null) {
            if (this.deselected.contains(dir)) {
                return false;
            }
            dir = dir.getParentFile();
        }
        return true;
    }

    private boolean isExcluded(File dir) {
        for (File file : this.deselected) {
            if (!FileUtils.isAncestor(file, dir)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullyShared(File dir) {
        for (File offspring : this.deselected) {
            if (!FileUtils.isAncestor(dir, offspring)) continue;
            return false;
        }
        return true;
    }

    private static Icon createDisabledIcon(JCheckBox checkBox, Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 1);
        Graphics g = ((Image)image).getGraphics();
        checkBox.setSelected(true);
        icon.paintIcon(checkBox, g, 0, 0);
        g.dispose();
        return UIManager.getLookAndFeel().getDisabledIcon(checkBox, new ImageIcon(image));
    }

    private String getText(File file) {
        return this.directoryTreeModel.isSubRoot(file) ? file.getAbsolutePath() : file.getName();
    }

    private void removeFromPath(File file) {
        Iterator<File> i = this.deselected.iterator();
        while (i.hasNext()) {
            File f = i.next();
            if (!FileUtils.isAncestor(file, f)) continue;
            i.remove();
        }
        while (file != null && !this.roots.contains(file)) {
            File parent = file.getParentFile();
            if (this.ancestorIsExcluded(parent)) {
                this.deselected.remove(parent);
                int childCount = this.directoryTreeModel.getChildCount(parent);
                for (int j = 0; j < childCount; ++j) {
                    File sibling = (File)this.directoryTreeModel.getChild(parent, j);
                    if (sibling == null || sibling.equals(file)) continue;
                    this.deselected.add(sibling);
                }
            }
            file = parent;
        }
    }

    private boolean ancestorIsExcluded(File file) {
        while (file != null) {
            if (this.deselected.contains(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private void setColors(JCheckBox checkBox, boolean isSelected) {
        checkBox.setForeground(isSelected ? this.fileTreeCellRenderer.getTextSelectionColor() : this.fileTreeCellRenderer.getTextNonSelectionColor());
        checkBox.setBackground(isSelected ? this.fileTreeCellRenderer.getBackgroundSelectionColor() : this.fileTreeCellRenderer.getBackgroundNonSelectionColor());
    }

    private static class SharedFolderFilter
    implements FileFilter {
        private final FileManager manager = GuiCoreMediator.getFileManager();

        private SharedFolderFilter() {
        }

        public boolean accept(File pathname) {
            return this.manager.isFolderShareable(pathname, true);
        }
    }

    private static class RootNotEditableTree
    extends JTree {
        public RootNotEditableTree(TreeModel newModel) {
            super(newModel);
        }

        public boolean isPathEditable(TreePath path) {
            return path.getPathCount() != 1;
        }
    }

    private class FileTreeCellEditor
    extends DefaultCellEditor {
        public FileTreeCellEditor() {
            super(RecursiveSharingPanel.configureCheckBox(new JCheckBox()));
            RecursiveSharingPanel.this.setColors((JCheckBox)this.editorComponent, true);
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private static final long serialVersionUID = -7007164079287676831L;

                public void setValue(Object value) {
                    File file = (File)value;
                    ((JCheckBox)FileTreeCellEditor.this.editorComponent).setSelected(RecursiveSharingPanel.this.isSharedOrParentIsShared(file));
                    ((JCheckBox)FileTreeCellEditor.this.editorComponent).setText(RecursiveSharingPanel.this.getText(file));
                    this.value = value;
                }

                public Object getCellEditorValue() {
                    File file = (File)this.value;
                    if (((JCheckBox)FileTreeCellEditor.this.editorComponent).isSelected()) {
                        RecursiveSharingPanel.this.removeFromPath(file);
                    } else {
                        RecursiveSharingPanel.this.deselected.add(file);
                    }
                    return this.value;
                }
            };
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.delegate.setValue(value);
            return this.editorComponent;
        }
    }

    private class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -8299879264709364378L;
        private JCheckBox checkBox = RecursiveSharingPanel.access$200(new JCheckBox());
        private DefaultTreeCellRenderer labelRenderer = new DefaultTreeCellRenderer();

        private FileTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!(value instanceof File)) {
                this.labelRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, false);
                this.labelRenderer.setIcon(null);
                return this.labelRenderer;
            }
            File file = (File)value;
            this.checkBox.setText(RecursiveSharingPanel.this.getText(file));
            RecursiveSharingPanel.this.setColors(this.checkBox, sel);
            if (RecursiveSharingPanel.this.isExcluded(file)) {
                this.checkBox.setSelected(false);
                this.checkBox.setIcon(null);
            } else if (RecursiveSharingPanel.this.isFullyShared(file)) {
                this.checkBox.setSelected(true);
                this.checkBox.setIcon(null);
            } else {
                this.checkBox.setSelected(true);
                this.checkBox.setIcon(RecursiveSharingPanel.this.partiallySharedIcon);
            }
            return this.checkBox;
        }
    }
}

