/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.ToggleSettingAction;
import com.limegroup.gnutella.gui.menu.Menu;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.FontUIResource;
import org.limewire.util.OSUtils;

abstract class AbstractMenu
implements Menu {
    static final Font FONT = new FontUIResource(new Font("Dialog", 0, 11 + ThemeSettings.FONT_SIZE_INCREMENT.getValue()));
    protected final JMenu MENU;

    protected AbstractMenu(String name) {
        this.MENU = new JMenu(new MenuAction(name));
        this.MENU.setFont(FONT);
    }

    public JMenu getMenu() {
        return this.MENU;
    }

    protected JMenuItem addMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        item.setFont(FONT);
        this.MENU.add(item);
        return item;
    }

    protected JMenuItem addToggleMenuItem(Action action, boolean selected) {
        JMenuItem item = OSUtils.isMacOSX() ? new JRadioButtonMenuItem(action) : new JCheckBoxMenuItem(action);
        item.setFont(FONT);
        item.setSelected(selected);
        this.MENU.add(item);
        return item;
    }

    protected JMenuItem addToggleMenuItem(ToggleSettingAction action) {
        JMenuItem item = this.addToggleMenuItem(action, action.getSetting().getValue());
        return item;
    }

    protected void addSeparator() {
        this.MENU.addSeparator();
    }

    private static class MenuAction
    extends AbstractAction {
        public MenuAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

