/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.limewire.mojito.Context;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.visual.ArcsVisualizer;

public class AdvancedMenu
extends AbstractMenu {
    private final EnabledListener enabledListener = new EnabledListener(this.getMenu());

    AdvancedMenu() {
        super(I18n.tr("&Advanced"));
        ArcsAction arcsAction = new ArcsAction();
        this.addMenuItem(arcsAction);
        GuiCoreMediator.getDHTManager().addEventListener(arcsAction);
    }

    protected JMenuItem addMenuItem(Action action) {
        action.addPropertyChangeListener(this.enabledListener);
        if (action.isEnabled()) {
            this.enabledListener.change(true);
        }
        return super.addMenuItem(action);
    }

    private static class ArcsAction
    extends AbstractAction
    implements DHTEventListener {
        public ArcsAction() {
            super(I18n.tr("Mojito &DHT Arcs View"));
            this.putValue("LongDescription", I18n.tr("Display a view of the incoming and outgoing DHT messages"));
            this.setEnabled(GuiCoreMediator.getDHTManager().isRunning());
        }

        public void actionPerformed(ActionEvent e) {
            MojitoDHT dht = GuiCoreMediator.getDHTManager().getMojitoDHT();
            if (dht != null) {
                ArcsVisualizer.show((Context)dht);
            }
        }

        public void handleDHTEvent(DHTEvent evt) {
            this.setEnabledLater(evt.getType() != DHTEvent.Type.STOPPED);
        }
    }

    private static class EnabledListener
    implements PropertyChangeListener {
        private final JMenu mainMenu;
        private int enableds;

        public EnabledListener(JMenu mainMenu) {
            this.mainMenu = mainMenu;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                this.change((Boolean)evt.getNewValue());
            }
        }

        void change(boolean plus) {
            this.enableds = plus ? ++this.enableds : --this.enableds;
            if (this.enableds > 0) {
                this.mainMenu.setEnabled(true);
            } else {
                this.mainMenu.setEnabled(false);
            }
        }
    }
}

