/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.OpenLinkAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Random;
import javax.swing.Icon;
import org.limewire.util.OSUtils;

final class HelpMenu
extends AbstractMenu {
    HelpMenu() {
        super(I18n.tr("&Help"));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/?id=support", I18n.tr("&Using FrostWire"), I18n.tr("Help for Using FrostWire")));
        this.addMenuItem(new ShowTipOfTheDayAction());
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/?id=faq", I18n.tr("&FAQ"), I18n.tr("Frequently Asked Questions for FrostWire")));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/forum/viewforum.php?f=1", I18n.tr("Foru&m"), I18n.tr("Access the FrostWire Users' Forum")));
        if (!OSUtils.isMacOSX()) {
            this.addSeparator();
            this.addMenuItem(new ShowAboutDialogAction());
        }
        if (LimeWireUtils.isTestingVersion()) {
            this.addSeparator();
            this.addMenuItem(new ShowNotificationAction());
            this.addMenuItem(new GenerateUncaughtErrorAction());
        }
    }

    private static class ShowNotificationAction
    extends AbstractAction {
        public ShowNotificationAction() {
            this.putValue("Name", "Show Notification");
        }

        public void actionPerformed(ActionEvent e) {
            if (new Random().nextBoolean()) {
                Icon icon = IconManager.instance().getIconForFile(new File("frostwire.exe"));
                Notification notification = new Notification("This is a very looooooooooooooooooooooooooooooooong message.", icon, this);
                NotifyUserProxy.instance().showMessage(notification);
            } else if (new Random().nextBoolean()) {
                Icon icon = IconManager.instance().getIconForFile(new File("frostwire.html"));
                Notification notification = new Notification("This is a another very loooong  loooong loooong loooong loooong loooong loooong loooong loooong message.", icon, this);
                NotifyUserProxy.instance().showMessage(notification);
            } else {
                Icon icon = IconManager.instance().getIconForFile(new File("frostwire.html"));
                Notification notification = new Notification("Short message.", icon, this);
                NotifyUserProxy.instance().showMessage(notification);
            }
        }
    }

    private static class ShowAboutDialogAction
    extends AbstractAction {
        public ShowAboutDialogAction() {
            super(I18n.tr("&About FrostWire"));
            this.putValue("LongDescription", I18n.tr("Information about FrostWire"));
        }

        public void actionPerformed(ActionEvent e) {
            GUIMediator.showAboutWindow();
        }
    }

    private static class GenerateUncaughtErrorAction
    extends AbstractAction {
        public GenerateUncaughtErrorAction() {
            super(I18n.tr("Generate &Error"));
            this.putValue("LongDescription", I18n.tr("Generate a Popup Error for Testing"));
        }

        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException("Generated Error");
        }
    }

    private static class ShowTipOfTheDayAction
    extends AbstractAction {
        public ShowTipOfTheDayAction() {
            super(I18n.tr("Tip of the &Day"));
            this.putValue("LongDescription", I18n.tr("Show the Tip of the Day Window"));
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayMediator.instance().displayTipWindow();
        }
    }
}

