/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.menu.SearchMenu;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;

final class ShowHideMenu
extends AbstractMenu {
    ShowHideMenu() {
        super(I18n.tr("Sho&w/Hide"));
        for (GUIMediator.Tabs tab : GUIMediator.Tabs.getOptionalTabs()) {
            if (tab == GUIMediator.Tabs.FROSTCLICK) continue;
            this.addToggleMenuItem(new ShowTabAction(tab), tab.isViewEnabled());
        }
        this.MENU.add(new SearchMenu().getMenu());
    }

    private static class ShowTabAction
    extends AbstractAction {
        private final GUIMediator.Tabs tab;

        private ShowTabAction(GUIMediator.Tabs tab) {
            super(tab.getName());
            this.putValue("LongDescription", I18n.tr("Show {0} Window", tab.getName()));
            this.tab = tab;
            tab.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("name".equals(evt.getPropertyName())) {
                        ShowTabAction.this.putValue("Name", evt.getNewValue());
                        ShowTabAction.this.putValue("LongDescription", I18n.tr("Show {0} Window", evt.getNewValue()));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent ae) {
            AbstractButton button = (AbstractButton)ae.getSource();
            GUIMediator.instance().setTabVisible(this.tab, button.isSelected());
            GUIMediator.instance().setWindow(this.tab);
        }
    }
}

