/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.OpenLinkAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ThemeMenu
extends AbstractMenu {
    private static final String THEME_PROPERTY = "THEME_NAME";
    private static final String THEME_CLASSNAME = "THEME_CLASSNAME";
    private static final Action THEME_CHANGER = new ThemeChangeAction();
    private static final ButtonGroup GROUP = new ButtonGroup();

    ThemeMenu() {
        super(I18n.tr("&Apply Skins"));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/beta/skins/", I18n.tr("&Get More Skins"), I18n.tr("Find more skins from frostwire.com")));
        this.addMenuItem(new RefreshThemesAction());
        JMenuItem def = this.addMenuItem(THEME_CHANGER);
        final String defaultVal = ThemeSettings.THEME_DEFAULT.getAbsolutePath();
        def.putClientProperty(THEME_PROPERTY, defaultVal);
        def.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ThemeMenu.setSelection(defaultVal);
            }
        });
        this.addSeparator();
        this.addThemeItems();
    }

    private static void setSelection(Object value) {
        Enumeration<AbstractButton> items = GROUP.getElements();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            if (!value.equals(item.getClientProperty(THEME_PROPERTY))) continue;
            item.setSelected(true);
            break;
        }
    }

    private void addThemeItems() {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        if (!themeDir.exists()) {
            return;
        }
        TreeSet<Object> allThemes = new TreeSet<Object>(new ThemeComparator());
        String[] copiedThemes = themeDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".fwtp");
            }
        });
        if (copiedThemes != null && copiedThemes.length > 0) {
            allThemes.addAll(Arrays.asList(copiedThemes));
        }
        allThemes.addAll(ThemeSettings.JAR_THEME_NAMES);
        Iterator i = allThemes.iterator();
        while (i.hasNext()) {
            if (this.isAllowedThemeFilename((String)i.next())) continue;
            i.remove();
        }
        ThemeMenu.addInstalledLFs(allThemes);
        if (allThemes.isEmpty()) {
            return;
        }
        String otherClassName = ThemeSettings.getOtherLF();
        for (Object e : allThemes) {
            JRadioButtonMenuItem theme;
            File themeFile;
            if (e instanceof String) {
                themeFile = new File(themeDir, (String)e);
                theme = new JRadioButtonMenuItem(ThemeSettings.formatName(themeFile.getName()));
                if (themeFile.equals(ThemeSettings.THEME_FILE.getValue())) {
                    theme.setSelected(true);
                }
            } else {
                themeFile = new File(themeDir, "other_theme.fwtp");
                UIManager.LookAndFeelInfo lfi = (UIManager.LookAndFeelInfo)e;
                theme = new JRadioButtonMenuItem(lfi.getName());
                if (themeFile.equals(ThemeSettings.THEME_FILE.getValue()) && otherClassName != null && lfi.getClassName().equals(otherClassName)) {
                    theme.setSelected(true);
                }
                theme.putClientProperty(THEME_CLASSNAME, lfi.getClassName());
            }
            theme.setFont(AbstractMenu.FONT);
            GROUP.add(theme);
            theme.addActionListener(THEME_CHANGER);
            theme.putClientProperty(THEME_PROPERTY, themeFile.getAbsolutePath());
            this.MENU.add(theme);
        }
    }

    private void removeThemeItems() {
        Enumeration<AbstractButton> items = GROUP.getElements();
        LinkedList<JMenuItem> removed = new LinkedList<JMenuItem>();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            this.MENU.remove(item);
            removed.add(item);
        }
        for (JMenuItem item : removed) {
            GROUP.remove(item);
        }
    }

    private static void addInstalledLFs(Set<Object> themes) {
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        if (lfs == null) {
            return;
        }
        for (int i = 0; i < lfs.length; ++i) {
            UIManager.LookAndFeelInfo l = lfs[i];
            if (l.getClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") || l.getClassName().startsWith("apple") || l.getClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && OSUtils.isLinux() || l.getClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) continue;
            themes.add(l);
        }
    }

    private boolean isAllowedThemeFilename(String name) {
        if (!name.endsWith("fwtp")) {
            return false;
        }
        if (name.startsWith("default_")) {
            return false;
        }
        if (name.equals("other_theme.fwtp")) {
            return false;
        }
        if (!OSUtils.isMacOSX() && name.equals("pinstripes_theme_osx.fwtp")) {
            return false;
        }
        if (!OSUtils.isMacOSX() && name.equals("brushed_metal_theme_osx.fwtp")) {
            return false;
        }
        if (!OSUtils.isWindows() && name.equals("windows_theme.fwtp")) {
            return false;
        }
        if (!LimeWireUtils.isPro() && name.equals("frostwirePro_theme.fwtp")) {
            return false;
        }
        return !name.equals("GTK_theme.fwtp") || OSUtils.isLinux();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThemeComparator
    implements Comparator<Object> {
        private ThemeComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            String name1 = a instanceof String ? ThemeSettings.formatName((String)a) : ((UIManager.LookAndFeelInfo)a).getName();
            String name2 = b instanceof String ? ThemeSettings.formatName((String)b) : ((UIManager.LookAndFeelInfo)b).getName();
            return name1.compareTo(name2);
        }
    }

    protected static class ThemeChangeAction
    extends AbstractAction {
        public ThemeChangeAction() {
            super(I18n.tr("Use &Default"));
            this.putValue("LongDescription", I18n.tr("Use your default skin"));
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            String themePath = (String)item.getClientProperty(ThemeMenu.THEME_PROPERTY);
            String className = (String)item.getClientProperty(ThemeMenu.THEME_CLASSNAME);
            ThemeMediator.changeTheme(new File(themePath), className);
        }
    }

    private class RefreshThemesAction
    extends AbstractAction {
        public RefreshThemesAction() {
            super(I18n.tr("&Refresh Skins"));
            this.putValue("LongDescription", I18n.tr("Reload available skins from disk"));
        }

        public void actionPerformed(ActionEvent e) {
            ThemeMenu.this.removeThemeItems();
            ThemeMenu.this.addThemeItems();
        }
    }
}

