/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageWindow;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.ToggleSettingAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.menu.ShowHideMenu;
import com.limegroup.gnutella.gui.menu.ThemeMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.event.ActionEvent;
import org.limewire.setting.BooleanSetting;

final class ViewMenu
extends AbstractMenu {
    ViewMenu(String key) {
        super(I18n.tr("&View"));
        this.MENU.add(new ShowHideMenu().getMenu());
        this.addSeparator();
        this.MENU.add(new ThemeMenu().getMenu());
        this.MENU.addSeparator();
        ToggleSettingAction toggleAction = new ToggleIconSettingAction(UISettings.SMALL_ICONS, I18n.tr("Use &Small Icons"), I18n.tr("Use Small Icons"));
        this.addToggleMenuItem(toggleAction);
        toggleAction = new ToggleIconSettingAction(UISettings.TEXT_WITH_ICONS, I18n.tr("Show Icon &Text"), I18n.tr("Show Text Below Icons"));
        this.addToggleMenuItem(toggleAction);
        toggleAction = new ToggleSmileySettingAction(UISettings.SMILEYS_IN_CHAT, I18n.tr("Show Smi&leys"), I18n.tr("Show emoticons in chat"));
        this.addToggleMenuItem(toggleAction);
        this.addMenuItem(new ChangeFontSizeAction(2, I18n.tr("&Increase Font Size"), I18n.tr("Increases the Font Size")));
        this.addMenuItem(new ChangeFontSizeAction(-2, I18n.tr("&Decrease Font Size"), I18n.tr("Decreases the Font Size")));
        this.MENU.addSeparator();
        this.addMenuItem(new ShowLanguageWindowAction());
    }

    private static class ChangeFontSizeAction
    extends AbstractAction {
        private final int increment;

        public ChangeFontSizeAction(int inc, String name, String description) {
            super(name);
            this.putValue("LongDescription", description);
            this.increment = inc;
        }

        public void actionPerformed(ActionEvent e) {
            int inc = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
            ThemeSettings.FONT_SIZE_INCREMENT.setValue(inc += this.increment);
            ResourceManager.setFontSizes(this.increment);
            ThemeMediator.updateComponentHierarchy();
        }
    }

    private static class ToggleSmileySettingAction
    extends ToggleSettingAction {
        public static BooleanSetting newsetting;

        public ToggleSmileySettingAction(BooleanSetting setting, String name, String description) {
            super(setting, name, description);
            newsetting = setting;
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            System.out.println("new smiley setting from menu: " + newsetting.getValue());
            GUIMediator.instance().smileysChanged(newsetting.getValue());
        }
    }

    private static class ToggleIconSettingAction
    extends ToggleSettingAction {
        public ToggleIconSettingAction(BooleanSetting setting, String name, String description) {
            super(setting, name, description);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            GUIMediator.instance().buttonViewChanged();
        }
    }

    private static class ShowLanguageWindowAction
    extends AbstractAction {
        public ShowLanguageWindowAction() {
            super(I18n.tr("C&hange Language"));
            this.putValue("LongDescription", I18n.tr("Select your Language Prefereces"));
        }

        public void actionPerformed(ActionEvent e) {
            LanguageWindow lw = new LanguageWindow();
            GUIUtils.centerOnScreen(lw);
            lw.setVisible(true);
        }
    }
}

