/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.RandomAudioInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;
import org.tritonus.share.sampled.TAudioFormat;
import org.tritonus.share.sampled.file.TAudioFileFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeAudioFormat {
    public static final String AUDIO_LENGTH_BYTES = "audio.length.bytes";
    public static final String AUDIO_LENGTH_FRAMES = "audio.length.frames";
    public static final String AUDIO_TYPE = "audio.type";
    public static final String AUDIO_FRAMERATE_FPS = "audio.framerate.fps";
    public static final String AUDIO_FRAMESIZE_BYTES = "audio.framesize.bytes";
    public static final String AUDIO_SAMPLERATE_HZ = "audio.samplerate.hz";
    public static final String AUDIO_SAMPLESIZE_BITS = "audio.samplesize.bits";
    public static final String AUDIO_CHANNELS = "audio.channels";
    private final AudioInputStream audioInputStream;
    private final SourceDataLine sourceDataLine;
    private final AudioInputStream encodedAudioInputStream;
    private final AudioSource audioSource;
    private final Map<String, Object> properties;
    private final long totalLength;
    private FloatControl gainControl;

    public LimeAudioFormat(File file, long position) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(new AudioSource(file), position);
    }

    public LimeAudioFormat(InputStream stream, long position) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(new AudioSource(stream), position);
    }

    public LimeAudioFormat(AudioSource audioSource, long position) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (audioSource == null) {
            throw new NullPointerException("Couldn't load song");
        }
        this.audioSource = audioSource;
        this.encodedAudioInputStream = LimeAudioFormat.createAudioInputStream(audioSource, position);
        this.properties = LimeAudioFormat.createProperties(audioSource);
        this.totalLength = audioSource.getFile() != null ? audioSource.getFile().length() : (long)this.encodedAudioInputStream.available();
        this.audioInputStream = LimeAudioFormat.createDecodedAudioInputStream(this.encodedAudioInputStream);
        this.sourceDataLine = this.createSourceDataLine(this.audioInputStream);
    }

    public static AudioInputStream createAudioInputStream(AudioSource source, long skip) throws UnsupportedAudioFileException, IOException {
        AudioInputStream stream;
        if (source.getFile() != null) {
            if (skip < 0L || skip > source.getFile().length() - 10000L) {
                skip = 0L;
            }
            if (source.getFile().getName().toLowerCase(Locale.US).endsWith(".mp3")) {
                RandomAudioInputStream i = new RandomAudioInputStream(new RandomAccessFile(source.getFile(), "rw"));
                i.skip(skip);
                stream = AudioSystem.getAudioInputStream(i);
            } else {
                stream = AudioSystem.getAudioInputStream(source.getFile());
                stream.skip(skip);
            }
        } else if (source.getStream() != null) {
            stream = AudioSystem.getAudioInputStream(source.getStream());
        } else if (source.getURL() != null) {
            stream = AudioSystem.getAudioInputStream(source.getURL().openStream());
        } else {
            throw new IllegalArgumentException("Attempting to open invalid audio source");
        }
        return stream;
    }

    public static AudioInputStream createDecodedAudioInputStream(AudioInputStream audioInputStream) {
        AudioFormat sourceFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, sourceFormat, 16384);
        if (AudioSystem.isLineSupported(info)) {
            return audioInputStream;
        }
        int nSampleSizeInBits = sourceFormat.getSampleSizeInBits();
        if (nSampleSizeInBits <= 0) {
            nSampleSizeInBits = 16;
        }
        if (sourceFormat.getEncoding() == AudioFormat.Encoding.ULAW || sourceFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            nSampleSizeInBits = 16;
        }
        if (nSampleSizeInBits != 8) {
            nSampleSizeInBits = 16;
        }
        AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), nSampleSizeInBits, sourceFormat.getChannels(), sourceFormat.getChannels() * (nSampleSizeInBits / 8), sourceFormat.getSampleRate(), false);
        info = new DataLine.Info(SourceDataLine.class, targetFormat, 16384);
        return AudioSystem.getAudioInputStream(targetFormat, audioInputStream);
    }

    private SourceDataLine createSourceDataLine(AudioInputStream audioInputStream) throws LineUnavailableException {
        return this.createSourceDataLine(audioInputStream, -1);
    }

    private SourceDataLine createSourceDataLine(AudioInputStream audioInputStream, int bufferSize) throws LineUnavailableException {
        if (audioInputStream == null) {
            throw new NullPointerException("input stream is null");
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        if (bufferSize <= 0) {
            bufferSize = line.getBufferSize();
        }
        line.open(audioFormat, bufferSize);
        if (line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return line;
    }

    private static Map<String, Object> createProperties(AudioSource source) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat;
        AudioFileFormat audioFileFormat;
        Map<String, Object> properties = new HashMap<String, Object>();
        if (source.getFile() != null) {
            audioFileFormat = AudioSystem.getAudioFileFormat(source.getFile());
        } else if (source.getStream() != null) {
            audioFileFormat = AudioSystem.getAudioFileFormat(source.getStream());
        } else {
            return properties;
        }
        if (audioFileFormat instanceof TAudioFileFormat) {
            properties = GenericsUtils.scanForMap(((TAudioFileFormat)audioFileFormat).properties(), String.class, Object.class, GenericsUtils.ScanMode.REMOVE);
            HashMap<String, Object> newMap = new HashMap<String, Object>(properties);
            properties = newMap;
        }
        if (audioFileFormat.getByteLength() > 0) {
            properties.put(AUDIO_LENGTH_BYTES, audioFileFormat.getByteLength());
        }
        if (audioFileFormat.getFrameLength() > 0) {
            properties.put(AUDIO_LENGTH_FRAMES, audioFileFormat.getFrameLength());
        }
        if (audioFileFormat.getType() != null) {
            properties.put(AUDIO_TYPE, audioFileFormat.getType().toString());
        }
        if ((audioFormat = audioFileFormat.getFormat()).getFrameRate() > 0.0f) {
            properties.put(AUDIO_FRAMERATE_FPS, Float.valueOf(audioFormat.getFrameRate()));
        }
        if (audioFormat.getFrameSize() > 0) {
            properties.put(AUDIO_FRAMESIZE_BYTES, audioFormat.getFrameSize());
        }
        if (audioFormat.getSampleRate() > 0.0f) {
            properties.put(AUDIO_SAMPLERATE_HZ, Float.valueOf(audioFormat.getSampleRate()));
        }
        if (audioFormat.getSampleSizeInBits() > 0) {
            properties.put(AUDIO_SAMPLESIZE_BITS, audioFormat.getSampleSizeInBits());
        }
        if (audioFormat.getChannels() > 0) {
            properties.put(AUDIO_CHANNELS, audioFormat.getChannels());
        }
        if (audioFormat instanceof TAudioFormat) {
            Map<String, Object> addproperties = GenericsUtils.scanForMap(((TAudioFormat)audioFormat).properties(), String.class, Object.class, GenericsUtils.ScanMode.REMOVE);
            properties.putAll(addproperties);
        }
        return properties;
    }

    public AudioSource getSource() {
        return this.audioSource;
    }

    public AudioInputStream getAudioInputStream() {
        return this.audioInputStream;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return new HashMap<String, Object>();
    }

    public long totalLength() {
        return this.totalLength;
    }

    public int available() {
        int avail = -1;
        if (this.encodedAudioInputStream != null) {
            try {
                avail = this.encodedAudioInputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return avail;
    }

    public void startSourceDataLine() {
        if (this.sourceDataLine != null && !this.sourceDataLine.isRunning()) {
            this.sourceDataLine.start();
        }
    }

    public void stopSourceDataLine() {
        if (this.sourceDataLine != null && this.sourceDataLine.isRunning()) {
            this.sourceDataLine.flush();
            this.sourceDataLine.stop();
        }
    }

    public int getEncodedStreamPosition() {
        return (int)(this.totalLength - (long)this.available());
    }

    public long seek(long position) {
        return -1L;
    }

    public void closeStreams() {
        FileUtils.close(this.encodedAudioInputStream);
        FileUtils.close(this.audioInputStream);
        if (this.sourceDataLine != null) {
            this.sourceDataLine.stop();
            this.sourceDataLine.close();
        }
    }

    public float getGainValue() {
        if (this.hasGainControl()) {
            return this.gainControl.getValue();
        }
        return 0.0f;
    }

    public float getMaximumGain() {
        if (this.hasGainControl()) {
            return this.gainControl.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimumGain() {
        if (this.hasGainControl()) {
            return this.gainControl.getMinimum();
        }
        return 0.0f;
    }

    public boolean hasGainControl() {
        if (this.gainControl == null && this.sourceDataLine != null && this.sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.gainControl = (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return this.gainControl != null;
    }

    public void setGain(double fGain) throws IOException {
        if (!this.hasGainControl()) {
            throw new IOException("Volume error");
        }
        double ampGainDB = 0.5f * this.getMaximumGain() - this.getMinimumGain();
        double cste = Math.log(10.0) / 20.0;
        double valueDB = (double)this.getMinimumGain() + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGainDB) - 1.0) * fGain);
        this.gainControl.setValue((float)valueDB);
    }
}

