/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerEvent;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.LimeAudioFormat;
import com.limegroup.gnutella.gui.mp3.PlayerState;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ThreadExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeWirePlayer
implements Runnable,
AudioPlayer,
RefreshListener {
    private static final long SLEEP_NONPLAYING = 100L;
    private static final long SLEEP_PLAYING = 150L;
    public static final int EXTERNAL_BUFFER_SIZE = 16384;
    private List<AudioPlayerListener> listenerList = new CopyOnWriteArrayList<AudioPlayerListener>();
    private Thread playerthread;
    private final LoadSongBuffer songBuffer;
    private final Object threadLock = new Object();
    private volatile PlayerState playerState = PlayerState.UNKNOWN;
    private Object seekLock = new Object();
    private long seekValue = -1L;
    private volatile boolean loadSong = false;
    private Object volumeLock = new Object();
    private boolean setVolume = false;
    private double volume = 0.0;
    private LimeAudioFormat currentAudioFormat;
    private AudioSource currentSong;
    private final byte[] buffer = new byte[16384];
    private int readBytes = 0;
    private int avail;

    public LimeWirePlayer() {
        this.songBuffer = new LoadSongBuffer();
    }

    @Override
    public void addAudioPlayerListener(AudioPlayerListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeAudioPlayerListener(AudioPlayerListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public PlayerState getStatus() {
        return this.playerState;
    }

    @Override
    public void loadSong(AudioSource source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.songBuffer.setSong(source);
    }

    @Override
    public void playSong() {
        this.stop();
        this.loadSong = true;
        this.playerState = PlayerState.PLAYING;
        if (this.playerthread == null || !this.playerthread.isAlive()) {
            this.playerthread = ThreadExecutor.newManagedThread(this, "LimewirePlayer");
            this.playerthread.setDaemon(true);
            this.playerthread.start();
        }
        this.notifyEvent(PlayerState.PLAYING, -1.0);
    }

    @Override
    public void pause() {
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = PlayerState.PAUSED;
            this.notifyEvent(PlayerState.PAUSED, -1.0);
        }
    }

    @Override
    public void unpause() {
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = PlayerState.PLAYING;
            this.notifyEvent(PlayerState.PLAYING, -1.0);
        }
    }

    @Override
    public void stop() {
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.STOPPED, -1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekLocation(long value) {
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = this.playerState == PlayerState.PAUSED || this.playerState == PlayerState.SEEKING_PAUSED ? PlayerState.SEEKING_PAUSED : PlayerState.SEEKING_PLAY;
            Object object = this.seekLock;
            synchronized (object) {
                this.seekValue = value;
            }
            this.notifyEvent(PlayerState.SEEKING, value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVolume(double fGain) {
        Object object = this.volumeLock;
        synchronized (object) {
            this.volume = fGain;
            this.setVolume = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.playerState != PlayerState.UNKNOWN) {
            if (this.playerState == PlayerState.STOPPED) {
                for (int i = 0; i < 3; ++i) {
                    if (this.playerState != PlayerState.STOPPED) continue;
                    try {
                        Object object = this.threadLock;
                        synchronized (object) {
                            this.threadLock.wait(100L);
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.playerState == PlayerState.STOPPED) {
                    this.playerState = PlayerState.UNKNOWN;
                }
            }
            if (this.currentAudioFormat != null && this.setVolume) {
                try {
                    double vol = 0.0;
                    Object object = this.volumeLock;
                    synchronized (object) {
                        vol = this.volume;
                        this.setVolume = false;
                    }
                    this.currentAudioFormat.setGain(vol);
                    this.notifyEvent(PlayerState.GAIN, this.volume);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.loadSong) {
                if (this.currentAudioFormat != null) {
                    this.currentAudioFormat.closeStreams();
                }
                this.loadFromSongBuffer();
                if (this.currentSong != null) {
                    this.loading();
                } else {
                    this.playerState = PlayerState.STOPPED;
                }
            }
            if (this.playerState == PlayerState.PLAYING) {
                if (this.currentAudioFormat == null) {
                    this.playerState = PlayerState.STOPPED;
                    continue;
                }
                this.playing();
                continue;
            }
            if (this.playerState == PlayerState.PAUSED) {
                if (this.currentAudioFormat == null) {
                    this.playerState = PlayerState.STOPPED;
                    continue;
                }
                this.pausing();
                continue;
            }
            if (this.playerState != PlayerState.SEEKING && this.playerState != PlayerState.SEEKING_PAUSED && this.playerState != PlayerState.SEEKING_PLAY) continue;
            this.seeking();
        }
        if (this.currentAudioFormat != null) {
            this.currentAudioFormat.closeStreams();
        }
        this.currentAudioFormat = null;
        this.playerState = PlayerState.UNKNOWN;
    }

    private void loadFromSongBuffer() {
        if (this.songBuffer.hasSong()) {
            this.currentSong = this.songBuffer.getSong();
            this.loadSong = false;
        } else {
            this.loadSong = false;
            this.currentSong = null;
            this.playerState = PlayerState.STOPPED;
        }
    }

    private void loading() {
        try {
            this.currentAudioFormat = new LimeAudioFormat(this.currentSong, 0L);
            this.readBytes = 0;
            this.notifyOpened(this.currentAudioFormat.getProperties());
            this.playerState = PlayerState.PLAYING;
        }
        catch (IllegalArgumentException e) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.EOM, -1.0);
        }
        catch (UnsupportedAudioFileException e) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.EOM, -1.0);
        }
        catch (IOException e) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.EOM, -1.0);
        }
        catch (LineUnavailableException e) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.EOM, -1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playing() {
        this.currentAudioFormat.startSourceDataLine();
        this.avail = this.currentAudioFormat.getSourceDataLine().available();
        if (this.avail > 0) {
            try {
                this.readBytes = this.currentAudioFormat.getAudioInputStream().read(this.buffer, 0, Math.min(this.avail, this.buffer.length));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.playerState = PlayerState.STOPPED;
                this.notifyEvent(PlayerState.EOM, -1.0);
                this.loadSong = true;
            }
            catch (IOException e) {
                this.playerState = PlayerState.STOPPED;
            }
            if (this.readBytes > 0) {
                this.currentAudioFormat.getSourceDataLine().write(this.buffer, 0, this.readBytes);
                this.notifyProgress(this.currentAudioFormat.getEncodedStreamPosition());
            } else if (this.readBytes == -1) {
                this.notifyEvent(PlayerState.EOM, -1.0);
                this.loadSong = true;
            }
        } else {
            try {
                Object e = this.threadLock;
                synchronized (e) {
                    this.threadLock.wait(150L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pausing() {
        this.currentAudioFormat.stopSourceDataLine();
        try {
            Object object = this.threadLock;
            synchronized (object) {
                this.threadLock.wait(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seeking() {
        try {
            long seekLocation = 0L;
            Object object = this.seekLock;
            synchronized (object) {
                seekLocation = this.seekValue;
                this.seekValue = 0L;
            }
            if (this.currentAudioFormat != null) {
                this.currentAudioFormat.closeStreams();
            }
            this.currentAudioFormat = new LimeAudioFormat(this.currentSong, seekLocation);
            object = this.volumeLock;
            synchronized (object) {
                this.setVolume = true;
            }
            this.playerState = this.playerState == PlayerState.SEEKING_PAUSED ? PlayerState.PAUSED : PlayerState.PLAYING;
        }
        catch (UnsupportedAudioFileException e) {
            this.playerState = PlayerState.STOPPED;
        }
        catch (IOException e) {
            this.playerState = PlayerState.STOPPED;
        }
        catch (LineUnavailableException e) {
            this.playerState = PlayerState.STOPPED;
        }
    }

    protected void notifyOpened(final Map<String, Object> properties) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimeWirePlayer.this.fireOpened(properties);
            }
        });
    }

    protected void notifyEvent(final PlayerState state, final double value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimeWirePlayer.this.fireStateUpdated(new AudioPlayerEvent(state, value));
            }
        });
    }

    protected void notifyProgress(final int bytesread) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimeWirePlayer.this.fireProgress(bytesread);
            }
        });
    }

    protected void fireOpened(Map<String, Object> properties) {
        for (AudioPlayerListener listener : this.listenerList) {
            listener.songOpened(properties);
        }
    }

    protected void fireProgress(int bytesread) {
        for (AudioPlayerListener listener : this.listenerList) {
            listener.progressChange(bytesread);
        }
    }

    protected void fireStateUpdated(AudioPlayerEvent event) {
        for (AudioPlayerListener listener : this.listenerList) {
            listener.stateChange(event);
        }
    }

    @Override
    public void refresh() {
        this.notifyEvent(this.getStatus(), -1.0);
    }

    private class LoadSongBuffer {
        private AudioSource nextItem;

        private LoadSongBuffer() {
        }

        public synchronized void setSong(AudioSource song) {
            this.nextItem = song;
        }

        public synchronized AudioSource getSong() {
            AudioSource next = this.nextItem;
            this.nextItem = null;
            return next;
        }

        public synchronized boolean hasSong() {
            return this.nextItem != null;
        }
    }
}

