/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.MediaSlider;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerEvent;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.LimeWirePlayer;
import com.limegroup.gnutella.gui.mp3.MediaPlayerPanel;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.mp3.PlayerState;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.lws.server.LWSManager;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandlerWithCallback;
import com.limegroup.gnutella.lws.server.LWSUtil;
import com.limegroup.gnutella.settings.LWSSettings;
import com.limegroup.gnutella.util.Tagged;
import com.limegroup.gnutella.util.URLDecoder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.lws.server.LWSServerUtil;
import org.limewire.service.ErrorService;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaPlayerComponent
implements AudioPlayerListener,
RefreshListener,
ThemeObserver {
    private static final Log LOG = LogFactory.getLog(MediaPlayerComponent.class);
    private static final String MP3 = "mp3";
    private static final String WAVE = "wave";
    public static final String STREAMING_AUDIO = "Streaming Audio";
    private static MediaPlayerComponent INSTANCE = null;
    private static final long SCROLL_RATE = 200L;
    private static final int STRING_SIZE_TO_SHOW = 20;
    public final int fullSizeWidth = 351;
    public final int minWidth = 240;
    private static final MediaButton PLAY_BUTTON = new MediaButton(I18n.tr("Play"), "play_up", "play_dn");
    private static final MediaButton PAUSE_BUTTON = new MediaButton(I18n.tr("Pause"), "pause_up", "pause_dn");
    private static final MediaButton STOP_BUTTON = new MediaButton(I18n.tr("Stop"), "stop_up", "stop_dn");
    private static final MediaButton NEXT_BUTTON = new MediaButton(I18n.tr("Next"), "forward_up", "forward_dn");
    private static final MediaButton PREV_BUTTON = new MediaButton(I18n.tr("Previous"), "rewind_up", "rewind_dn");
    private static final MediaSlider VOLUME = new MediaSlider("volume_track_left", "volume_track_center", "volume_track_right", "volume_thumb_up", "volume_thumb_dn");
    private static final SongProgressBar PROGRESS = new SongProgressBar("progress_track_left", "progress_track_center", "progress_track_right", "progress_thumb_up", "progress_thumb_dn", "progress_bar");
    private static final ExecutorService SONG_QUEUE = ExecutorsHelper.newProcessingQueue("SongProcessor");
    private final AudioPlayer PLAYER;
    private final Dimension progressBarDimension = new Dimension(129, 19);
    private final Dimension volumeSliderDimension = new Dimension(63, 19);
    private volatile int currBeginIndex = -1;
    private Map audioProperties;
    private long lastScroll = System.currentTimeMillis();
    private PlayListItem currentPlayListItem;
    private JPanel myMediaPanel = null;
    private String currentFileName;
    private boolean playOneTime = false;
    private final Object cfnLock = new Object();

    private MediaPlayerComponent() {
        this.PLAYER = new LimeWirePlayer();
        this.PLAYER.addAudioPlayerListener(this);
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
    }

    public static MediaPlayerComponent getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MediaPlayerComponent();
        }
        return INSTANCE;
    }

    public JPanel getMediaPanel() {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel();
        }
        return this.myMediaPanel;
    }

    private JPanel constructMediaPanel() {
        int tempWidth = 0;
        int tempHeight = 0;
        tempHeight += PLAY_BUTTON.getIcon().getIconHeight() + 2;
        tempWidth += PLAY_BUTTON.getIcon().getIconWidth() + 2 + PAUSE_BUTTON.getIcon().getIconWidth() + 2 + STOP_BUTTON.getIcon().getIconWidth() + 2 + NEXT_BUTTON.getIcon().getIconWidth() + 2 + PREV_BUTTON.getIcon().getIconWidth() + 2;
        PROGRESS.setMaximumSize(this.progressBarDimension);
        PROGRESS.setPreferredSize(this.progressBarDimension);
        PROGRESS.setString(I18n.tr("FrostWire Media Player"));
        PROGRESS.setMaximum(3600);
        PROGRESS.setEnabled(false);
        VOLUME.setMaximumSize(this.volumeSliderDimension);
        VOLUME.setPreferredSize(this.volumeSliderDimension);
        VOLUME.setMinimum(0);
        VOLUME.setValue(50);
        VOLUME.setMaximum(100);
        VOLUME.setEnabled(true);
        this.registerListeners();
        MediaPlayerPanel buttonPanel = new MediaPlayerPanel(0);
        buttonPanel.setMaximumSize(new Dimension(tempWidth + PROGRESS.getWidth() + VOLUME.getWidth(), tempHeight));
        buttonPanel.setMinimumSize(new Dimension(tempWidth, tempHeight));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(VOLUME);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(PREV_BUTTON);
        buttonPanel.add(PLAY_BUTTON);
        buttonPanel.add(PAUSE_BUTTON);
        buttonPanel.add(STOP_BUTTON);
        buttonPanel.add(NEXT_BUTTON);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(PROGRESS);
        if (OSUtils.isMacOSX()) {
            buttonPanel.add(Box.createHorizontalStrut(16));
        }
        buttonPanel.add(Box.createHorizontalGlue());
        return buttonPanel;
    }

    public void registerListeners() {
        PLAY_BUTTON.addActionListener(new PlayListener());
        PAUSE_BUTTON.addActionListener(new PauseListener());
        STOP_BUTTON.addActionListener(new StopListener());
        NEXT_BUTTON.addActionListener(new NextListener());
        PREV_BUTTON.addActionListener(new BackListener());
        VOLUME.addChangeListener(new VolumeSliderListener());
        PROGRESS.addChangeListener(new ProgressBarListener());
        LWSManager lwsManager = GuiCoreMediator.getLWSManager();
        lwsManager.registerHandler("Back", new LWSManagerCommandResponseHandlerWithCallback("Back"){

            @Override
            protected String handleRest(Map<String, String> args) {
                MediaPlayerComponent.this.back();
                return "ok";
            }
        });
        lwsManager.registerHandler("Stop", new LWSManagerCommandResponseHandlerWithCallback("Stop"){

            @Override
            protected String handleRest(Map<String, String> args) {
                MediaPlayerComponent.this.stopSong();
                return "ok";
            }
        });
        lwsManager.registerHandler("Pause", new LWSManagerCommandResponseHandlerWithCallback("Pause"){

            @Override
            protected String handleRest(Map<String, String> args) {
                MediaPlayerComponent.this.pauseSong();
                return "ok";
            }
        });
        lwsManager.registerHandler("Play", new LWSManagerCommandResponseHandlerWithCallback("Play"){

            @Override
            protected String handleRest(Map<String, String> args) {
                return MediaPlayerComponent.this.playSong(args);
            }
        });
        lwsManager.registerHandler("PlayURL", new LWSManagerCommandResponseHandlerWithCallback("Play"){

            @Override
            protected String handleRest(Map<String, String> args) {
                MediaPlayerComponent.this.playURL(args);
                return "ok";
            }
        });
        lwsManager.registerHandler("Next", new LWSManagerCommandResponseHandlerWithCallback("Next"){

            @Override
            protected String handleRest(Map<String, String> args) {
                MediaPlayerComponent.this.next();
                return "ok";
            }
        });
        lwsManager.registerHandler("AddToPlaylist", new LWSManagerCommandResponseHandlerWithCallback("AddToPlaylist"){

            @Override
            protected String handleRest(Map<String, String> args) {
                return MediaPlayerComponent.this.addToPlaylist(args);
            }
        });
        lwsManager.registerHandler("GetProgress", new LWSManagerCommandResponseHandlerWithCallback("GetProgress"){

            @Override
            protected String handleRest(Map<String, String> args) {
                return MediaPlayerComponent.this.getProgress();
            }
        });
        lwsManager.registerHandler("GetPlaylist", new LWSManagerCommandResponseHandlerWithCallback("GetPlaylist"){

            @Override
            protected String handleRest(Map<String, String> args) {
                System.out.println(args);
                return MediaPlayerComponent.this.getSongs();
            }
        });
        lwsManager.registerHandler("RemoveFromPlaylist", new LWSManagerCommandResponseHandlerWithCallback("RemoveFromPlaylist"){

            @Override
            protected String handleRest(Map<String, String> args) {
                Tagged<String> indexString = LWSUtil.getArg(args, "index", "RemoveFromPlaylist");
                if (!indexString.isValid()) {
                    return indexString.getValue();
                }
                int index = -1;
                try {
                    index = Integer.parseInt(indexString.getValue());
                }
                catch (NumberFormatException e) {
                    return "invalid.index: " + indexString.getValue();
                }
                return MediaPlayerComponent.this.removeFromPlaylist(index);
            }
        });
        lwsManager.registerHandler("PlayIndexInPlaylist", new LWSManagerCommandResponseHandlerWithCallback("PlayIndexInPlaylist"){

            @Override
            protected String handleRest(Map<String, String> args) {
                Tagged<String> indexString = LWSUtil.getArg(args, "index", "PlayIndexInPlaylist");
                if (!indexString.isValid()) {
                    return indexString.getValue();
                }
                int index = -1;
                try {
                    index = Integer.parseInt(indexString.getValue());
                }
                catch (NumberFormatException e) {
                    return "invalid.index: " + indexString.getValue();
                }
                return MediaPlayerComponent.this.playIndexInPlaylist(index);
            }
        });
        lwsManager.registerHandler("SetProgress", new LWSManagerCommandResponseHandlerWithCallback("SetProgress"){

            @Override
            protected String handleRest(Map<String, String> args) {
                if (MediaPlayerComponent.this.isPlaying()) {
                    double v = Double.parseDouble(args.get("v"));
                    PROGRESS.setValue((int)(v * (double)PROGRESS.getMaximum()));
                    MediaPlayerComponent.this.skip((double)PROGRESS.getValue() * 1.0 / (double)PROGRESS.getMaximum());
                    MediaPlayerComponent.this.setProgressValue(PROGRESS.getValue());
                }
                return "ok";
            }
        });
    }

    public void unregisterListeners() {
        PLAY_BUTTON.removeActionListener(new PlayListener());
        PAUSE_BUTTON.removeActionListener(new PauseListener());
        STOP_BUTTON.removeActionListener(new StopListener());
        NEXT_BUTTON.removeActionListener(new NextListener());
        PREV_BUTTON.removeActionListener(new BackListener());
        VOLUME.removeChangeListener(new VolumeSliderListener());
        PROGRESS.removeChangeListener(new ProgressBarListener());
        LWSManager lwsManager = GuiCoreMediator.getLWSManager();
        lwsManager.unregisterHandler("Back");
        lwsManager.unregisterHandler("Stop");
        lwsManager.unregisterHandler("Pause");
        lwsManager.unregisterHandler("Play");
        lwsManager.unregisterHandler("Next");
        lwsManager.unregisterHandler("GetProgress");
        lwsManager.unregisterHandler("SetProgress");
        lwsManager.unregisterHandler("GetPlaylist");
        lwsManager.unregisterHandler("RemoveFromPlaylist");
    }

    @Override
    public void refresh() {
        this.PLAYER.refresh();
        if (this.getMediaPanel().getSize().width < 351) {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    PROGRESS.setVisible(false);
                    VOLUME.setVisible(false);
                }
            });
        } else {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    PROGRESS.setVisible(true);
                    VOLUME.setVisible(true);
                }
            });
        }
    }

    @Override
    public void updateTheme() {
        ((MediaPlayerPanel)this.getMediaPanel()).updateTheme();
        PLAY_BUTTON.updateTheme();
        PAUSE_BUTTON.updateTheme();
        STOP_BUTTON.updateTheme();
        NEXT_BUTTON.updateTheme();
        PREV_BUTTON.updateTheme();
        PROGRESS.updateTheme();
        PROGRESS.setString(I18n.tr("FrostWire Media Player"));
        VOLUME.updateTheme();
    }

    private void setProgressString(final String update) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PROGRESS.setString(update);
            }
        });
    }

    private void setProgressValue(final int update) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PROGRESS.setValue(update);
            }
        });
    }

    private void setProgressEnabled(final boolean enabled) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PROGRESS.setEnabled(enabled);
            }
        });
    }

    private void setVolumeValue() {
        VOLUME.repaint();
        this.PLAYER.setVolume((float)VOLUME.getValue() / (float)VOLUME.getMaximum());
    }

    public void loadSong(PlayListItem item) {
        this.loadSong(item, false);
    }

    public void loadSong(PlayListItem item, boolean playOnce) {
        if (item == null || item.getAudioSource() == null) {
            return;
        }
        this.currentPlayListItem = item;
        this.playOneTime = playOnce;
        this.loadSong(item.getAudioSource(), item.getName());
    }

    private void loadSong(AudioSource audioSource, String displayName) {
        if (audioSource == null) {
            return;
        }
        SONG_QUEUE.execute(new SongLoader(audioSource));
        this.currentFileName = displayName != null && displayName.length() > 0 ? this.generateNameDisplay(displayName) : this.generateNameDisplay(STREAMING_AUDIO);
    }

    public void play() {
        if (this.PLAYER.getStatus() == PlayerState.PAUSED || this.PLAYER.getStatus() == PlayerState.PLAYING) {
            this.PLAYER.unpause();
        } else {
            this.loadSong(this.currentPlayListItem, this.playOneTime);
        }
    }

    public void pauseSong() {
        if (this.PLAYER.getStatus() == PlayerState.PAUSED) {
            this.PLAYER.unpause();
        } else {
            this.PLAYER.pause();
        }
    }

    public void stopSong() {
        this.PLAYER.stop();
    }

    public void skip(double percent) {
        String songType;
        if (this.audioProperties != null && this.audioProperties.containsKey("audio.type") && this.isSeekable(songType = (String)this.audioProperties.get("audio.type")) && this.audioProperties.containsKey("audio.length.bytes")) {
            long skipBytes = Math.round((double)((Integer)this.audioProperties.get("audio.length.bytes")).intValue() * percent);
            this.PLAYER.seekLocation(skipBytes);
        }
    }

    private boolean isSeekable(String songType) {
        if (songType == null) {
            return false;
        }
        return songType.equalsIgnoreCase(MP3) || songType.equalsIgnoreCase(WAVE);
    }

    public PlayListItem getCurrentSong() {
        return this.currentPlayListItem;
    }

    private String generateNameDisplay(String filename) {
        if (filename.length() > 20) {
            filename = filename + " *** " + filename + " *** ";
        }
        this.currBeginIndex = -1;
        return filename;
    }

    @Override
    public void songOpened(Map<String, Object> properties) {
        this.audioProperties = properties;
        this.setVolumeValue();
        if (this.audioProperties.containsKey("audio.length.bytes") && this.isSeekable((String)this.audioProperties.get("audio.type"))) {
            this.setProgressEnabled(true);
        } else {
            this.setProgressEnabled(false);
        }
        GUIMediator.getPlayList().playStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void progressChange(int bytesread) {
        if (this.audioProperties.containsKey("audio.length.bytes")) {
            int byteslength = (Integer)this.audioProperties.get("audio.length.bytes");
            float progressUpdate = (float)bytesread * 1.0f / (float)byteslength * 1.0f;
            if (!PROGRESS.getValueIsAdjusting() && this.PLAYER.getStatus() != PlayerState.SEEKING) {
                this.setProgressValue((int)((float)PROGRESS.getMaximum() * progressUpdate));
            }
        }
        if (this.currentFileName.length() <= 20) {
            this.setProgressString(this.currentFileName);
        } else if (System.currentTimeMillis() - this.lastScroll > 200L) {
            Object object = this.cfnLock;
            synchronized (object) {
                this.lastScroll = System.currentTimeMillis();
                if (this.currentFileName == null) {
                    return;
                }
                ++this.currBeginIndex;
                if (this.currBeginIndex > this.currentFileName.length() / 2) {
                    this.currBeginIndex = 0;
                }
                this.setProgressString(this.currentFileName.substring(this.currBeginIndex, this.currBeginIndex + 20));
            }
        }
    }

    @Override
    public void stateChange(AudioPlayerEvent event) {
        if (event.getState() == PlayerState.UNKNOWN) {
            this.setProgressEnabled(false);
        } else if (event.getState() == PlayerState.OPENED || event.getState() == PlayerState.SEEKED) {
            this.setVolumeValue();
        } else if (event.getState() == PlayerState.STOPPED) {
            this.setProgressValue(PROGRESS.getMinimum());
        } else if (event.getState() == PlayerState.EOM) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("play completed for: " + this.currentFileName);
            }
            this.setProgressValue(PROGRESS.getMinimum());
            PlaylistMediator playlist = GUIMediator.getPlayList();
            if (playlist == null) {
                return;
            }
            if (this.playOneTime || !playlist.isContinuous() || playlist.getSize() <= 0 || playlist.isEndOfList() && !playlist.isContinuous()) {
                playlist.playComplete();
                this.PLAYER.stop();
                System.out.println("FTA DEBUG: Reached end of playlist *stopped*");
            } else {
                playlist.playComplete();
                this.loadSong(playlist.getNextSong());
            }
        }
    }

    String getSongs() {
        PlaylistMediator pl = GUIMediator.getPlayList();
        List<PlayListItem> songs = pl.getSongs();
        StringBuffer res = new StringBuffer();
        if (songs != null) {
            for (PlayListItem s : songs) {
                res.append(s.getName()).append('\t').append(s.getURI()).append('\t').append(s.getProperty("Length")).append('\t').append(s.isStorePreview()).append('|');
            }
        }
        System.out.println("songs:" + res);
        return res.toString();
    }

    String playSong(Map<String, String> args) {
        Tagged<String> urlString = LWSUtil.getArg(args, "url", "AddToPlaylist");
        if (!urlString.isValid()) {
            return urlString.getValue();
        }
        String url = urlString.getValue();
        PlaylistMediator pl = GUIMediator.getPlayList();
        List<PlayListItem> songs = pl.getSongs();
        PlayListItem targetTrack = null;
        for (PlayListItem it : songs) {
            try {
                String thisOne;
                String thatOne = URLDecoder.decode(it.getURI().toString());
                if (!thatOne.equals(thisOne = URLDecoder.decode(url))) continue;
                targetTrack = it;
                break;
            }
            catch (IOException e) {
            }
        }
        if (targetTrack != null) {
            this.loadSong(targetTrack);
            return "ok";
        }
        if (this.PLAYER.getStatus() == PlayerState.PAUSED || this.PLAYER.getStatus() == PlayerState.PLAYING) {
            this.PLAYER.unpause();
        } else {
            this.loadSong(this.currentPlayListItem);
        }
        return "ok";
    }

    String removeFromPlaylist(int index) {
        PlaylistMediator pl = GUIMediator.getPlayList();
        if (pl.removeFileFromPlaylist(index)) {
            return "ok";
        }
        return "invalid.index: " + index;
    }

    String playIndexInPlaylist(int index) {
        PlaylistMediator pl = GUIMediator.getPlayList();
        if (pl.removeFileFromPlaylist(index)) {
            return "ok";
        }
        return "invalid.index: " + index;
    }

    String getProgress() {
        String res;
        if (this.isPlaying()) {
            int secs = PROGRESS.getValue();
            int length = PROGRESS.getMaximum();
            System.out.println(secs + ":" + length);
            res = secs + "\t" + length;
        } else {
            res = "stopped";
        }
        return res.toString();
    }

    String addToPlaylist(Map<String, String> args) {
        Tagged<String> urlString = LWSUtil.getArg(args, "url", "AddToPlaylist");
        if (!urlString.isValid()) {
            return urlString.getValue();
        }
        Tagged<String> nameString = LWSUtil.getArg(args, "name", "AddtoPlaylist");
        if (!nameString.isValid()) {
            return nameString.getValue();
        }
        Tagged<String> lengthString = LWSUtil.getArg(args, "length", "AddtoPlaylist");
        if (!lengthString.isValid()) {
            return lengthString.getValue();
        }
        Tagged<String> artistString = LWSUtil.getArg(args, "artist", "AddtoPlaylist");
        if (!artistString.isValid()) {
            return artistString.getValue();
        }
        Tagged<String> albumString = LWSUtil.getArg(args, "album", "AddtoPlaylist");
        if (!albumString.isValid()) {
            return albumString.getValue();
        }
        String baseDir = "http://" + LWSSettings.LWS_ADD_TO_PLAYLIST_HOSTNAME.getValue();
        int port = LWSSettings.LWS_ADD_TO_PLAYLIST_PORT.getValue();
        if (port > 0) {
            baseDir = baseDir + ":" + port;
        }
        String url = baseDir + urlString.getValue();
        try {
            String decodedURL = URLDecoder.decode(url);
            URL u = new URL(decodedURL);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("audio.length.bytes", lengthString.getValue());
            props.put("audio.type", "MP3");
            props.put("Artist", artistString.getValue());
            if (albumString.isValid()) {
                props.put("Album", albumString.getValue());
            }
            PlayListItem song = new PlayListItem(u.toURI(), new AudioSource(u), nameString.getValue(), false, true, props);
            GUIMediator.instance().launchAudio(song);
        }
        catch (IOException e) {
            ErrorService.error(e, "invalid URL:" + url);
            return LWSServerUtil.wrapError("invalid.url:" + url);
        }
        catch (URISyntaxException e) {
            ErrorService.error(e, "invalid URL:" + url);
            return LWSServerUtil.wrapError("invalid.url:" + url);
        }
        return "ok";
    }

    String playURL(Map<String, String> args) {
        Tagged<String> urlString = LWSUtil.getArg(args, "url", "PlayURL");
        if (!urlString.isValid()) {
            return urlString.getValue();
        }
        String baseDir = "http://" + LWSSettings.LWS_ADD_TO_PLAYLIST_HOSTNAME.getValue();
        int port = LWSSettings.LWS_ADD_TO_PLAYLIST_PORT.getValue();
        if (port > 0) {
            baseDir = baseDir + ":" + port;
        }
        String url = baseDir + urlString.getValue();
        String name = this.getName(url);
        try {
            String decodedURL = URLDecoder.decode(url);
            URL u = new URL(decodedURL);
            HashMap<String, String> props = new HashMap<String, String>();
            PlayListItem song = new PlayListItem(u.toURI(), new AudioSource(u), name, false, true, props);
            GUIMediator.instance().launchAudio(song);
        }
        catch (IOException e) {
            ErrorService.error(e, "invalid URL:" + url);
            return LWSServerUtil.wrapError("invalid.url:" + url);
        }
        catch (URISyntaxException e) {
            ErrorService.error(e, "invalid URL:" + url);
            return LWSServerUtil.wrapError("invalid.url:" + url);
        }
        return "ok";
    }

    private String getName(String url) {
        int ilast = url.lastIndexOf(47);
        if (ilast == -1) {
            ilast = url.lastIndexOf(92);
        }
        if (ilast == -1) {
            return url;
        }
        return url.substring(ilast + 1);
    }

    private boolean isPlaying() {
        return this.PLAYER.getStatus() != PlayerState.STOPPED && this.PLAYER.getStatus() != PlayerState.UNKNOWN && this.PLAYER.getStatus() != PlayerState.PAUSED;
    }

    public boolean attemptStop() {
        if (this.PLAYER.getStatus() != PlayerState.STOPPED) {
            this.PLAYER.stop();
            return true;
        }
        return false;
    }

    private void next() {
        this.loadSong(GUIMediator.getPlayList().getNextSong());
    }

    private void back() {
        this.loadSong(GUIMediator.getPlayList().getPrevSong());
    }

    private class SongLoader
    implements Runnable {
        private final AudioSource audio;

        public SongLoader(AudioSource audio) {
            this.audio = audio;
        }

        public void run() {
            if (this.audio != null) {
                MediaPlayerComponent.this.PLAYER.loadSong(this.audio);
            }
            MediaPlayerComponent.this.PLAYER.playSong();
        }
    }

    private class VolumeSliderListener
    implements ChangeListener {
        private VolumeSliderListener() {
        }

        public void stateChanged(ChangeEvent e) {
            MediaPlayerComponent.this.setVolumeValue();
        }
    }

    private class ProgressBarListener
    implements ChangeListener {
        boolean dragging = false;

        private ProgressBarListener() {
        }

        public void stateChanged(ChangeEvent arg0) {
            if (PROGRESS.getValueIsAdjusting()) {
                this.dragging = true;
            } else if (this.dragging) {
                this.dragging = false;
                if (MediaPlayerComponent.this.PLAYER.getStatus() != PlayerState.SEEKING) {
                    MediaPlayerComponent.this.skip((double)PROGRESS.getValue() * 1.0 / (double)PROGRESS.getMaximum());
                    MediaPlayerComponent.this.setProgressValue(PROGRESS.getValue());
                }
            }
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.pauseSong();
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.back();
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.next();
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.stopSong();
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.play();
        }
    }
}

