/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotificationRenderer;
import com.limegroup.gnutella.gui.notify.NotificationWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DefaultNotificationRenderer
implements NotificationRenderer {
    private static final int TEXT_WIDTH = 200;
    private JPanel panel = new JPanel();
    private JLabel messageLabel;
    private JPanel actionPanel;

    public DefaultNotificationRenderer() {
        this.panel.setLayout(new BorderLayout());
        this.panel.setOpaque(false);
        JPanel messagePanel = new JPanel(new FlowLayout(3, 0, 0));
        messagePanel.setOpaque(false);
        this.messageLabel = new JLabel();
        this.messageLabel.setFont(new Font("SansSerif", 0, 12));
        messagePanel.add(this.messageLabel);
        this.panel.add((Component)messagePanel, "Center");
        this.actionPanel = new JPanel();
        this.actionPanel.setAlignmentX(1.0f);
        this.actionPanel.setOpaque(false);
        this.panel.add((Component)this.actionPanel, "South");
    }

    public Component getNotificationRendererComponent(NotificationWindow window, Object value, int index) {
        if (!(value instanceof Notification)) {
            this.messageLabel.setIcon(null);
            this.messageLabel.setText(GUIUtils.restrictWidth(value != null ? value.toString() : "", 200));
            this.actionPanel.removeAll();
        } else {
            Notification notification = (Notification)value;
            this.messageLabel.setIcon(notification.getIcon());
            this.messageLabel.setText(GUIUtils.restrictWidth(notification.getMessage(), 200));
            this.messageLabel.setMinimumSize(this.messageLabel.getPreferredSize());
            this.actionPanel.removeAll();
            if (notification.useVerticleActionOrientation()) {
                this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 1));
                this.actionPanel.add(Box.createVerticalStrut(10));
            } else {
                this.actionPanel.setLayout(new FlowLayout(3, 0, 0));
            }
            if (notification.getActions() != null) {
                for (Action action : notification.getActions()) {
                    URLLabel urlLabel = new URLLabel(action);
                    urlLabel.setFont(new Font("SansSerif", 0, 10));
                    this.actionPanel.add(urlLabel);
                    this.actionPanel.add(notification.useVerticleActionOrientation() ? Box.createVerticalStrut(5) : Box.createHorizontalStrut(5));
                }
            }
        }
        return this.panel;
    }
}

