/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneImpl;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.SaveDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import org.limewire.service.ErrorService;

class OptionsPaneFactory {
    private SaveDirPaneItem SAVE_ITEM;
    private SharedDirPaneItem SHARED_ITEM = new SharedDirPaneItem();

    OptionsPaneFactory() {
        this.SAVE_ITEM = new SaveDirPaneItem(this.SHARED_ITEM);
    }

    SharedDirPaneItem getSharedPane() {
        return this.SHARED_ITEM;
    }

    OptionsPane createOptionsPane(OptionsTreeNode node) {
        Class<? extends AbstractPaneItem>[] clazzes = node.getClasses();
        if (clazzes != null) {
            OptionsPaneImpl pane = new OptionsPaneImpl(node.getTitleKey());
            for (Class<? extends AbstractPaneItem> clazz : clazzes) {
                if (clazz == SaveDirPaneItem.class) {
                    pane.add(this.SAVE_ITEM);
                    continue;
                }
                if (clazz == SharedDirPaneItem.class) {
                    pane.add(this.SHARED_ITEM);
                    continue;
                }
                try {
                    pane.add(clazz.newInstance());
                }
                catch (Exception e) {
                    ErrorService.error(e);
                }
            }
            return pane;
        }
        throw new IllegalArgumentException("no options pane for this key: " + node.getTitleKey());
    }
}

