/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import java.io.IOException;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public class AudioPlayerPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Audio Options");
    public static final String LABEL = I18n.tr("You can choose which audio player to use.");
    private final String OPTION_LABEL = I18nMarker.marktr("Audio Player");
    private JTextField _playerField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public AudioPlayerPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.OPTION_LABEL, this._playerField);
        this.add(comp.getComponent());
    }

    public boolean applyOptions() throws IOException {
        URLHandlerSettings.AUDIO_PLAYER.setValue(this._playerField.getText());
        return false;
    }

    public boolean isDirty() {
        return !URLHandlerSettings.AUDIO_PLAYER.getValue().equals(this._playerField.getText());
    }

    public void initOptions() {
        this._playerField.setText(URLHandlerSettings.AUDIO_PLAYER.getValue());
    }
}

