/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class AutoClearDownloadsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Clear Downloads");
    public static final String LABEL = I18n.tr("You can choose whether or not to automatically clear downloads that have completed.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Clear Completed Downloads:");
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private boolean _clearDownloads;

    public AutoClearDownloadsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this._clearDownloads = SharingSettings.CLEAR_DOWNLOAD.getValue();
        this.CHECK_BOX.setSelected(this._clearDownloads);
    }

    public boolean applyOptions() throws IOException {
        boolean clearDownloads = this.CHECK_BOX.isSelected();
        if (clearDownloads != this._clearDownloads) {
            SharingSettings.CLEAR_DOWNLOAD.setValue(clearDownloads);
            this._clearDownloads = clearDownloads;
        }
        return false;
    }

    public boolean isDirty() {
        return SharingSettings.CLEAR_DOWNLOAD.getValue() != this.CHECK_BOX.isSelected();
    }
}

