/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class BugsPaneItem
extends AbstractPaneItem {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;
    private final String VIEW_EXAMPLE = I18n.tr("View Example");
    private final JCheckBox DEADLOCK_OPTION = new JCheckBox();
    private final JRadioButton SEND_BOX = new JRadioButton();
    private final JRadioButton REVIEW_BOX = new JRadioButton();
    private final JRadioButton DISCARD_BOX = new JRadioButton();
    private final ButtonGroup BGROUP = new ButtonGroup();

    public BugsPaneItem() {
        super(I18n.tr("Bug Reports"), I18n.tr("You can choose how bug reports should be sent. To view an example bug report, click 'View Example'. Choosing 'Always Send Immediately' will immediately contact the bug server when FrostWire encounters an internal error. Choosing 'Always Ask for Review' will tell FrostWire to ask for your approval before sending a bug to the bug server. Choosing 'Always Discard All Errors' will cause FrostWire to ignore all bugs (this is not recommended)."));
        JButton example = new JButton(this.VIEW_EXAMPLE);
        example.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Exception e = new Exception("Example Bug");
                LocalClientInfo info = localClientInfoFactory.createLocalClientInfo(e, Thread.currentThread().getName(), "Example", false);
                JTextArea textArea = new JTextArea(info.toBugReport());
                textArea.setColumns(50);
                textArea.setEditable(false);
                JScrollPane scroller = new JScrollPane(textArea);
                scroller.setBorder(BorderFactory.createEtchedBorder());
                scroller.setPreferredSize(new Dimension(500, 200));
                MessageService.instance().showMessage(scroller);
            }
        });
        this.SEND_BOX.setText(I18n.tr("Always Send Immediately"));
        this.REVIEW_BOX.setText(I18n.tr("Always Ask For Review"));
        this.DISCARD_BOX.setText(I18n.tr("Always Discard All Errors"));
        this.DEADLOCK_OPTION.setText(I18n.tr("Send Errors Automatically if FrostWire is Frozen"));
        this.BGROUP.add(this.SEND_BOX);
        this.BGROUP.add(this.REVIEW_BOX);
        this.BGROUP.add(this.DISCARD_BOX);
        this.add(this.SEND_BOX);
        this.add(this.REVIEW_BOX);
        this.add(this.DISCARD_BOX);
        if (!LimeWireUtils.isBetaRelease()) {
            this.add(this.DEADLOCK_OPTION);
        }
        this.add(this.getVerticalSeparator());
        this.add(this.getVerticalSeparator());
        JPanel examplePanel = new JPanel(new FlowLayout(1));
        examplePanel.add(example);
        GUIUtils.restrictSize(examplePanel, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(examplePanel);
    }

    public void initOptions() {
        if (BugSettings.IGNORE_ALL_BUGS.getValue()) {
            this.BGROUP.setSelected(this.DISCARD_BOX.getModel(), true);
        } else if (BugSettings.USE_BUG_SERVLET.getValue()) {
            this.BGROUP.setSelected(this.SEND_BOX.getModel(), true);
        } else {
            this.BGROUP.setSelected(this.REVIEW_BOX.getModel(), true);
        }
        this.DEADLOCK_OPTION.setSelected(BugSettings.SEND_DEADLOCK_BUGS.getValue());
    }

    public boolean applyOptions() throws IOException {
        ButtonModel bm = this.BGROUP.getSelection();
        if (bm.equals(this.DISCARD_BOX.getModel())) {
            BugSettings.IGNORE_ALL_BUGS.setValue(true);
        } else if (bm.equals(this.SEND_BOX.getModel())) {
            BugSettings.IGNORE_ALL_BUGS.setValue(false);
            BugSettings.USE_BUG_SERVLET.setValue(true);
        } else {
            BugSettings.IGNORE_ALL_BUGS.setValue(false);
            BugSettings.USE_BUG_SERVLET.setValue(false);
        }
        BugSettings.SEND_DEADLOCK_BUGS.setValue(this.DEADLOCK_OPTION.isSelected());
        return false;
    }

    public boolean isDirty() {
        if (this.DEADLOCK_OPTION.isSelected() != BugSettings.SEND_DEADLOCK_BUGS.getValue()) {
            return true;
        }
        if (this.BGROUP.getSelection().equals(this.DISCARD_BOX.getModel())) {
            return !BugSettings.IGNORE_ALL_BUGS.getValue();
        }
        if (this.BGROUP.getSelection().equals(this.SEND_BOX.getModel())) {
            return BugSettings.IGNORE_ALL_BUGS.getValue() || !BugSettings.USE_BUG_SERVLET.getValue();
        }
        return BugSettings.IGNORE_ALL_BUGS.getValue() || BugSettings.USE_BUG_SERVLET.getValue();
    }
}

