/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class ConnectOnStartupPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Connect on Startup");
    public static final String LABEL = I18n.tr("You can choose whether or not to automatically connect to the network when the application starts up.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Connect on Startup:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public ConnectOnStartupPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(ConnectionSettings.CONNECT_ON_STARTUP.getValue());
    }

    public boolean applyOptions() throws IOException {
        ConnectionSettings.CONNECT_ON_STARTUP.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    public boolean isDirty() {
        return ConnectionSettings.CONNECT_ON_STARTUP.getValue() != this.CHECK_BOX.isSelected();
    }
}

