/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.limewire.i18n.I18nMarker;

public final class ConnectionPreferencingPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Connection Preferencing");
    public static final String LABEL = I18n.tr("You can limit who is able to connect to you based on the number of files they share.");
    private final String BOX_LABEL_KEY = I18nMarker.marktr("Files You Must Share to Not be a Freeloader:");
    private final String SLIDER_LABEL_KEY = I18nMarker.marktr("Allow Freeloaders:");
    private final String SLIDER_MIN_LABEL_KEY = I18nMarker.marktr("Rarely");
    private final String SLIDER_MAX_LABEL_KEY = I18nMarker.marktr("Always");
    private final WholeNumberField FILES_FIELD = new SizedWholeNumberField(SharingSettings.FREELOADER_FILES.getValue(), 3, GUIUtils.SizePolicy.RESTRICT_BOTH);
    private JSlider _slider;

    public ConnectionPreferencingPaneItem() {
        super(TITLE, LABEL);
        int MIN_VALUE = 10;
        int MAX_VALUE = 100;
        int initialValue = Math.max(10, SharingSettings.FREELOADER_ALLOWED.getValue());
        this._slider = new JSlider(10, 100, initialValue);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        String labelMinStr = I18n.tr(this.SLIDER_MIN_LABEL_KEY);
        String labelMaxStr = I18n.tr(this.SLIDER_MAX_LABEL_KEY);
        JLabel minLabel = new JLabel(labelMinStr);
        JLabel maxLabel = new JLabel(labelMaxStr);
        labels.put(new Integer(10), minLabel);
        labels.put(new Integer(100), maxLabel);
        this._slider.setLabelTable(labels);
        this._slider.setPaintLabels(true);
        LabeledComponent comp0 = new LabeledComponent(this.BOX_LABEL_KEY, this.FILES_FIELD, 120, 10);
        LabeledComponent comp1 = new LabeledComponent(this.SLIDER_LABEL_KEY, this._slider, 120, 10);
        this.add(comp0.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(comp1.getComponent());
    }

    public void initOptions() {
        this.FILES_FIELD.setValue(SharingSettings.FREELOADER_FILES.getValue());
        this._slider.setValue(SharingSettings.FREELOADER_ALLOWED.getValue());
    }

    public boolean applyOptions() throws IOException {
        try {
            SharingSettings.FREELOADER_FILES.setValue(this.FILES_FIELD.getValue());
            SharingSettings.FREELOADER_ALLOWED.setValue(this._slider.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public boolean isDirty() {
        return SharingSettings.FREELOADER_FILES.getValue() != this.FILES_FIELD.getValue() || SharingSettings.FREELOADER_ALLOWED.getValue() != this._slider.getValue();
    }
}

