/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public class DefaultActionPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("File Already Exists Behavior");
    public static final String LABEL = I18n.tr("You can choose the default action that FrostWire will perform when you try to download a file that already exists on disk.");
    private JRadioButton saveAs;
    private JRadioButton append;
    private JRadioButton ask;

    public DefaultActionPaneItem() {
        super(TITLE, LABEL);
        BoxPanel buttonPanel = new BoxPanel();
        String saveAsLabel = I18nMarker.marktr("Always Show the 'Save As' Dialog");
        String appendLabel = I18nMarker.marktr("Always Append (#) to the Filename");
        String askLabel = I18nMarker.marktr("Always Ask What to do");
        this.saveAs = new JRadioButton(I18n.tr(saveAsLabel));
        this.append = new JRadioButton(I18n.tr(appendLabel));
        this.ask = new JRadioButton(I18n.tr(askLabel));
        ButtonGroup bg = new ButtonGroup();
        buttonPanel.add(this.ask);
        buttonPanel.add(this.saveAs);
        buttonPanel.add(this.append);
        bg.add(this.ask);
        bg.add(this.saveAs);
        bg.add(this.append);
        BoxPanel mainPanel = new BoxPanel(0);
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createHorizontalGlue());
        this.add(mainPanel);
    }

    public boolean applyOptions() throws IOException {
        if (this.ask.isSelected()) {
            QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(0);
        } else if (this.append.isSelected()) {
            QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(1);
        } else if (this.saveAs.isSelected()) {
            QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(2);
        }
        return false;
    }

    public void initOptions() {
        int index = QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue();
        if (index == 0) {
            this.ask.setSelected(true);
        } else if (index == 1) {
            this.append.setSelected(true);
        } else if (index == 2) {
            this.saveAs.setSelected(true);
        }
    }

    public boolean isDirty() {
        int index = -1;
        if (this.ask.isSelected()) {
            index = 0;
        } else if (this.append.isSelected()) {
            index = 1;
        } else if (this.saveAs.isSelected()) {
            index = 2;
        }
        return QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue() != index;
    }
}

