/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class DisableCapabilitiesPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Capabilities");
    public static final String LABEL = I18n.tr("If your computer has a fast internet connection, FrostWire may act as an \"Ultrapeer\" and/or connect to the Mojito DHT.  FrostWire can also use a secure communications mode called TLS, which may use more CPU resources.  You can disable these if needed.");
    private final JCheckBox UP_CHECK_BOX = new JCheckBox();
    private final JCheckBox DHT_CHECK_BOX = new JCheckBox();
    private final JCheckBox TLS_CHECK_BOX = new JCheckBox();

    public DisableCapabilitiesPaneItem() {
        super(TITLE, LABEL);
        this.add(new LabeledComponent(I18nMarker.marktr("Disable Ultrapeer Capabilities:"), this.UP_CHECK_BOX, 120).getComponent());
        this.add(new LabeledComponent(I18nMarker.marktr("Disable Mojito DHT Capabilities:"), this.DHT_CHECK_BOX, 120).getComponent());
        if (!SSLSettings.isTLSDisabled()) {
            this.add(new LabeledComponent(I18nMarker.marktr("Disable TLS Capabilities:"), this.TLS_CHECK_BOX, 120).getComponent());
        }
    }

    public void initOptions() {
        this.UP_CHECK_BOX.setSelected(UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue());
        this.DHT_CHECK_BOX.setSelected(DHTSettings.DISABLE_DHT_USER.getValue());
        this.TLS_CHECK_BOX.setSelected(!SSLSettings.TLS_INCOMING.getValue() || !SSLSettings.TLS_OUTGOING.getValue());
    }

    public boolean applyOptions() throws IOException {
        boolean upChanged = UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() != this.UP_CHECK_BOX.isSelected();
        boolean tlsServerChanged = this.TLS_CHECK_BOX.isSelected() != !SSLSettings.TLS_INCOMING.getValue();
        boolean isSupernode = GuiCoreMediator.getConnectionServices().isSupernode();
        UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(this.UP_CHECK_BOX.isSelected());
        DHTSettings.DISABLE_DHT_USER.setValue(this.DHT_CHECK_BOX.isSelected());
        SSLSettings.TLS_INCOMING.setValue(!this.TLS_CHECK_BOX.isSelected());
        SSLSettings.TLS_OUTGOING.setValue(!this.TLS_CHECK_BOX.isSelected());
        if (tlsServerChanged || upChanged && this.UP_CHECK_BOX.isSelected() && isSupernode) {
            GuiCoreMediator.getConnectionServices().disconnect();
            GuiCoreMediator.getConnectionServices().connect();
        }
        return false;
    }

    public boolean isDirty() {
        return UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() != this.UP_CHECK_BOX.isSelected() || DHTSettings.DISABLE_DHT_USER.getValue() != this.DHT_CHECK_BOX.isSelected() || (!SSLSettings.TLS_INCOMING.getValue() && !SSLSettings.TLS_OUTGOING.getValue()) != this.TLS_CHECK_BOX.isSelected();
    }
}

