/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class DisableOOBSearchingPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("OOB Searching");
    public static final String LABEL = I18n.tr("Out-Of-Band Searching results in faster result delivery to your client, though some internet connections may not work well with this feature.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Enable OOB Searching:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public DisableOOBSearchingPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(SearchSettings.OOB_ENABLED.getValue());
    }

    public boolean applyOptions() throws IOException {
        SearchSettings.OOB_ENABLED.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    public boolean isDirty() {
        return SearchSettings.OOB_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

