/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.FilterSettings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public final class IgnoreResultsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Filter Results");
    public static final String LABEL = I18n.tr("You can filter out search results containing specific words.");
    private final ListEditor RESULTS_LIST = new ListEditor();

    public IgnoreResultsPaneItem() {
        super(TITLE, LABEL);
        this.add(this.RESULTS_LIST);
    }

    public void initOptions() {
        String[] bannedWords = FilterSettings.BANNED_WORDS.getValue();
        this.RESULTS_LIST.setModel(new Vector<String>(Arrays.asList(bannedWords)));
    }

    public boolean applyOptions() throws IOException {
        Vector<String> model = this.RESULTS_LIST.getModel();
        Object[] bannedResults = new String[model.size()];
        model.copyInto(bannedResults);
        FilterSettings.BANNED_WORDS.setValue((String[])bannedResults);
        GuiCoreMediator.getSpamServices().adjustSpamFilters();
        return false;
    }

    public boolean isDirty() {
        List<String> model = Arrays.asList(FilterSettings.BANNED_WORDS.getValue());
        return !((Object)model).equals(this.RESULTS_LIST.getModel());
    }
}

