/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.UploadSettings;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;

public final class MaximumUploadsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Max Upload Slots");
    public static final String LABEL = I18n.tr("Never allow more than this many uploads. This value will only be reached if you have enough bandwidth.");
    private final String OPTION_LABEL = I18nMarker.marktr("Max Upload Slots:");
    private WholeNumberField _maxUploadsField = new SizedWholeNumberField();
    private int _maximumUploads;

    public MaximumUploadsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.OPTION_LABEL, this._maxUploadsField, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this._maximumUploads = UploadSettings.HARD_MAX_UPLOADS.getValue();
        this._maxUploadsField.setValue(this._maximumUploads);
    }

    public boolean applyOptions() throws IOException {
        int maxUploads = this._maxUploadsField.getValue();
        if (maxUploads != this._maximumUploads) {
            UploadSettings.HARD_MAX_UPLOADS.setValue(maxUploads);
            this._maximumUploads = maxUploads;
        }
        return false;
    }

    public boolean isDirty() {
        return UploadSettings.HARD_MAX_UPLOADS.getValue() != this._maxUploadsField.getValue();
    }
}

