/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.limewire.setting.FileSetting;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeDownloadDirDataLine
extends AbstractDataLine<NamedMediaType> {
    private String dir;
    private FileSetting setting;
    private boolean isReset;
    private String defaultDir;
    private static final LimeTableColumn[] columns = new LimeTableColumn[]{new LimeTableColumn(0, "OPTIONS_SAVE_MEDIATYPE", I18n.tr("Media Type"), 60, true, IconAndNameHolder.class), new LimeTableColumn(1, "OPTIONS_SAVE_DIRECTORY", I18n.tr("Save Folder"), 100, true, String.class)};

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    public void setDefaultDir(String text) {
        this.defaultDir = text;
    }

    public void reset() {
        this.dir = null;
        this.isReset = true;
    }

    public void saveDirectory(Set<? super File> newDirs) {
        boolean dirty = this.isDirty();
        if (this.isReset) {
            this.setting.revertToDefault();
        } else if (this.dir != null && !this.setting.getValue().equals(new File(this.dir))) {
            this.setting.setValue(new File(this.dir));
        }
        if (dirty) {
            newDirs.add(this.setting.getValue());
        }
    }

    @Override
    public LimeTableColumn getColumn(int col) {
        return columns[col];
    }

    @Override
    public boolean isDynamic(int col) {
        return false;
    }

    @Override
    public boolean isClippable(int col) {
        return true;
    }

    @Override
    public void initialize(NamedMediaType obj) {
        super.initialize(obj);
        this.setting = SharingSettings.getFileSettingForMediaType(((NamedMediaType)this.initializer).getMediaType());
        this.isReset = false;
    }

    @Override
    public Object getValueAt(int col) {
        switch (col) {
            case 0: {
                return this.initializer;
            }
            case 1: {
                return this.getVisibleDirectoryString();
            }
        }
        return null;
    }

    boolean isDirty() {
        return this.dir != null && !this.setting.getValue().equals(new File(this.dir));
    }

    public void setDirectory(File dir) {
        if (!SaveDirectoryHandler.isSaveDirectoryValid(dir)) {
            GUIMediator.showError(I18n.tr("The selected save folder is invalid. You may not have permissions to write to the selected folder. FrostWire will revert to your previously selected folder."));
            return;
        }
        if (!SaveDirectoryHandler.showVistaWarningIfNeeded(dir)) {
            return;
        }
        try {
            String newDir;
            this.dir = newDir = FileUtils.getCanonicalPath(dir);
            this.isReset = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getVisibleDirectoryString() {
        if (this.dir != null) {
            return this.dir;
        }
        if (this.isReset || this.setting.isDefault()) {
            return this.defaultDir;
        }
        return this.setting.getValue().getAbsolutePath();
    }

    String getDirectory() {
        return this.dir;
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }
}

