/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.PlayerSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class PlayerPreferencePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Player Options");
    public static final String LABEL = I18n.tr("You can choose to play media with FrostWire or your system's default player. The media player and playlist will appear only if this option is set. A restart will be required when enabling or disabling the media controls.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Use FrostWire Media Player:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public PlayerPreferencePaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(PlayerSettings.PLAYER_ENABLED.getValue());
    }

    public boolean applyOptions() throws IOException {
        GUIMediator.instance().setPlayerEnabled(this.CHECK_BOX.isSelected());
        return false;
    }

    public boolean isDirty() {
        return PlayerSettings.PLAYER_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

